/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.git;

import com.mastfrog.util.strings.Strings;
import com.telenav.cactus.git.GitRemotes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class Heads
implements Iterable<Head> {
    private final Set<Head> heads;
    private final Optional<String> remoteUrl;

    public static Heads from(String text) {
        HashSet<Head> heads = new HashSet<Head>();
        Optional<String> remoteUrl = Optional.empty();
        for (String line : text.split("\n")) {
            if ((line = line.trim()).isEmpty() || line.charAt(0) == '#') continue;
            if (line.startsWith("From ")) {
                remoteUrl = Optional.of(line.substring(5).trim());
                continue;
            }
            String[] parts = line.split("\\s+");
            if (parts.length != 2) continue;
            String hash = parts[0];
            String ref = parts[1];
            Head.from(ref, hash).ifPresent(heads::add);
        }
        return new Heads(remoteUrl, heads);
    }

    Heads(Optional<String> remoteUrl, Set<Head> heads) {
        this.heads = heads;
        this.remoteUrl = remoteUrl;
    }

    public Optional<Head> findBranch(String name) {
        for (Head head : this.heads) {
            if (!head.isBranch() || !head.is(name)) continue;
            return Optional.of(head);
        }
        return Optional.empty();
    }

    public boolean isFrom(GitRemotes remote) {
        return this.remoteUrl.filter(s -> s.equals(remote.fetchUrl) || s.equals(remote.pushUrl)).isPresent();
    }

    @Override
    public Iterator<Head> iterator() {
        return Collections.unmodifiableSet(this.heads).iterator();
    }

    public Optional<String> remoteUrl() {
        return this.remoteUrl;
    }

    public String toString() {
        ArrayList<Head> all = new ArrayList<Head>(this.heads);
        Collections.sort(all);
        return Strings.join((char)'\n', all);
    }

    public static class Head
    implements Comparable<Head> {
        private final String[] refParts;
        private final String hash;

        public static Optional<Head> from(String ref, String hash) {
            String[] parts = ref.split("/");
            if (parts.length <= 2) {
                return Optional.empty();
            }
            for (int i = 0; i < hash.length(); ++i) {
                if (Head.isHashChar(hash.charAt(i))) continue;
                return Optional.empty();
            }
            return Optional.of(new Head(parts, hash));
        }

        public Head(String[] refParts, String hash) {
            this.refParts = refParts;
            this.hash = hash;
        }

        @Override
        public int compareTo(Head o) {
            int result = this.name().compareTo(o.name());
            if (result == 0) {
                result = this.hash.compareTo(o.hash);
            }
            if (result == 0) {
                result = this.kind().compareTo(o.kind());
            }
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Head other = (Head)obj;
            if (!Objects.equals(this.hash, other.hash)) {
                return false;
            }
            return Arrays.deepEquals(this.refParts, other.refParts);
        }

        public int hashCode() {
            int result = 7;
            result = 17 * result + Arrays.deepHashCode(this.refParts);
            result = 17 * result + Objects.hashCode(this.hash);
            return result;
        }

        public boolean is(String what) {
            return this.name().equals(what);
        }

        public boolean isBranch() {
            return "heads".equals(this.kind());
        }

        public boolean isTag() {
            return "tags".equals(this.kind());
        }

        public String kind() {
            return this.refParts[1];
        }

        public String name() {
            StringBuilder sb = new StringBuilder();
            for (String part : this.refParts) {
                if (sb.length() > 0) {
                    sb.append('/');
                }
                sb.append(part);
            }
            return sb.toString();
        }

        public String toString() {
            return this.hash + "\t" + Strings.join((char)'/', (String[])this.refParts);
        }

        private static boolean isHashChar(char c) {
            return c >= 'a' && c <= 'f' || c >= '0' && c <= '9';
        }
    }
}

