/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.git;

import com.telenav.cactus.git.GitCheckout;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class SubmoduleStatus {
    static final Pattern SUBMODULE_STATUS_LINE = Pattern.compile("^([ +])([a-f\\d]+)\\s+(\\S+)\\s+\\((\\S+)\\)\\s*$");
    public final boolean modifications;
    public final String commitId;
    public final String modulePath;
    public final String branchOrTagInfo;
    public final Path path;
    public final boolean exists;

    public static Optional<SubmoduleStatus> from(Path root, String line) {
        if (line.isBlank()) {
            return Optional.empty();
        }
        Matcher m = SUBMODULE_STATUS_LINE.matcher(line);
        if (m.find()) {
            boolean modifications = "+".equals(m.group(1));
            String id = m.group(2);
            String modulePath = m.group(3);
            String info = m.group(4);
            Path dir = root.resolve(modulePath);
            return Optional.of(new SubmoduleStatus(modifications, id, modulePath, info, dir, Files.exists(dir, new LinkOption[0])));
        }
        return Optional.empty();
    }

    public static List<SubmoduleStatus> fromStatusOutput(Path root, String output) {
        ArrayList<SubmoduleStatus> result = new ArrayList<SubmoduleStatus>();
        for (String line : output.split("\n")) {
            SubmoduleStatus.from(root, line).ifPresent(result::add);
        }
        return result;
    }

    public SubmoduleStatus(boolean modifications, String commitId, String modulePath, String branchOrTagInfo, Path path, boolean exists) {
        this.modifications = modifications;
        this.commitId = commitId;
        this.modulePath = modulePath;
        this.branchOrTagInfo = branchOrTagInfo;
        this.path = path;
        this.exists = exists;
    }

    public boolean is(GitCheckout git) {
        return this.exists && git.checkoutRoot().equals(this.path);
    }

    public Optional<GitCheckout> checkout() {
        return this.exists ? Optional.of(new GitCheckout(this.path)) : Optional.empty();
    }

    public String toString() {
        return (this.modifications ? "+" : " ") + this.commitId + " " + this.modulePath + " (" + this.branchOrTagInfo + ") <- " + this.path + " " + (this.exists ? "ok" : "?");
    }
}

