/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.github;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mastfrog.function.throwing.io.IOFunction;
import com.mastfrog.util.preconditions.Exceptions;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

public class MinimalPRItem {
    public final String baseRefName;
    public final String body;
    public final String headRefName;
    public final String mergeable;
    public final long number;
    public final String state;
    public final String title;
    public final String url;

    @JsonCreator
    public MinimalPRItem(@JsonProperty(value="baseRefName") String baseRefName, @JsonProperty(value="body", required=false) String body, @JsonProperty(value="headRefName") String headRefName, @JsonProperty(value="mergeable") String mergeable, @JsonProperty(value="number") long number, @JsonProperty(value="state") String state, @JsonProperty(value="title", required=false) String title, @JsonProperty(value="url") String url) {
        this.baseRefName = baseRefName;
        this.body = body;
        this.headRefName = headRefName;
        this.mergeable = mergeable;
        this.number = number;
        this.state = state;
        this.title = title;
        this.url = url;
    }

    public URI toURI() {
        return URI.create(this.url);
    }

    public boolean isMergeable() {
        return "MERGEABLE".equals(this.mergeable);
    }

    public boolean isOpen() {
        return "OPEN".equals(this.state);
    }

    public static List<MinimalPRItem> parse(String output) throws IOException {
        if ("[]".equals(output.trim())) {
            return Collections.emptyList();
        }
        return Arrays.asList((MinimalPRItem[])new ObjectMapper().readValue(output, MinimalPRItem[].class));
    }

    public static Function<String, List<MinimalPRItem>> parser() {
        IOFunction raw = MinimalPRItem::parse;
        return raw.toNonThrowing();
    }

    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString((Object)this);
        }
        catch (JsonProcessingException ex) {
            return (String)Exceptions.chuck((Throwable)ex);
        }
    }

    public int hashCode() {
        int hash = 7;
        hash = 73 * hash + Objects.hashCode(this.baseRefName);
        hash = 73 * hash + Objects.hashCode(this.headRefName);
        hash = 73 * hash + (int)(this.number ^ this.number >>> 32);
        hash = 73 * hash + Objects.hashCode(this.url);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MinimalPRItem other = (MinimalPRItem)obj;
        if (this.number != other.number) {
            return false;
        }
        if (!Objects.equals(this.baseRefName, other.baseRefName)) {
            return false;
        }
        if (!Objects.equals(this.headRefName, other.headRefName)) {
            return false;
        }
        return Objects.equals(this.url, other.url);
    }
}

