/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.git;

import com.mastfrog.function.optional.ThrowingOptional;
import com.mastfrog.function.throwing.io.IOSupplier;
import com.mastfrog.util.preconditions.Checks;
import com.mastfrog.util.preconditions.Exceptions;
import com.telenav.cactus.cli.ProcessFailedException;
import com.telenav.cactus.cli.ProcessResultConverter;
import com.telenav.cactus.git.Branches;
import com.telenav.cactus.git.CommitInfo;
import com.telenav.cactus.git.Conflicts;
import com.telenav.cactus.git.GitCommand;
import com.telenav.cactus.git.GitRemotes;
import com.telenav.cactus.git.Heads;
import com.telenav.cactus.git.NeedPushResult;
import com.telenav.cactus.git.SubmoduleStatus;
import com.telenav.cactus.github.GithubCommand;
import com.telenav.cactus.github.MergePullRequestOptions;
import com.telenav.cactus.github.MinimalPRItem;
import com.telenav.cactus.maven.log.BuildLog;
import com.telenav.cactus.util.PathUtils;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;

public final class GitCheckout
implements Comparable<GitCheckout> {
    private static final DateTimeFormatter GIT_LOG_FORMAT = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4).appendLiteral("-").appendValue(ChronoField.MONTH_OF_YEAR, 2).appendLiteral("-").appendValue(ChronoField.DAY_OF_MONTH, 2).appendLiteral(' ').appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).appendLiteral(' ').appendOffset("+HHMM", "+0000").parseLenient().toFormatter();
    public static final DateTimeFormatter ISO_INSTANT = new DateTimeFormatterBuilder().parseCaseInsensitive().appendInstant().toFormatter(Locale.US);
    private static final GitCommand<String> GET_BRANCH = new GitCommand(ProcessResultConverter.strings().trimmed(), new String[]{"rev-parse", "--abbrev-ref", "HEAD"});
    private static final GitCommand<String> GET_HEAD = new GitCommand(ProcessResultConverter.strings().trimmed(), new String[]{"rev-parse", "HEAD"});
    private static final GitCommand<Boolean> UPDATE_REMOTE_HEADS = new GitCommand(ProcessResultConverter.exitCodeIsZero(), "remote", "update");
    private static final GitCommand<Boolean> FETCH_ALL = new GitCommand(ProcessResultConverter.exitCodeIsZero(), "fetch", "--all");
    private static final GitCommand<Boolean> FETCH = new GitCommand(ProcessResultConverter.exitCodeIsZero(), "fetch");
    private static final GitCommand<Boolean> NO_MODIFICATIONS = new GitCommand(ProcessResultConverter.strings().trimmed().trueIfEmpty(), "status", "--porcelain");
    private static final GitCommand<Map<String, GitRemotes>> LIST_REMOTES = new GitCommand(ProcessResultConverter.strings().trimmed().map(GitRemotes::from), "remote", "-v");
    private static final GitCommand<Branches> ALL_BRANCHES = new GitCommand(ProcessResultConverter.strings().trimmed().map(Branches::from), "branch", "--no-color", "-a");
    private static final GitCommand<Heads> REMOTE_HEADS = new GitCommand(ProcessResultConverter.strings().trimmed().map(Heads::from), "ls-remote");
    private static final GitCommand<Boolean> IS_DIRTY = new GitCommand(ProcessResultConverter.exitCode(code -> code != 0), "diff", "--quiet", "--ignore-submodules=dirty");
    private static final GitCommand<Boolean> IS_DIRTY_IGNORING_SUBMODULES = new GitCommand(ProcessResultConverter.exitCode(code -> code != 0), "diff", "--quiet", "--ignore-submodules=dirty");
    private static final GitCommand<String> ADD_CHANGED = new GitCommand(ProcessResultConverter.strings(), new String[]{"add", "--all"});
    private static final GitCommand<String> PULL = new GitCommand(ProcessResultConverter.strings(), new String[]{"pull", "--no-rebase"});
    private static final GitCommand<String> PULL_REBASE = new GitCommand(ProcessResultConverter.strings(), new String[]{"pull", "--rebase"});
    private static final GitCommand<String> PUSH = new GitCommand(ProcessResultConverter.strings(), new String[]{"push"});
    private static final GitCommand<String> PUSH_ALL = new GitCommand(ProcessResultConverter.strings(), new String[]{"push", "--all"});
    private static final GitCommand<String> GC = new GitCommand(ProcessResultConverter.strings(), new String[]{"gc", "--aggressive"});
    private static final GitCommand<List<String>> TAGS = new GitCommand(ProcessResultConverter.strings().lines(), "tag", "-l");
    private static final GitCommand<Boolean> HAS_UNKNOWN_FILES = new GitCommand(ProcessResultConverter.strings().trimmed().map(str -> str.length() > 0), "ls-files", "--others", "--no-empty-directory", "--exclude-standard");
    private static final GitCommand<Boolean> IS_DETACHED_HEAD = new GitCommand(ProcessResultConverter.strings().testedWith(text -> text.contains("(detached)")), "status", "--porcelain=2", "--branch");
    private static final ZoneId GMT = ZoneId.of("GMT");
    private final BuildLog log = BuildLog.get();
    private final Path root;
    private final GitCommand<Optional<ZonedDateTime>> commitDate = new GitCommand(ProcessResultConverter.strings().trimmed().map(this::fromGitLogFormat), "log", "-1", "--format=format:%cd", "--date=iso", "--no-color", "--encoding=utf8");
    private final GitCommand<List<SubmoduleStatus>> listSubmodules = new GitCommand(ProcessResultConverter.strings().trimmed().map(this::parseSubmoduleInfo), "submodule", "status");

    public static Optional<GitCheckout> checkout(Path dirOrFile) {
        return PathUtils.findGitCheckoutRoot((Path)dirOrFile, (boolean)false).map(GitCheckout::new);
    }

    public static Optional<GitCheckout> checkout(File dir) {
        return GitCheckout.checkout(dir.toPath());
    }

    public static int depthFirstCompare(GitCheckout a, GitCheckout b) {
        int result = Integer.compare(b.checkoutRoot().getNameCount(), a.checkoutRoot().getNameCount());
        if (result == 0) {
            result = a.checkoutRoot().getFileName().compareTo(b.checkoutRoot().getFileName());
        }
        return result;
    }

    public static List<GitCheckout> depthFirstSort(Collection<? extends GitCheckout> all) {
        ArrayList<GitCheckout> checkouts = new ArrayList<GitCheckout>(all);
        checkouts.sort(GitCheckout::depthFirstCompare);
        return checkouts;
    }

    public static <R> List<Map.Entry<GitCheckout, R>> depthFirstSort(Map<GitCheckout, R> pushTypeForCheckout) {
        ArrayList<Map.Entry<GitCheckout, R>> needingPush = new ArrayList<Map.Entry<GitCheckout, R>>(pushTypeForCheckout.entrySet());
        needingPush.sort((a, b) -> GitCheckout.depthFirstCompare((GitCheckout)a.getKey(), (GitCheckout)b.getKey()));
        return needingPush;
    }

    public static boolean isGitCommitId(String what) {
        if (what == null) {
            return false;
        }
        if (what.length() != 40) {
            return false;
        }
        for (int i = 0; i < what.length(); ++i) {
            char c = what.charAt(i);
            if (c >= '0' && c <= '9' || c >= 'a' && c <= 'f') continue;
            return false;
        }
        return true;
    }

    public static Set<GitCheckout> ownersOf(Collection<? extends Path> paths) {
        HashSet<GitCheckout> result = new HashSet<GitCheckout>();
        for (Path path : paths) {
            GitCheckout.checkout(path).ifPresent(result::add);
        }
        return result;
    }

    public static Optional<GitCheckout> submodulesRoot(Path dirOrFile) {
        return PathUtils.findGitCheckoutRoot((Path)dirOrFile, (boolean)false).map(GitCheckout::new);
    }

    GitCheckout(Path root) {
        this.root = ((Path)Checks.notNull((String)"root", (Object)root)).normalize();
    }

    public boolean isNotAtSameHeadAsBranch(String otherBranch) {
        GitCommand isDirtyRelative = new GitCommand(ProcessResultConverter.exitCode(code -> code != 0), this.checkoutRoot(), "diff", "--quiet", "-r", (String)Checks.notNull((String)"otherBranch", (Object)otherBranch));
        return (Boolean)isDirtyRelative.run().awaitQuietly();
    }

    /*
     * WARNING - void declaration
     */
    public boolean add(Collection<? extends Path> paths) {
        ArrayList<String> list = new ArrayList<String>(List.of("add"));
        for (Path path : paths) {
            void var4_4;
            if (path.isAbsolute()) {
                Path path2 = this.root.relativize(path);
            }
            list.add(var4_4.toString());
        }
        GitCommand cmd = new GitCommand(ProcessResultConverter.strings(), this.root, (String[])list.toArray(String[]::new));
        String string = (String)cmd.run().awaitQuietly();
        this.log.info(string);
        return true;
    }

    public boolean addAll() {
        ADD_CHANGED.withWorkingDir(this.root).run().awaitQuietly();
        return true;
    }

    public void allPomFilesInSubtree(Consumer<Path> pomConsumer) throws IOException {
        Path pom = Paths.get("pom.xml", new String[0]);
        try (Stream<Path> str = Files.walk(this.root, new FileVisitOption[0]).filter(path -> path.getFileName().equals(pom));){
            str.forEach(pomConsumer);
        }
    }

    public void allPomFilesInSubtreeParallel(Consumer<Path> pomConsumer) throws IOException {
        Path pom = Paths.get("pom.xml", new String[0]);
        try (Stream<Path> str = ((Stream)Files.walk(this.root, new FileVisitOption[0]).parallel()).filter(path -> path.getFileName().equals(pom));){
            str.forEach(pomConsumer);
        }
    }

    public Collection<? extends GitRemotes> allRemotes() {
        return ((Map)LIST_REMOTES.withWorkingDir(this.root).run().awaitQuietly()).values();
    }

    public Optional<String> branch() {
        String branch;
        switch (branch = (String)GET_BRANCH.withWorkingDir(this.root).run().awaitQuietly()) {
            case "HEAD": {
                return Optional.empty();
            }
        }
        return Optional.of(branch);
    }

    public Branches branches() {
        return (Branches)ALL_BRANCHES.withWorkingDir(this.root).run().awaitQuietly();
    }

    public List<String> tags() {
        return (List)TAGS.withWorkingDir(this.root).run().awaitQuietly();
    }

    public Branches branchesContainingCommit(String commitHash) {
        GitCommand targets = new GitCommand(ProcessResultConverter.strings().trimmed().map(Branches::from), this.checkoutRoot(), "branch", "--no-color", "--all", "--contains=" + commitHash);
        return (Branches)targets.run().awaitQuietly();
    }

    public boolean pushTag(String tag) {
        Optional<GitRemotes> remote = this.defaultRemote();
        if (!remote.isPresent()) {
            return false;
        }
        GitCommand cmd = new GitCommand(ProcessResultConverter.exitCodeIsZero(), this.checkoutRoot(), "push", remote.get().name(), tag);
        return (Boolean)cmd.run().awaitQuietly();
    }

    public Conflicts checkForConflicts() {
        Optional<String> branch = this.branch();
        if (!branch.isPresent()) {
            throw new IllegalStateException(this.loggingName() + " is not on a branch - cannot check for merge conflicts");
        }
        String remote = null;
        String branchName = branch.get();
        Optional<String> mergeBase = this.mergeBaseBetween("FETCH_HEAD", branchName);
        if (!mergeBase.isPresent() && !(mergeBase = this.mergeBaseBetween("FETCH_HEAD", (remote = this.defaultRemote().get().name()) + "/" + branchName)).isPresent()) {
            return Conflicts.EMPTY;
        }
        GitCommand inMemoryDiff = new GitCommand(ProcessResultConverter.strings(), this.checkoutRoot(), new String[]{"merge-tree", mergeBase.get(), branchName, "FETCH_HEAD"});
        String diff = (String)inMemoryDiff.run().awaitQuietly();
        return Conflicts.parse(diff);
    }

    public Optional<String> mergeBaseBetween(String from, String to) {
        try {
            GitCommand fetchHeadCmd = new GitCommand(ProcessResultConverter.strings().trimmed(), this.checkoutRoot(), new String[]{"merge-base", from, to});
            String mergeBase = (String)fetchHeadCmd.run().awaitQuietly();
            return Optional.of(mergeBase);
        }
        catch (ProcessFailedException ex) {
            try {
                String rem = this.defaultRemote().get().name();
                GitCommand fetchHeadCmd = new GitCommand(ProcessResultConverter.strings().trimmed(), this.checkoutRoot(), new String[]{"merge-base", from, rem + "/" + to});
                String mergeBase = (String)fetchHeadCmd.run().awaitQuietly();
                return Optional.of(mergeBase);
            }
            catch (ProcessFailedException ex2) {
                ex.addSuppressed((Throwable)ex2);
                this.log.debug("Could not find local or remote fetch head " + from + " --> " + to, (Throwable)ex);
                return Optional.empty();
            }
        }
    }

    private static String goodEnoughNonce() {
        return Long.toString(System.currentTimeMillis(), 36) + Integer.toString(Math.abs(ThreadLocalRandom.current().nextInt()), 36);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Conflicts canMergeWorkingTree() {
        Conflicts result;
        block33: {
            Optional<String> branch = this.branch();
            if (!branch.isPresent()) {
                throw new IllegalStateException(this.loggingName() + " is not on a branch - cannot check for merge conflicts");
            }
            boolean wasDirty = this.isDirty();
            boolean hadUntrackedFiles = this.hasUntrackedFiles();
            if (!wasDirty && !hadUntrackedFiles) {
                return Conflicts.EMPTY;
            }
            this.log.debug(() -> this.loggingName() + " DIRTY? " + wasDirty + " UNTRACKED? " + hadUntrackedFiles);
            String origBranch = branch.get();
            String tempBranch = "_conflicttest-" + GitCheckout.goodEnoughNonce();
            boolean committed = false;
            Throwable thrown = null;
            result = Conflicts.EMPTY;
            this.log.debug(() -> "create temp branch " + tempBranch + " for " + this.loggingName());
            boolean branched = this.createAndSwitchToBranch(tempBranch, Optional.empty());
            if (branched) {
                this.log.debug(() -> "  add all in " + this.loggingName());
                boolean added = this.addAll();
                if (!added) {
                    throw new IllegalStateException("Add all failed after creating branch " + tempBranch);
                }
                this.log.debug(() -> "  added? " + added);
                this.log.debug(() -> "  commit it " + this.loggingName());
                committed = this.commit("test-merge-commit of " + origBranch + " (will be removed)");
                if (!committed) {
                    throw new IllegalStateException("Test commit on branch " + tempBranch + " failed");
                }
            } else {
                throw new IllegalStateException("Creation of test branch " + tempBranch + " failed");
            }
            result = this.checkForConflicts();
            this.log.debug("Committed.  Conflicts found: " + result);
            try {
                boolean deleted;
                if (wasDirty != this.isDirty() || hadUntrackedFiles != this.hasUntrackedFiles()) {
                    this.log.debug("Uncreate temp branch");
                    GitCommand resetCommand = new GitCommand(ProcessResultConverter.exitCodeIsZero(), this.checkoutRoot(), "reset", "HEAD^");
                    boolean success = (Boolean)resetCommand.run().awaitQuietly();
                    this.log.debug(() -> "Reset test commit: " + success);
                    if (!success) {
                        throw new IllegalStateException("Resetting test commit failed. Repository is left on test branch " + tempBranch + " coming from " + origBranch);
                    }
                }
                if (!(deleted = this.deleteBranch(tempBranch, origBranch, true))) {
                    throw new IllegalStateException("Failed to delete conflict-test branch " + tempBranch);
                }
                this.log.debug(() -> "deleted " + tempBranch + " in " + this.loggingName());
            }
            catch (Error | Exception e) {
                if (thrown != null) {
                    thrown.addSuppressed(e);
                }
                thrown = e;
            }
            if (thrown != null) {
                return (Conflicts)Exceptions.chuck((Throwable)thrown);
            }
            break block33;
            catch (Error | Exception e) {
                block31: {
                    try {
                        thrown = e;
                    }
                    catch (Throwable throwable) {
                        block32: {
                            try {
                                boolean deleted;
                                if (wasDirty != this.isDirty() || hadUntrackedFiles != this.hasUntrackedFiles()) {
                                    this.log.debug("Uncreate temp branch");
                                    GitCommand resetCommand = new GitCommand(ProcessResultConverter.exitCodeIsZero(), this.checkoutRoot(), "reset", "HEAD^");
                                    boolean success = (Boolean)resetCommand.run().awaitQuietly();
                                    this.log.debug(() -> "Reset test commit: " + success);
                                    if (!success) {
                                        throw new IllegalStateException("Resetting test commit failed. Repository is left on test branch " + tempBranch + " coming from " + origBranch);
                                    }
                                }
                                if (!(deleted = this.deleteBranch(tempBranch, origBranch, true))) {
                                    throw new IllegalStateException("Failed to delete conflict-test branch " + tempBranch);
                                }
                                this.log.debug(() -> "deleted " + tempBranch + " in " + this.loggingName());
                            }
                            catch (Error | Exception e2) {
                                if (thrown != null) {
                                    thrown.addSuppressed(e2);
                                    break block32;
                                }
                                thrown = e2;
                            }
                        }
                        if (thrown != null) {
                            return (Conflicts)Exceptions.chuck((Throwable)thrown);
                        }
                        throw throwable;
                    }
                    try {
                        boolean deleted;
                        if (wasDirty != this.isDirty() || hadUntrackedFiles != this.hasUntrackedFiles()) {
                            this.log.debug("Uncreate temp branch");
                            GitCommand resetCommand = new GitCommand(ProcessResultConverter.exitCodeIsZero(), this.checkoutRoot(), "reset", "HEAD^");
                            boolean success = (Boolean)resetCommand.run().awaitQuietly();
                            this.log.debug(() -> "Reset test commit: " + success);
                            if (!success) {
                                throw new IllegalStateException("Resetting test commit failed. Repository is left on test branch " + tempBranch + " coming from " + origBranch);
                            }
                        }
                        if (!(deleted = this.deleteBranch(tempBranch, origBranch, true))) {
                            throw new IllegalStateException("Failed to delete conflict-test branch " + tempBranch);
                        }
                        this.log.debug(() -> "deleted " + tempBranch + " in " + this.loggingName());
                    }
                    catch (Error | Exception e3) {
                        if (thrown != null) {
                            thrown.addSuppressed(e3);
                            break block31;
                        }
                        thrown = e3;
                    }
                }
                if (thrown != null) {
                    return (Conflicts)Exceptions.chuck((Throwable)thrown);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean canMerge(String mergeTo) {
        boolean result;
        Throwable thrown;
        block14: {
            thrown = null;
            result = false;
            GitCommand trialMerge = new GitCommand(ProcessResultConverter.exitCodeIsZero(), this.checkoutRoot(), "merge", "--no-commit", "--no-ff");
            result = (Boolean)trialMerge.run().awaitQuietly();
            GitCommand abortMerge = new GitCommand(ProcessResultConverter.exitCodeIsZero(), this.checkoutRoot(), "merge", "--abort");
            try {
                abortMerge.run().awaitQuietly();
            }
            catch (Error | Exception e1) {
                if (thrown != null) {
                    thrown.addSuppressed(e1);
                    break block14;
                }
                thrown = e1;
            }
            break block14;
            catch (Error | Exception err) {
                try {
                    thrown = err;
                }
                catch (Throwable throwable) {
                    block15: {
                        GitCommand abortMerge2 = new GitCommand(ProcessResultConverter.exitCodeIsZero(), this.checkoutRoot(), "merge", "--abort");
                        try {
                            abortMerge2.run().awaitQuietly();
                        }
                        catch (Error | Exception e1) {
                            if (thrown != null) {
                                thrown.addSuppressed(e1);
                                break block15;
                            }
                            thrown = e1;
                        }
                    }
                    throw throwable;
                }
                abortMerge = new GitCommand(ProcessResultConverter.exitCodeIsZero(), this.checkoutRoot(), "merge", "--abort");
                try {
                    abortMerge.run().awaitQuietly();
                }
                catch (Error | Exception e1) {
                    if (thrown != null) {
                        thrown.addSuppressed(e1);
                        break block14;
                    }
                    thrown = e1;
                }
            }
        }
        if (thrown != null) {
            Exceptions.chuck((Throwable)thrown);
        }
        return result;
    }

    public boolean checkoutOneFile(Path path) {
        if (!((Path)Checks.notNull((String)"path", (Object)path)).startsWith(this.checkoutRoot())) {
            throw new IllegalArgumentException(path + " is not under checkout root " + this.checkoutRoot());
        }
        if (Files.exists(path, new LinkOption[0]) && Files.isDirectory(path, new LinkOption[0])) {
            throw new IllegalArgumentException("checkoutOneFile is for files but was passed a directory " + path);
        }
        String relPath = this.checkoutRoot().relativize(path).toString();
        GitCommand checkoutOne = new GitCommand(ProcessResultConverter.strings(), this.checkoutRoot(), new String[]{"checkout", relPath});
        String output = (String)checkoutOne.run().awaitQuietly();
        this.log.child("checkout:" + relPath).info(output);
        return true;
    }

    public Path checkoutRoot() {
        return this.root;
    }

    public boolean commit(String message) {
        String commitOut = (String)new GitCommand(ProcessResultConverter.strings(), this.root, new String[]{"commit", "-m", message}).run().awaitQuietly();
        this.log.info(commitOut);
        return true;
    }

    public Optional<ZonedDateTime> commitDate() {
        return (Optional)this.commitDate.withWorkingDir(this.root).run().awaitQuietly();
    }

    @Override
    public int compareTo(GitCheckout o) {
        return this.root.compareTo(o.root);
    }

    public String commitMessage(String ref) {
        GitCommand cmd = new GitCommand(ProcessResultConverter.strings().trimmed(), this.checkoutRoot(), new String[]{"log", "--no-color", "-n", "1", "--pretty=format:%s", "-r", ref});
        return (String)cmd.run().awaitQuietly();
    }

    public String headOf(String branchOrOtherRef) {
        return (String)new GitCommand(ProcessResultConverter.strings().trimmed(), this.checkoutRoot(), new String[]{"log", "--no-color", "-n", "1", "--pretty=format:%H", "-r", branchOrOtherRef}).run().awaitQuietly();
    }

    public void changeHistory(int pageSize, Predicate<CommitInfo> test) {
        String output;
        ArrayList<String> args = new ArrayList<String>(Arrays.asList("log", "--skip", "0", "--no-color", "-n", Integer.toString(pageSize), "--topo-order", "--simplify-merges", "--no-abbrev", "--remove-empty", "--pretty=format:@^@:%h:::%aI:::%an:::gn", "--dirstat-by-file=cumulative", "--name-only"));
        GitCommand cmd = new GitCommand(ProcessResultConverter.strings(), this.checkoutRoot(), (String[])args.toArray(String[]::new));
        int skip = pageSize;
        do {
            if ((output = (String)cmd.run().awaitQuietly()).isBlank()) continue;
            if (!CommitInfo.visit(output, test)) break;
            args.set(3, Integer.toString(skip));
            skip += pageSize;
            cmd = new GitCommand(ProcessResultConverter.strings(), this.checkoutRoot(), (String[])args.toArray(String[]::new));
        } while (!output.isBlank());
    }

    public boolean createAndSwitchToBranch(String newLocalBranch, Optional<String> fallbackTrackingBranch) {
        return this.createAndSwitchToBranch(newLocalBranch, fallbackTrackingBranch, false);
    }

    public boolean createAndSwitchToBranch(String newLocalBranch, Optional<String> fallbackTrackingBranch, boolean pretend) {
        if (newLocalBranch.isEmpty()) {
            throw new IllegalArgumentException("Empty new branch name");
        }
        Branches branches = this.branches();
        if (branches.find(newLocalBranch, true).isPresent()) {
            throw new IllegalArgumentException("Already contains a local branch named '" + newLocalBranch + "': " + this);
        }
        Optional<Branches.Branch> remoteTrackingBranch = branches.find(newLocalBranch, false);
        if (remoteTrackingBranch.isEmpty() && fallbackTrackingBranch.isPresent()) {
            String fallback = fallbackTrackingBranch.get();
            remoteTrackingBranch = branches.find(fallback, true);
            if (remoteTrackingBranch.isEmpty()) {
                remoteTrackingBranch = branches.find(fallback, false);
            }
            if (remoteTrackingBranch.isEmpty()) {
                for (Branches.Branch b : branches.remoteBranches()) {
                    if (!b.trackingName().equals(fallback)) continue;
                    remoteTrackingBranch = Optional.of(b);
                    break;
                }
            }
            if (remoteTrackingBranch.isEmpty()) {
                this.log.warn("Could not find a branch to track for '" + newLocalBranch + "' or a local or remote branch named '" + fallback + "'");
            }
        }
        if (remoteTrackingBranch.isPresent()) {
            String track = remoteTrackingBranch.get().trackingName();
            if (pretend) {
                return true;
            }
            GitCommand cmd = new GitCommand(ProcessResultConverter.strings(), this.root, new String[]{"checkout", "-b", newLocalBranch, "-t", track});
            cmd.run().awaitQuietly();
            return true;
        }
        if (pretend) {
            return true;
        }
        GitCommand cmd = new GitCommand(ProcessResultConverter.exitCodeIsZero(), this.root, "checkout", "-b", newLocalBranch);
        return (Boolean)cmd.run().awaitQuietly();
    }

    public Optional<GitRemotes> defaultRemote() {
        Collection<? extends GitRemotes> remotes = this.allRemotes();
        if (remotes.isEmpty()) {
            return Optional.empty();
        }
        for (GitRemotes gitRemotes : remotes) {
            if (!"origin".equals(gitRemotes.name)) continue;
            return Optional.of(gitRemotes);
        }
        return Optional.of(remotes.iterator().next());
    }

    public boolean deleteRemoteBranch(String remote, String branchToDelete) {
        GitCommand del = new GitCommand(ProcessResultConverter.strings(), this.checkoutRoot(), new String[]{"push", "--delete", (String)Checks.notNull((String)"remote", (Object)remote), (String)Checks.notNull((String)"branchToDelete", (Object)branchToDelete)});
        return del.run().awaitQuietly() != null;
    }

    public boolean deleteBranch(String branchToDelete, String branchToMoveTo, boolean force) {
        Optional<String> currentBranch = this.branch();
        if (currentBranch.isEmpty() || !currentBranch.get().equals(branchToMoveTo)) {
            this.switchToBranch(branchToMoveTo);
        }
        GitCommand gc = new GitCommand(ProcessResultConverter.strings(), this.checkoutRoot(), new String[]{"branch", force ? "-D" : "-d", branchToDelete});
        String output = (String)gc.run().awaitQuietly();
        this.log.child("delete-branch:" + branchToDelete).info(output);
        return true;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != GitCheckout.class) {
            return false;
        }
        return ((GitCheckout)o).checkoutRoot().equals(this.checkoutRoot());
    }

    public boolean fetchAll() {
        return (Boolean)FETCH_ALL.withWorkingDir(this.root).run().awaitQuietly();
    }

    public boolean fetch() {
        return (Boolean)FETCH.withWorkingDir(this.root).run().awaitQuietly();
    }

    public boolean fetchPruningDefunctLocalRecordsOfRemoteBranches() {
        return (Boolean)new GitCommand(ProcessResultConverter.exitCodeIsZero(), this.checkoutRoot(), "fetch", "--all", "--prune").run().awaitQuietly();
    }

    public void gc() {
        GC.withWorkingDir(this.checkoutRoot()).run().awaitQuietly();
    }

    public boolean hasPomInRoot() {
        return Files.exists(this.root.resolve("pom.xml"), new LinkOption[0]);
    }

    public boolean hasUncommitedChanges() {
        return (Boolean)NO_MODIFICATIONS.withWorkingDir(this.root).run().awaitQuietly() == false;
    }

    public boolean hasUntrackedFiles() {
        return (Boolean)HAS_UNKNOWN_FILES.withWorkingDir(this.root).run().awaitQuietly();
    }

    public int hashCode() {
        return this.checkoutRoot().hashCode();
    }

    public String head() {
        return (String)GET_HEAD.withWorkingDir(this.root).run().awaitQuietly();
    }

    public boolean isBranch(String branch) {
        return this.branch().filter(branch::equals).isPresent();
    }

    public boolean isDetachedHead() {
        return (Boolean)IS_DETACHED_HEAD.withWorkingDir(this.root).run().awaitQuietly();
    }

    public boolean isDirty() {
        return (Boolean)IS_DIRTY.withWorkingDir(this.root).run().awaitQuietly();
    }

    public boolean isDirtyIgnoringModifiedSubmodules() {
        return (Boolean)IS_DIRTY_IGNORING_SUBMODULES.withWorkingDir(this.root).run().awaitQuietly();
    }

    public boolean isInSyncWithRemoteHead() {
        Branches branches = this.branches();
        return branches.currentBranch().map(branch -> branches.find(branch.name(), false).map(remoteBranch -> {
            String remoteHead = (String)new GitCommand(ProcessResultConverter.strings().trimmed(), this.root, new String[]{"rev-parse", remoteBranch.trackingName()}).run().awaitQuietly();
            String head = this.head();
            return remoteHead.equals(head);
        }).orElse(false)).orElse(false);
    }

    public boolean isRoot() {
        Path par = this.checkoutRoot().getParent();
        if (par == null) {
            return true;
        }
        return PathUtils.findGitCheckoutRoot((Path)par, (boolean)true).isEmpty();
    }

    public boolean isSubmodule() {
        Optional<Boolean> par = PathUtils.findParentWithChild((Path)this.checkoutRoot().getParent(), (PathUtils.FileKind)PathUtils.FileKind.FILE, (String)".gitmodules").flatMap(GitCheckout::checkout);
        return par.map(co -> (Boolean)co.submodules().map(subs -> {
            for (SubmoduleStatus stat : subs) {
                if (!stat.checkout().isPresent() || !this.equals(stat.checkout().get())) continue;
                return true;
            }
            return false;
        }).orElse((Object)false)).orElse(false);
    }

    public boolean isSubmoduleRoot() {
        if (Files.exists(this.root.resolve(".gitmodules"), new LinkOption[0])) {
            Optional submoduleRoot = PathUtils.findGitCheckoutRoot((Path)this.root, (boolean)true);
            return submoduleRoot.isPresent() && this.root.equals(submoduleRoot.get());
        }
        return false;
    }

    public String loggingName() {
        String n = this.name();
        if (n.isEmpty()) {
            n = this.checkoutRoot().getFileName().toString();
        }
        return n;
    }

    public boolean merge(String branch) {
        new GitCommand(ProcessResultConverter.strings(), this.root, new String[]{"merge", branch}).run().awaitQuietly();
        return true;
    }

    public Optional<String> mergeBase() {
        Branches branches = this.branches();
        return branches.currentBranch().flatMap(currentBranch -> branches.opposite((Branches.Branch)currentBranch).map(remoteBranch -> (String)new GitCommand(ProcessResultConverter.strings().trimmed(), this.root, new String[]{"merge-base", "@", remoteBranch.trackingName()}).run().awaitQuietly()));
    }

    public String name() {
        return (String)this.submoduleRoot().map(sroot -> sroot.equals(this) ? "" : sroot.checkoutRoot().relativize(this.root).toString()).orElse((Object)this.root.getFileName().toString());
    }

    public boolean needsPull() {
        String head = this.head();
        if (head == null) {
            return false;
        }
        Branches branches = this.branches();
        Optional<Branches.Branch> curr = branches.currentBranch();
        if (!curr.isPresent()) {
            return false;
        }
        Branches.Branch branch = curr.get();
        Optional<Branches.Branch> remBranch = branches.find(branch.name(), false);
        if (!remBranch.isPresent()) {
            return false;
        }
        String remoteHead = this.headOf(remBranch.get().trackingName());
        if (remoteHead == null) {
            return false;
        }
        if (remoteHead.equals(head)) {
            return false;
        }
        String tname = remBranch.get().trackingName();
        boolean result = this.isAncestor("HEAD", tname);
        return result;
    }

    public boolean isAncestor(String proposedParentCommitOrRef, String proposedChildCommitOrRef) {
        return (Boolean)new GitCommand(ProcessResultConverter.exitCodeIsZero(), this.checkoutRoot(), "merge-base", "--is-ancestor", (String)Checks.notNull((String)"proposedParentCommitOrRef", (Object)proposedParentCommitOrRef), (String)Checks.notNull((String)"proposedChildCommitOrRef", (Object)proposedChildCommitOrRef)).run().awaitQuietly();
    }

    public NeedPushResult needsPush() {
        String remote = this.defaultRemote().map(GitRemotes::name).orElse("origin");
        Branches branches = this.branches();
        if (branches.currentBranch().isEmpty()) {
            return NeedPushResult.NOT_ON_A_BRANCH;
        }
        Branches.Branch br = branches.currentBranch().get();
        Optional<Branches.Branch> remBranch = branches.opposite(br);
        if (remBranch.isEmpty()) {
            return NeedPushResult.REMOTE_BRANCH_DOES_NOT_EXIST;
        }
        boolean logWasEmpty = (Boolean)new GitCommand(ProcessResultConverter.strings().testedWith(String::isBlank), this.root, "log", remote + "/" + remBranch.get().name() + ".." + br.name()).run().awaitQuietly();
        return NeedPushResult.of(!logWasEmpty);
    }

    public boolean noPomInRoot() {
        return !this.hasPomInRoot();
    }

    public Set<Path> pomFiles(boolean fromRoot) {
        HashSet<Path> result = new HashSet<Path>();
        if (fromRoot) {
            this.submoduleRoot().ifPresent(gitRoot -> gitRoot.scanForPomFiles(result::add));
        } else {
            this.scanForPomFiles(result::add);
        }
        return result;
    }

    public boolean pull() {
        PULL.withWorkingDir(this.root).run().awaitQuietly();
        return true;
    }

    public boolean pullWithRebase() {
        PULL_REBASE.withWorkingDir(this.root).run().awaitQuietly();
        return true;
    }

    public URI createPullRequest(IOSupplier<String> authenticationToken, String reviewers, String title, String body, String sourceBranch, String destBranch) {
        if (title == null != (body == null)) {
            throw new IllegalArgumentException("Either title and body must both be non-null, or both null, but got '" + title + "' and '" + body + "'");
        }
        ArrayList<Object> arguments = new ArrayList<Object>();
        arguments.add("pr");
        arguments.add("create");
        arguments.add("--base");
        arguments.add(destBranch);
        arguments.add("--head");
        arguments.add(sourceBranch);
        if (title != null) {
            arguments.add("--title");
            arguments.add("\"" + title + "\"");
            arguments.add("--body");
            arguments.add("\"" + body + "\"");
        } else {
            arguments.add("-f");
        }
        if (reviewers != null && !reviewers.isBlank()) {
            for (String reviewer : reviewers.split(",")) {
                if (reviewer.isBlank()) continue;
                arguments.add("--reviewer");
                arguments.add(reviewer.trim());
            }
        }
        return (URI)new GithubCommand(authenticationToken, ProcessResultConverter.trailingUriWithTrailingDigitAloneOnLine(), this.root, (String[])arguments.toArray(String[]::new)).run().awaitQuietly(Duration.ofMinutes(2L));
    }

    public boolean mergePullRequest(IOSupplier<String> personalAccessTokenSupplier, String branchName, Set<MergePullRequestOptions> options) {
        ArrayList<Object> arguments = new ArrayList<Object>();
        arguments.add("pr");
        arguments.add("merge");
        options.forEach(opt -> opt.accept((List<String>)arguments));
        arguments.add("--body");
        arguments.add("Merge " + branchName);
        new GithubCommand(personalAccessTokenSupplier, ProcessResultConverter.strings(), this.root, (String[])arguments.toArray(String[]::new)).run().awaitQuietly();
        return true;
    }

    public boolean approvePullRequest(IOSupplier<String> personalAccessTokenSupplier, String branchName, Optional<String> body) {
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("pr");
        arguments.add("review");
        arguments.add("--approve");
        arguments.add("--body");
        arguments.add(body.orElse("Approved " + branchName));
        new GithubCommand(personalAccessTokenSupplier, ProcessResultConverter.strings(), this.root, (String[])arguments.toArray(String[]::new)).run().awaitQuietly();
        return true;
    }

    public List<MinimalPRItem> listPullRequests(IOSupplier<String> personalAccessTokenSupplier, String destBranchFilter, String searchFilter) {
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("pr");
        arguments.add("list");
        if (destBranchFilter != null && !destBranchFilter.isBlank()) {
            arguments.add("--base");
            arguments.add(destBranchFilter);
        }
        if (searchFilter != null && !searchFilter.isBlank()) {
            arguments.add("--search");
            arguments.add(searchFilter);
        }
        arguments.add("--json");
        arguments.add("url,title,state,mergeable,body,number,headRefName,baseRefName");
        return (List)new GithubCommand(personalAccessTokenSupplier, ProcessResultConverter.strings().map(MinimalPRItem.parser()), this.root, (String[])arguments.toArray(String[]::new)).run().awaitQuietly();
    }

    public boolean push() {
        PUSH.withWorkingDir(this.root).run().awaitQuietly();
        return true;
    }

    public boolean pushAll() {
        PUSH_ALL.withWorkingDir(this.root).run().awaitQuietly();
        return true;
    }

    public boolean pushCreatingBranch() {
        Optional<String> branch = this.branch();
        if (branch.isEmpty()) {
            return false;
        }
        Optional<GitRemotes> remote = this.defaultRemote();
        if (remote.isEmpty()) {
            return false;
        }
        String output = (String)new GitCommand(ProcessResultConverter.strings(), this.root, new String[]{"push", "--set-upstream", remote.get().name, branch.get()}).run().awaitQuietly();
        this.log.info(output);
        return true;
    }

    public Optional<GitRemotes> remote(String name) {
        return Optional.ofNullable((GitRemotes)((Map)LIST_REMOTES.withWorkingDir(this.root).run().awaitQuietly()).get(name));
    }

    public Optional<String> trackingBranch() {
        return this.branch().flatMap(this::trackingBranchOf);
    }

    public Optional<String> trackingBranchOf(String branch) {
        ProcessResultConverter cvt = ProcessResultConverter.strings().trimmed().map(str -> {
            String[] parts = str.split("\\s");
            if (parts.length != 2) {
                return Optional.empty();
            }
            String h = this.headOf(parts[1]);
            return h == null || h.isBlank() ? Optional.empty() : Optional.of(h);
        });
        return (Optional)new GitCommand(cvt, this.checkoutRoot(), "branch", "--format", "%(refname:short) %(upstream:short)", "--list", branch).run().awaitQuietly();
    }

    public Optional<String> remoteHead() {
        Branches branches = this.branches();
        this.log.debug(() -> "RemoteHead of " + this.loggingName() + " - branches:\n" + branches);
        return branches.currentBranch().flatMap(branch -> {
            this.log.debug(() -> "  have branch " + branch);
            Optional<Branches.Branch> remBranch = branches.find(branch.name(), false);
            if (remBranch.isPresent()) {
                this.log.debug(() -> "  have remote branch " + remBranch.get() + " with tracking name " + ((Branches.Branch)remBranch.get()).trackingName());
                String result = (String)new GitCommand(ProcessResultConverter.strings().trimmed(), this.root, new String[]{"rev-parse", remBranch.get().trackingName()}).run().awaitQuietly();
                this.log.debug(() -> "  rev-parse result '" + result + "'");
                return result == null || result.isBlank() ? Optional.empty() : Optional.of(result);
            }
            this.log.debug(() -> "  no remote branch for " + branch);
            return Optional.empty();
        });
    }

    public Optional<String> fetchHead() {
        return (Optional)new GitCommand(ProcessResultConverter.nonEmptyString(), this.checkoutRoot(), "rev-parse", "FETCH_HEAD").run().awaitQuietly();
    }

    public Heads remoteHeads() {
        return (Heads)REMOTE_HEADS.withWorkingDir(this.root).run().awaitQuietly();
    }

    public Set<String> remoteProjectNames() {
        HashSet<String> result = new HashSet<String>();
        this.allRemotes().forEach(remote -> remote.collectRemoteNames(result));
        return result;
    }

    public void scanForPomFiles(Consumer<Path> pomConsumer) {
        boolean isRoot = this.isSubmoduleRoot();
        Predicate<Path> isSameRoot = path -> !"target".equals(path.getFileName().toString()) && Files.isDirectory(path, new LinkOption[0]) && (isRoot || this.root.equals(path) || !Files.exists(path.resolve(".git"), new LinkOption[0]));
        if (this.hasPomInRoot()) {
            pomConsumer.accept(this.root.resolve("pom.xml"));
        }
        try (Stream<Path> str = Files.walk(this.root, new FileVisitOption[0]).filter(isSameRoot);){
            str.forEach(path -> {
                Path pom = path.resolve("pom.xml");
                if (Files.exists(pom, new LinkOption[0]) && (path.equals(this.root) || !Files.exists(path.resolve(".git"), new LinkOption[0]))) {
                    pomConsumer.accept(pom);
                }
            });
        }
        catch (IOException ioe) {
            Exceptions.chuck((Throwable)ioe);
        }
    }

    public void setSubmoduleBranch(String submodule, String branch) {
        if (branch == null || branch.isEmpty()) {
            throw new IllegalArgumentException("Missing branch for submodule: '" + submodule + "' with branch '" + branch + "'");
        }
        if ("".equals(submodule)) {
            Branches myBranches = this.branches();
            Optional<Branches.Branch> targetBranch = myBranches.find(branch);
            if (targetBranch.isPresent()) {
                this.switchToBranch(branch);
            } else {
                this.createAndSwitchToBranch(branch, myBranches.currentBranch().map(br -> br.name()));
            }
            return;
        }
        if (submodule == null || submodule.isEmpty()) {
            throw new IllegalArgumentException("Missing submodule: '" + submodule + "' with branch '" + branch + "'");
        }
        new GitCommand(ProcessResultConverter.strings(), this.root, new String[]{"submodule", "set-branch", "-b", branch, submodule}).run().awaitQuietly();
    }

    public ThrowingOptional<Path> submoduleRelativePath() {
        if (this.isSubmoduleRoot()) {
            return ThrowingOptional.empty();
        }
        return this.submoduleRoot().map(rootCheckout -> rootCheckout.checkoutRoot().relativize(this.root));
    }

    public ThrowingOptional<GitCheckout> submoduleRoot() {
        return ThrowingOptional.from((Optional)PathUtils.findGitCheckoutRoot((Path)this.root, (boolean)true)).map(dir -> {
            if (dir.equals(this.root)) {
                return this;
            }
            return new GitCheckout((Path)dir);
        });
    }

    public ThrowingOptional<List<SubmoduleStatus>> submodules() {
        if (this.isSubmoduleRoot()) {
            List infos = (List)this.listSubmodules.withWorkingDir(this.root).run().awaitQuietly();
            return infos.isEmpty() ? ThrowingOptional.empty() : ThrowingOptional.of((Object)infos);
        }
        if (this.isSubmodule()) {
            return this.submoduleRoot().flatMapThrowing(root -> root == this ? ThrowingOptional.empty() : root.submodules());
        }
        return ThrowingOptional.empty();
    }

    public boolean switchToBranch(String localBranch) {
        return (Boolean)new GitCommand(ProcessResultConverter.exitCodeIsZero(), this.root, "checkout", localBranch).run().awaitQuietly();
    }

    public boolean tag(String tagName, boolean force) {
        GitCommand tag = force ? new GitCommand(ProcessResultConverter.exitCodeIsZero(), this.checkoutRoot(), "tag", "-f", tagName) : new GitCommand(ProcessResultConverter.exitCodeIsZero(), this.checkoutRoot(), "tag", tagName);
        return (Boolean)tag.run().awaitQuietly();
    }

    public String toString() {
        return this.checkoutRoot().toString();
    }

    public GitCheckout updateRemoteHeads() {
        UPDATE_REMOTE_HEADS.withWorkingDir(this.root).run().awaitQuietly();
        return this;
    }

    List<SubmoduleStatus> parseSubmoduleInfo(String output) {
        return SubmoduleStatus.fromStatusOutput(this.root, output);
    }

    private Optional<ZonedDateTime> fromGitLogFormat(String txt) {
        if (txt.isEmpty()) {
            this.log.error("Got an empty timestamp from git log for " + this.root + " branch " + this.branch() + " head " + this.head());
            return Optional.empty();
        }
        try {
            return Optional.of(ZonedDateTime.parse(txt, GIT_LOG_FORMAT).withZoneSameInstant(GMT));
        }
        catch (DateTimeParseException ex) {
            this.log.error("Failed to parse git log date string '" + txt + "'", (Throwable)ex);
            return Optional.empty();
        }
    }
}

