/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.github;

import com.mastfrog.concurrent.future.AwaitableCompletionStage;
import com.mastfrog.function.throwing.io.IOSupplier;
import com.mastfrog.util.preconditions.Checks;
import com.telenav.cactus.cli.CliCommand;
import com.telenav.cactus.cli.ProcessResultConverter;
import com.telenav.cactus.maven.log.BuildLog;
import com.telenav.cactus.process.ProcessControl;
import com.zaxxer.nuprocess.NuProcessBuilder;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;

public class GithubCommand<T>
extends CliCommand<T> {
    private final Path workingDir;
    private final String[] args;
    private final BuildLog log;
    private final IOSupplier<String> accessTokenSupplier;
    private RetryWithAuthProcessResultConverter<T> retryConverter;

    public GithubCommand(ProcessResultConverter<T> resultCreator, String ... args) {
        this((IOSupplier<String>)((IOSupplier)null), resultCreator, null, args);
    }

    public GithubCommand(IOSupplier<String> authTokenSupplier, ProcessResultConverter<T> resultCreator, Path workingDir, String ... args) {
        super("gh", resultCreator);
        this.accessTokenSupplier = authTokenSupplier;
        this.workingDir = workingDir;
        this.args = (String[])Checks.notNull((String)"args", (Object)args);
        this.log = BuildLog.get().child(((Object)((Object)this)).getClass().getSimpleName());
    }

    private GithubCommand(BuildLog log, ProcessResultConverter<T> resultCreator, Path workingDir, String ... args) {
        super("gh", resultCreator);
        this.workingDir = workingDir;
        this.args = (String[])Checks.notNull((String)"args", (Object)args);
        this.log = log;
        this.accessTokenSupplier = null;
    }

    public GithubCommand<T> withWorkingDir(Path dir) {
        return new GithubCommand<T>(this.accessTokenSupplier, this.resultCreator, dir, this.args);
    }

    public GithubCommand<T> withAuthTokenSupplier(IOSupplier<String> authTokenSupplier) {
        return new GithubCommand<T>(authTokenSupplier, this.resultCreator, this.workingDir, this.args);
    }

    protected void configureArguments(List<String> list) {
        list.addAll(Arrays.asList(this.args));
    }

    protected void onLaunch(ProcessControl<String, String> proc) {
        this.log.debug(() -> "started: " + this);
        super.onLaunch(proc);
    }

    protected void validate() {
        if (this.workingDir == null) {
            throw new IllegalStateException("Command is a template. Use withWorkingDir() to get an instance that has somewhere to run.");
        }
    }

    protected Optional<Path> workingDirectory() {
        return Optional.ofNullable(this.workingDir);
    }

    String accessToken() throws IOException {
        return this.accessTokenSupplier == null ? null : (String)this.accessTokenSupplier.get();
    }

    protected synchronized ProcessResultConverter<T> resultConverter() {
        RetryWithAuthProcessResultConverter<T> orig = super.resultConverter();
        if (this.accessTokenSupplier != null && this.retryConverter == null) {
            this.retryConverter = new RetryWithAuthProcessResultConverter(this, orig);
        }
        return this.retryConverter == null || this.retryConverter.isInRetry() ? orig : this.retryConverter;
    }

    static class RetryWithAuthProcessResultConverter<T>
    implements ProcessResultConverter<T> {
        private final ProcessResultConverter<T> orig;
        private volatile boolean inRetry;
        private final BuildLog childLog;
        private final GithubCommand<T> cmd;

        private RetryWithAuthProcessResultConverter(GithubCommand<T> cmd, ProcessResultConverter<T> orig) {
            this.orig = orig;
            this.childLog = cmd.log.child(this.getClass().getSimpleName());
            this.cmd = cmd;
        }

        boolean isInRetry() {
            return this.inRetry;
        }

        public AwaitableCompletionStage<T> onProcessStarted(Supplier<String> description, ProcessControl<String, String> process) {
            if (this.inRetry) {
                this.childLog.debug("Retrying - delegate to " + this.orig);
                return this.orig.onProcessStarted(description, process);
            }
            CompletableFuture fut = new CompletableFuture();
            this.childLog.debug(() -> "onProcessStarted");
            process.onExit().whenComplete((proc, thrown) -> {
                this.childLog.debug(() -> "Initial attempt exited with " + proc.exitValue());
                if (thrown != null) {
                    fut.completeExceptionally((Throwable)thrown);
                } else if (proc.exitValue() == 4) {
                    try {
                        this.authenticateAndRetry(fut);
                    }
                    catch (IOException ex) {
                        this.childLog.error("Reading auth info", (Throwable)ex);
                        fut.completeExceptionally(ex);
                    }
                } else {
                    this.forwardToOriginalConverter(description, process, fut);
                }
            });
            return AwaitableCompletionStage.of(fut);
        }

        private void forwardToOriginalConverter(Supplier<String> description, ProcessControl<String, String> process, CompletableFuture<T> futureReturnedToCaller) {
            this.childLog.debug(() -> "Forward to original");
            AwaitableCompletionStage innerFut = this.orig.onProcessStarted(description, process);
            innerFut.whenComplete((res, thrown2) -> {
                if (thrown2 != null) {
                    futureReturnedToCaller.completeExceptionally((Throwable)thrown2);
                } else {
                    futureReturnedToCaller.complete(res);
                }
            });
        }

        private void authenticateAndRetry(CompletableFuture<T> futureReturnedToCaller) throws IOException {
            String accessToken = this.cmd.accessToken();
            if (accessToken == null || accessToken.isBlank()) {
                this.childLog.warn("Access token provider returned null or blank token.");
                futureReturnedToCaller.completeExceptionally(new RuntimeException("Not authenticated, and access token not provided"));
            } else {
                this.childLog.info("Not authenticated with GitHub - will authenticate and retry.");
                Auth auth = new Auth(this.childLog.child("auth"), accessToken, this.cmd.workingDir);
                auth.run().whenComplete((authSuccess, authThrown) -> this.onAfterAuthenticationAttempt((Throwable)authThrown, futureReturnedToCaller, (Boolean)authSuccess));
            }
        }

        private void onAfterAuthenticationAttempt(Throwable authThrown, CompletableFuture<T> futureReturnedToCaller, Boolean authSuccess) {
            if (authThrown != null) {
                this.childLog.info("Auth threw.  Original process exit code was 4", authThrown);
                futureReturnedToCaller.completeExceptionally(authThrown);
            } else if (authSuccess.booleanValue()) {
                this.inRetry = true;
                this.childLog.info("Authentication was successful.  Retrying.");
                this.onAfterAuthenticationSucceeded(futureReturnedToCaller);
            } else {
                futureReturnedToCaller.completeExceptionally(new RuntimeException("Authentication failed"));
            }
        }

        private void onAfterAuthenticationSucceeded(CompletableFuture<T> futureReturnedToCaller) {
            AwaitableCompletionStage rerunStage = this.cmd.run();
            rerunStage.whenComplete((rerunResult, rerunThrown) -> {
                try {
                    if (rerunThrown != null) {
                        this.childLog.info("Rerun threw ", rerunThrown);
                        futureReturnedToCaller.completeExceptionally((Throwable)rerunThrown);
                    } else {
                        this.childLog.debug(() -> "Rerun successful with " + rerunResult);
                        futureReturnedToCaller.complete(rerunResult);
                    }
                }
                finally {
                    this.inRetry = false;
                }
            });
        }
    }

    private static class Auth
    extends GithubCommand<Boolean> {
        private final String accessToken;

        Auth(BuildLog log, String accessToken, Path workingDir) {
            super(log, ProcessResultConverter.exitCodeIsZero(), workingDir, "auth", "login", "--hostname", "github.com", "--with-token");
            this.accessToken = accessToken;
        }

        protected void configureProcessBulder(NuProcessBuilder bldr, ProcessControl process) {
            process.withStandardInputHandler((ctrl, buf) -> {
                buf.put(this.accessToken.getBytes(StandardCharsets.UTF_8));
                return false;
            }, true);
        }
    }
}

