/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.graph;

import com.mastfrog.function.throwing.io.IOBiConsumer;
import com.mastfrog.graph.ObjectGraph;
import com.mastfrog.graph.algorithm.Score;
import com.mastfrog.util.fileformat.SimpleJSON;
import com.mastfrog.util.preconditions.Checks;
import com.mastfrog.util.streams.Streams;
import com.telenav.cactus.maven.model.GroupId;
import com.telenav.cactus.maven.model.MavenCoordinates;
import com.telenav.cactus.maven.model.MavenIdentified;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;

public final class D3GraphGenerator {
    private final ObjectGraph<MavenCoordinates> graph;
    private static final DecimalFormat FMT = new DecimalFormat("#####.################");
    private double alpha = 0.4;
    private double alphaDecay = 2.0E-5;
    private double velocityDecay = 0.725;
    private int chargeForceStrength = -853;
    private int chargeForceDistanceMax = 3750;
    private double chargeForceTheta = 4.0;
    private double collideForceRadiusFactor = 120.0;
    private int collideForceStrength = 550;
    private int collideForceIterations = 150;
    private Function<MavenIdentified, String> familyFinder = D3GraphGenerator::family;

    public D3GraphGenerator(ObjectGraph<MavenCoordinates> graph) {
        this.graph = graph;
    }

    public D3GraphGenerator withFamiliesFor(String prefix) {
        return this.withCategorizer(artifact -> artifact.groupId().textStartsWith(prefix) ? D3GraphGenerator.family(artifact) : artifact.groupId().text());
    }

    public D3GraphGenerator withCategorizer(Function<MavenIdentified, String> func) {
        this.familyFinder = func;
        return this;
    }

    public D3GraphGenerator withAlpha(double alpha) {
        this.alpha = alpha;
        return this;
    }

    public D3GraphGenerator withAlphaDecay(double alphaDecay) {
        this.alphaDecay = alphaDecay;
        return this;
    }

    public D3GraphGenerator withVelocityDecay(double velocityDecay) {
        this.velocityDecay = velocityDecay;
        return this;
    }

    public D3GraphGenerator withChargeForceStrength(int chargeForceStrength) {
        this.chargeForceStrength = chargeForceStrength;
        return this;
    }

    public D3GraphGenerator withChargeForceDistanceMax(int chargeForceDistanceMax) {
        this.chargeForceDistanceMax = chargeForceDistanceMax;
        return this;
    }

    public D3GraphGenerator withChargeForceTheta(double chargeForceTheta) {
        this.chargeForceTheta = chargeForceTheta;
        return this;
    }

    public D3GraphGenerator withCollideForceRadiusFactor(double collideForceRadiusFactor) {
        this.collideForceRadiusFactor = collideForceRadiusFactor;
        return this;
    }

    public D3GraphGenerator withCollideForceIterations(int collideForceIterations) {
        this.collideForceIterations = collideForceIterations;
        return this;
    }

    public D3GraphGenerator withCollideForceStrength(int collideForceStrength) {
        this.collideForceStrength = collideForceStrength;
        return this;
    }

    private String applyProperties(String to) {
        return to.replaceAll("__ALPHA__", FMT.format(this.alpha)).replaceAll("__ALPHA_DECAY__", FMT.format(this.alphaDecay)).replaceAll("__VELOCITY_DECAY__", FMT.format(this.velocityDecay)).replaceAll("__CHARGE_FORCE_STRENGTH__", Integer.toString(this.chargeForceStrength)).replaceAll("__CHARGE_FORCE_DISTANCE_MAX__", FMT.format(this.chargeForceDistanceMax)).replaceAll("__CHARGE_FORCE_THETA__", FMT.format(this.chargeForceTheta)).replaceAll("__COLLIDE_FORCE_RADIUS_FACTOR__", FMT.format(this.collideForceRadiusFactor)).replaceAll("__COLLIDE_FORCE_STRENGTH__", Integer.toString(this.collideForceStrength)).replaceAll("__COLLIDE_FORCE_ITERATIONS__", Integer.toString(this.collideForceIterations));
    }

    private Object idOf(ObjectGraph<MavenCoordinates> graph, MavenCoordinates coords) {
        return graph.toNodeId((Object)coords);
    }

    private String nameOf(MavenIdentified coords) {
        return coords.artifactId().toString();
    }

    public ObjectGraph<MavenCoordinates> generate(Path into) throws IOException {
        Checks.notNull((String)"into", (Object)into);
        this.scoreMap(this.graph.pageRank(), (IOBiConsumer<Map<MavenCoordinates, Double>, Map<MavenCoordinates, Integer>>)((IOBiConsumer)(scores, groups) -> {
            ArrayList nodes = new ArrayList(this.graph.size());
            ArrayList links = new ArrayList(this.graph.size());
            for (int i = 0; i < this.graph.size(); ++i) {
                MavenCoordinates coords = (MavenCoordinates)this.graph.toNode(i);
                TreeMap<String, Object> map = new TreeMap<String, Object>();
                map.put("id", this.idOf(this.graph, coords));
                map.put("name", this.nameOf((MavenIdentified)coords));
                map.put("rank", scores.get(coords));
                map.put("group", groups.get(coords));
                nodes.add(map);
                this.graph.children((Object)coords).forEach(kid -> {
                    HashMap<String, Object> link = new HashMap<String, Object>();
                    link.put("source", map.get("id"));
                    link.put("target", this.idOf(this.graph, (MavenCoordinates)kid));
                    link.put("value", 1);
                    links.add(link);
                });
            }
            HashMap all = new HashMap();
            all.put("nodes", nodes);
            all.put("links", links);
            String output = SimpleJSON.stringify(all, (SimpleJSON.Style)SimpleJSON.Style.MINIFIED);
            if (into.getParent() != null && !Files.exists(into.getParent(), new LinkOption[0])) {
                Files.createDirectories(into.getParent(), new FileAttribute[0]);
            }
            Files.writeString(into, (CharSequence)output, StandardCharsets.UTF_8, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
            System.out.println("Write " + output);
            Path dir = into.getParent();
            try (InputStream in = D3GraphGenerator.class.getResourceAsStream("index.html");){
                String data = this.applyProperties(Streams.readString((InputStream)in, (Charset)StandardCharsets.UTF_8).replaceAll("__FILE__", into.getFileName().toString()));
                Path index = dir.resolve("index.html");
                Files.writeString(index, (CharSequence)data, StandardCharsets.UTF_8, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
                System.out.println("Wrote " + index);
            }
        }));
        return this.graph;
    }

    private void scoreMap(List<Score<MavenCoordinates>> scores, IOBiConsumer<Map<MavenCoordinates, Double>, Map<MavenCoordinates, Integer>> c) throws IOException {
        HashMap result = new HashMap();
        HashMap groups = new HashMap();
        HashSet allFamilies = new HashSet();
        ArrayList families = new ArrayList();
        double min = 2.147483647E9;
        double max = -2.147483648E9;
        for (Score<MavenCoordinates> sc : scores) {
            min = Math.min(sc.score(), min);
            max = Math.max(sc.score(), max);
        }
        double range = max - min;
        double factor = range == 0.0 ? 1.0 : 1.0 / range;
        System.out.println("MIN " + min + " max " + max + " range " + range + " factor " + factor);
        double mx = max;
        double mn = min;
        scores.forEach(score -> {
            int ix;
            double normScore = 0.0 + (1.0 - (range - (score.score() - mn)) * factor);
            if (!Double.isFinite(normScore)) {
                normScore = 1.0;
            }
            System.out.println(score.node() + " " + normScore);
            result.put((MavenCoordinates)score.node(), normScore);
            String fam = this.familyFinder.apply((MavenIdentified)score.node());
            if (allFamilies.add(fam)) {
                ix = families.size();
                families.add(fam);
            } else {
                ix = families.indexOf(fam);
            }
            groups.put((MavenCoordinates)score.node(), ix);
        });
        c.accept(result, groups);
    }

    private static String family(MavenIdentified artifact) {
        String gid = artifact.groupId().text();
        int ix = gid.lastIndexOf(46);
        return gid.substring(ix + 1);
    }

    private static String family(GroupId groupId) {
        String gid = groupId.text();
        int ix = gid.lastIndexOf(46);
        return gid.substring(ix + 1);
    }
}

