/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.graph;

import com.mastfrog.graph.ObjectGraph;
import com.mastfrog.util.preconditions.Checks;
import com.telenav.cactus.graph.D3GraphGenerator;
import com.telenav.cactus.graph.DependencyGraphs;
import com.telenav.cactus.maven.model.ArtifactId;
import com.telenav.cactus.maven.model.ArtifactIdentifiers;
import com.telenav.cactus.maven.model.Dependency;
import com.telenav.cactus.maven.model.GroupId;
import com.telenav.cactus.maven.model.MavenCoordinates;
import com.telenav.cactus.maven.model.MavenIdentified;
import com.telenav.cactus.maven.model.Pom;
import com.telenav.cactus.maven.model.dependencies.DependencyScope;
import com.telenav.cactus.maven.model.resolver.Poms;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;

public class DependencyGraphBuilder {
    final Set<DependencyScope> scopes = EnumSet.noneOf(DependencyScope.class);
    BiPredicate<Pom, Dependency> preFilter;
    Predicate<MavenCoordinates> postFilter;
    boolean includeOptionalDependencies = false;

    private DependencyGraphBuilder() {
    }

    public static DependencyGraphBuilder dependencyGraphBuilder() {
        return new DependencyGraphBuilder();
    }

    public DependencyGraphBuilder withPreFilter(BiPredicate<Pom, Dependency> preFilter) {
        this.preFilter = preFilter;
        return this;
    }

    public DependencyGraphBuilder withPostFilter(Predicate<MavenCoordinates> postFilter) {
        this.postFilter = postFilter;
        return this;
    }

    public DependencyGraphBuilder includeOptionalDependencies() {
        this.includeOptionalDependencies = true;
        return this;
    }

    FinishableDependencyGraphBuilder finishableBuilder() {
        return new FinishableDependencyGraphBuilder(this);
    }

    public FinishableDependencyGraphBuilder scanningFolder(Path folder) {
        return this.finishableBuilder().scanningFolder(folder);
    }

    public static void main(String[] args) throws Exception {
        ObjectGraph<MavenCoordinates> graph = ((FinishableDependencyGraphBuilder)DependencyGraphBuilder.dependencyGraphBuilder().scanningFolder(Paths.get("/Users/timb/work/personal/mastfrog-parent", new String[0])).includeOptionalDependencies().withPostFilter(dep -> dep.groupId().textContains("com.mastfrog") && !dep.artifactId().is("util-preconditions") && !dep.artifactId().textContains("testpro"))).d3Graph().withCategorizer(id -> {
            String txt = id.artifactId().text();
            if (txt.indexOf(45) > 0) {
                return txt.substring(0, txt.indexOf(45));
            }
            return id.groupId().text();
        }).generate(Paths.get("/tmp/mgraph/graph.json", new String[0]));
        System.out.println(graph);
    }

    public static final class FinishableDependencyGraphBuilder
    extends DependencyGraphBuilder {
        private final Set<Path> foldersToScan = new LinkedHashSet<Path>(8);
        private final Set<ArtifactIdentifiers> from = new LinkedHashSet<ArtifactIdentifiers>(8);
        private GraphSpec graphing = new AllJavaProjects(true);

        FinishableDependencyGraphBuilder(DependencyGraphBuilder orig) {
            this.scopes.addAll(orig.scopes);
            this.preFilter = orig.preFilter;
            this.postFilter = orig.postFilter;
            this.includeOptionalDependencies = orig.includeOptionalDependencies;
        }

        @Override
        public FinishableDependencyGraphBuilder includeOptionalDependencies() {
            return (FinishableDependencyGraphBuilder)super.includeOptionalDependencies();
        }

        @Override
        public FinishableDependencyGraphBuilder withPostFilter(Predicate<MavenCoordinates> preFilter) {
            return (FinishableDependencyGraphBuilder)super.withPostFilter(preFilter);
        }

        @Override
        public FinishableDependencyGraphBuilder withPreFilter(BiPredicate<Pom, Dependency> preFilter) {
            return (FinishableDependencyGraphBuilder)super.withPreFilter(preFilter);
        }

        @Override
        FinishableDependencyGraphBuilder finishableBuilder() {
            return this;
        }

        @Override
        public FinishableDependencyGraphBuilder scanningFolder(Path folder) {
            this.foldersToScan.add((Path)Checks.notNull((String)"folder", (Object)folder));
            return this;
        }

        public FinishableDependencyGraphBuilder graphing(String groupId, String artifactId) {
            this.graphing = this.graphing.and(new GraphOf(new ArtifactIdentifiers(GroupId.of((String)groupId), ArtifactId.of((String)artifactId))));
            return this;
        }

        public FinishableDependencyGraphBuilder graphing(ArtifactId aid) {
            this.graphing = this.graphing.and(new GraphOfArtifactId((ArtifactId)Checks.notNull((String)"aid", (Object)aid)));
            return this;
        }

        public FinishableDependencyGraphBuilder graphing(MavenIdentified mi) {
            this.graphing = this.graphing.and(new GraphOf(((MavenIdentified)Checks.notNull((String)"mi", (Object)mi)).toArtifactIdentifiers()));
            return this;
        }

        public FinishableDependencyGraphBuilder graphingAllJavaProjects() throws IOException {
            this.graphing = this.graphing.and(new AllJavaProjects(false));
            return this;
        }

        public FinishableDependencyGraphBuilder graphingAllJavaAndPomProjects() throws IOException {
            this.graphing = this.graphing.and(new AllProjects());
            return this;
        }

        public D3GraphGenerator d3Graph() throws IOException {
            return new D3GraphGenerator(this.build());
        }

        Set<DependencyScope> scopes() {
            if (this.scopes.isEmpty()) {
                return DependencyScope.Compile.asSet();
            }
            return this.scopes;
        }

        public ObjectGraph<MavenCoordinates> build() throws IOException {
            Poms poms = Poms.in(this.foldersToScan);
            Set toGraph = (Set)this.graphing.apply(poms);
            Set<DependencyScope> scopes = this.scopes();
            DependencyGraphs graphs = new DependencyGraphs(poms.poms());
            return graphs.dependencyGraph(scopes, this.includeOptionalDependencies, this.preFilter, this.postFilter, toGraph);
        }
    }

    private static class AllJavaProjects
    implements GraphSpec {
        private final boolean isDefault;

        AllJavaProjects(boolean isDefault) {
            this.isDefault = isDefault;
        }

        @Override
        public Set<Pom> apply(Poms t) {
            return new LinkedHashSet<Pom>(t.javaProjects());
        }

        @Override
        public GraphSpec and(GraphSpec other) {
            if (this.isDefault) {
                return other;
            }
            return GraphSpec.super.and(other);
        }
    }

    private static class AllProjects
    implements GraphSpec {
        private AllProjects() {
        }

        @Override
        public Set<Pom> apply(Poms t) {
            return new LinkedHashSet<Pom>(t.poms());
        }
    }

    private static class GraphOfArtifactId
    implements GraphSpec {
        private final ArtifactId id;

        public GraphOfArtifactId(ArtifactId id) {
            this.id = id;
        }

        @Override
        public Set<Pom> apply(Poms poms) {
            return (Set)poms.get(this.id).map(pom -> Collections.singleton(pom)).orElse(Collections.emptySet());
        }
    }

    private static class GraphOf
    implements GraphSpec {
        private final ArtifactIdentifiers id;

        public GraphOf(ArtifactIdentifiers id) {
            this.id = id;
        }

        @Override
        public Set<Pom> apply(Poms poms) {
            return (Set)poms.get(this.id.groupId(), this.id.artifactId()).map(pom -> Collections.singleton(pom)).orElse(Collections.emptySet());
        }
    }

    private static interface GraphSpec
    extends Function<Poms, Set<Pom>> {
        default public GraphSpec and(GraphSpec other) {
            return poms -> {
                LinkedHashSet set = new LinkedHashSet();
                set.addAll((Collection)this.apply(poms));
                set.addAll((Collection)other.apply(poms));
                return set;
            };
        }
    }
}

