/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.graph;

import com.mastfrog.function.optional.ThrowingOptional;
import com.mastfrog.function.throwing.ThrowingConsumer;
import com.mastfrog.graph.IntGraph;
import com.mastfrog.graph.IntGraphBuilder;
import com.mastfrog.graph.ObjectGraph;
import com.mastfrog.util.preconditions.Checks;
import com.mastfrog.util.preconditions.Exceptions;
import com.telenav.cactus.maven.model.Dependency;
import com.telenav.cactus.maven.model.MavenCoordinates;
import com.telenav.cactus.maven.model.MavenModule;
import com.telenav.cactus.maven.model.Pom;
import com.telenav.cactus.maven.model.dependencies.DependencyScope;
import com.telenav.cactus.maven.model.dependencies.DependencySet;
import com.telenav.cactus.maven.model.resolver.PomResolver;
import com.telenav.cactus.maven.model.resolver.Poms;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiPredicate;
import java.util.function.Predicate;

public final class DependencyGraphs
implements Iterable<Pom> {
    private final Poms poms;
    private final Map<Pom, DependencySet> sets = new HashMap<Pom, DependencySet>();
    private final List<Pom> targets;
    private final PomResolver resolver;

    public DependencyGraphs(Collection<? extends Pom> poms) {
        this.poms = new Poms(poms);
        this.targets = new ArrayList<Pom>(poms);
        Collections.sort(this.targets);
        this.resolver = this.poms.withLocalRepository().memoizing();
    }

    public DependencyGraphs(Poms poms) {
        this.poms = poms;
        this.targets = new ArrayList<Pom>();
        poms.forEach(this.targets::add);
        Collections.sort(this.targets);
        this.resolver = poms.withLocalRepository().memoizing();
    }

    public ThrowingOptional<Pom> get(String groupId, String artifactId) {
        return this.poms.get(groupId, artifactId);
    }

    public ThrowingOptional<Pom> get(String groupId, String artifactId, String version) {
        return this.poms.get(groupId, artifactId, version);
    }

    public ThrowingOptional<ObjectGraph<MavenCoordinates>> dependencyGraph(String groupId, String artifactId, DependencyScope ... scopes) {
        Checks.greaterThanZero((String)"scopes.length", (int)scopes.length);
        return this.get(groupId, artifactId).map(pom -> new DT(DependencyScope.setOf((DependencyScope[])scopes), false).go((Pom)pom));
    }

    public ObjectGraph<MavenCoordinates> dependencyGraph(Set<DependencyScope> scopes, Predicate<MavenCoordinates> postFilter, Pom first, Pom ... anyMore) {
        LinkedHashSet<Pom> poms = new LinkedHashSet<Pom>();
        poms.add(first);
        poms.addAll(Arrays.asList(anyMore));
        return this.dependencyGraph(scopes, false, null, postFilter, poms);
    }

    public ObjectGraph<MavenCoordinates> dependencyGraph(Set<DependencyScope> scopes, boolean includeOptionalDependencies, BiPredicate<Pom, Dependency> preFilter, Predicate<MavenCoordinates> postFilter, Collection<? extends Pom> poms) {
        if (scopes.isEmpty()) {
            scopes = DependencyScope.all();
        }
        return new DT(scopes, includeOptionalDependencies, postFilter, preFilter).go(poms);
    }

    private DependencySet dependencySet(Pom pom) {
        if (!this.sets.containsKey(pom)) {
            try {
                DependencySet result = new DependencySet(pom, (PomResolver)this.poms, this.sets);
                this.sets.put(pom, result);
                return result;
            }
            catch (Exception ex) {
                return (DependencySet)Exceptions.chuck((Throwable)ex);
            }
        }
        return this.sets.get(pom);
    }

    public ObjectGraph<MavenCoordinates> parentage() {
        TreeSet<Object> allCoordinates = new TreeSet<Object>();
        HashMap<MavenCoordinates, MavenCoordinates> all = new HashMap<MavenCoordinates, MavenCoordinates>();
        ParentsCollector col = new ParentsCollector(this.resolver, all);
        for (Pom p : this.targets) {
            col.go(p);
        }
        allCoordinates.addAll(all.keySet());
        allCoordinates.addAll(all.values());
        ArrayList sorted = new ArrayList(allCoordinates);
        IntGraphBuilder ib = IntGraph.builder((int)allCoordinates.size());
        ib.addOrphan(all.size() - 1);
        all.forEach((? super K child, ? super V par) -> {
            int ixc = sorted.indexOf(child);
            int ixp = sorted.indexOf(par);
            ib.addEdge(ixp, ixc);
        });
        return ib.build().toObjectGraph(sorted);
    }

    public ObjectGraph<MavenCoordinates> ownership() {
        ArrayList coords = new ArrayList();
        this.poms.forEach(pom -> coords.add(pom.coordinates()));
        Collections.sort(coords);
        IntGraphBuilder ib = IntGraph.builder((int)coords.size());
        for (Pom pom2 : this.poms) {
            Set modules;
            if (!pom2.isPomProject() || (modules = pom2.modules()).isEmpty()) continue;
            MavenCoordinates c = pom2.coordinates();
            int ix = coords.indexOf(c);
            for (MavenModule mm : modules) {
                mm.toPom().ifPresent(childPom -> {
                    MavenCoordinates ch = childPom.coordinates();
                    int cix = coords.indexOf(ch);
                    ib.addEdge(ix, cix);
                });
            }
        }
        return ib.build().toObjectGraph(coords);
    }

    @Override
    public Iterator<Pom> iterator() {
        return Collections.unmodifiableList(this.targets).iterator();
    }

    class DT
    implements BiPredicate<Pom, Dependency> {
        private final Map<MavenCoordinates, Set<MavenCoordinates>> deps = new HashMap<MavenCoordinates, Set<MavenCoordinates>>();
        private final Set<DependencyScope> scopes;
        private final Set<MavenCoordinates> all = new HashSet<MavenCoordinates>();
        private final Set<Pom> traversedPoms = new HashSet<Pom>();
        private final boolean includeOptionalDependencies;
        private final Predicate<MavenCoordinates> postFilter;
        private final BiPredicate<Pom, Dependency> preFilter;

        public DT(Set<DependencyScope> scopes, boolean includeOptionalDependencies) {
            this(scopes, false, null, null);
        }

        private void postFilter() {
            if (this.postFilter != null) {
                HashMap filtered = new HashMap();
                this.deps.forEach((coord, deps) -> {
                    if (this.postFilter.test((MavenCoordinates)coord)) {
                        LinkedHashSet<MavenCoordinates> nue = new LinkedHashSet<MavenCoordinates>();
                        for (MavenCoordinates dep : deps) {
                            if (this.postFilter.test(dep)) {
                                nue.add(dep);
                                continue;
                            }
                            this.all.remove(dep);
                        }
                        if (!nue.isEmpty()) {
                            filtered.put(coord, nue);
                        }
                    } else {
                        this.all.remove(coord);
                    }
                });
                ArrayList<MavenCoordinates> newAll = new ArrayList<MavenCoordinates>();
                for (MavenCoordinates mc : this.all) {
                    if (!this.postFilter.test(mc)) continue;
                    newAll.add(mc);
                }
                this.all.clear();
                this.all.addAll(newAll);
                this.deps.clear();
                this.deps.putAll(filtered);
            }
        }

        public DT(Set<DependencyScope> scopes, boolean includeOptionalDependencies, Predicate<MavenCoordinates> postFilter, BiPredicate<Pom, Dependency> preFilter) {
            this.scopes = scopes;
            this.includeOptionalDependencies = includeOptionalDependencies;
            this.postFilter = postFilter;
            this.preFilter = preFilter;
        }

        @Override
        public boolean test(Pom t, Dependency u) {
            this.traversedPoms.add(t);
            if (this.preFilter == null || this.preFilter.test(t, u)) {
                this.deps.compute(t.coordinates(), (cds, set) -> {
                    if (set == null) {
                        set = new TreeSet<MavenCoordinates>();
                    }
                    set.add(u.coordinates());
                    return set;
                });
                this.all.add(t.coordinates());
                this.all.add(u.coordinates());
            }
            return true;
        }

        public ObjectGraph<MavenCoordinates> go(Pom thePom) {
            return this.go(Collections.singleton(thePom));
        }

        public ObjectGraph<MavenCoordinates> go(Collection<? extends Pom> thePoms) {
            for (Pom pom : thePoms) {
                if (this.traversedPoms.contains(pom)) continue;
                DependencyGraphs.this.poms.dependencies(pom).visitDependencyClosure(this.scopes, this.includeOptionalDependencies, (BiPredicate)this);
            }
            this.postFilter();
            ArrayList<MavenCoordinates> sorted = new ArrayList<MavenCoordinates>(this.all);
            Collections.sort(sorted);
            IntGraphBuilder intGraphBuilder = IntGraph.builder((int)sorted.size());
            this.deps.forEach((lib, libDependencies) -> {
                int ix = sorted.indexOf(lib);
                libDependencies.forEach(dep -> {
                    int dix = sorted.indexOf(dep);
                    ib.addEdge(ix, dix);
                });
            });
            return intGraphBuilder.build().toObjectGraph(sorted);
        }
    }

    private static final class ParentsCollector
    implements ThrowingConsumer<Pom> {
        private final Map<MavenCoordinates, MavenCoordinates> coords;
        private final PomResolver res;
        private MavenCoordinates curr;

        ParentsCollector(PomResolver res, Map<MavenCoordinates, MavenCoordinates> collectInto) {
            this.coords = collectInto;
            this.res = res;
        }

        public void go(Pom owner) {
            this.curr = owner.coordinates().toPlainMavenCoordinates();
            if (this.coords.containsKey(this.curr)) {
                return;
            }
            owner.visitParents(this.res, (ThrowingConsumer)this);
            this.curr = null;
        }

        public void accept(Pom obj) throws Exception {
            MavenCoordinates parent = obj.coordinates().toPlainMavenCoordinates();
            if (this.curr.equals((Object)parent)) {
                throw new IllegalStateException("Pom parented to itself: " + obj);
            }
            this.coords.put(this.curr, parent);
            this.curr = parent;
        }
    }
}

