/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.maven.log;

import com.mastfrog.function.throwing.ThrowingRunnable;
import com.mastfrog.function.throwing.ThrowingSupplier;
import com.mastfrog.util.strings.Strings;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildLog
implements Consumer<String> {
    private static final ThreadLocal<BuildLog> LOG = new ThreadLocal();
    private final String prefix;
    private final Logger logger;

    BuildLog(String prefix, Logger logger) {
        this.prefix = prefix;
        this.logger = logger;
    }

    BuildLog(String prefix) {
        this(prefix, LoggerFactory.getLogger(BuildLog.class));
    }

    BuildLog() {
        this((String)null);
    }

    public BuildLog(Class<?> context) {
        this(null, LoggerFactory.getLogger(context));
    }

    public BuildLog(String pfx, String context) {
        this(pfx, LoggerFactory.getLogger((String)context));
    }

    @Override
    public void accept(String t) {
        this.info(t);
    }

    public void ifDebug(Runnable run) {
        if (this.logger.isDebugEnabled()) {
            run.run();
        }
    }

    private static void withLog(BuildLog log, ThrowingRunnable run) throws Exception {
        BuildLog old = LOG.get();
        try {
            LOG.set(log);
            run.run();
        }
        finally {
            LOG.set(old);
        }
    }

    public static BuildLog get() {
        BuildLog log = LOG.get();
        if (log == null) {
            log = new BuildLog();
        }
        return log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void benchmark(String task, ThrowingRunnable run) {
        this.info("Begin " + task);
        long then = System.currentTimeMillis();
        try {
            run.toNonThrowing().run();
        }
        finally {
            this.info(task + " took " + (System.currentTimeMillis() - then) + " milliseconds");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T benchmark(String task, ThrowingSupplier<T> run) {
        this.debug("Begin " + task);
        long then = System.currentTimeMillis();
        try {
            Object t = run.asSupplier().get();
            return t;
        }
        finally {
            this.debug(task + " took " + (System.currentTimeMillis() - then) + " milliseconds");
        }
    }

    public void run(ThrowingRunnable consumer) throws Exception {
        BuildLog.withLog(this, () -> {
            try {
                consumer.run();
            }
            catch (Error | Exception e) {
                if (Boolean.getBoolean("cactus.debug")) {
                    this.logger.error(this.prefix == null ? "root" : this.prefix, e);
                } else {
                    this.logger.error(e.getMessage());
                }
                throw e;
            }
        });
    }

    public BuildLog child(String name) {
        String pfx = this.prefix == null ? name : this.prefix + ":" + name;
        return new BuildLog(pfx, this.logger);
    }

    private String prefixed(String what) {
        return this.prefix == null ? what : this.prefix + ": " + what;
    }

    private void logSplit(String what, Consumer<String> linesConsumer) {
        if (what.indexOf(10) >= 0) {
            Strings.split((char)'\n', (CharSequence)what, seq -> {
                linesConsumer.accept(this.prefixed(seq.toString()));
                return true;
            });
        } else {
            linesConsumer.accept(this.prefixed(what));
        }
    }

    public BuildLog info(String what) {
        if (this.logger.isInfoEnabled()) {
            this.logSplit(what, arg_0 -> ((Logger)this.logger).info(arg_0));
        }
        return this;
    }

    public BuildLog info(String what, Throwable thrown) {
        this.logger.info(this.prefixed(what), thrown);
        return this;
    }

    public BuildLog info(String what, Object ... args) {
        this.logger.info(this.prefixed(what), args);
        return this;
    }

    public BuildLog error(String what) {
        this.logSplit(what, arg_0 -> ((Logger)this.logger).error(arg_0));
        return this;
    }

    public BuildLog error(String what, Throwable thrown) {
        this.logger.error(this.prefixed(what), thrown);
        return this;
    }

    public BuildLog error(String what, Object ... args) {
        this.logger.error(this.prefixed(what), args);
        return this;
    }

    public BuildLog warn(String what) {
        this.logSplit(what, arg_0 -> ((Logger)this.logger).warn(arg_0));
        return this;
    }

    public BuildLog warn(String what, Throwable thrown) {
        this.logger.warn(this.prefixed(what), thrown);
        return this;
    }

    public BuildLog warn(String what, Object ... args) {
        this.logger.warn(this.prefixed(what), args);
        return this;
    }

    public BuildLog debug(String what) {
        if (this.logger.isDebugEnabled()) {
            this.logSplit(what, arg_0 -> ((Logger)this.logger).debug(arg_0));
        }
        return this;
    }

    public BuildLog debug(String what, Throwable thrown) {
        this.logger.debug(this.prefixed(what), thrown);
        return this;
    }

    public BuildLog debug(String what, Object ... args) {
        this.logger.debug(this.prefixed(what), args);
        return this;
    }

    public BuildLog debug(Supplier<String> what) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(this.prefixed(what.get()));
        }
        return this;
    }
}

