/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.maven.model;

import com.mastfrog.function.optional.ThrowingOptional;
import com.mastfrog.util.preconditions.Checks;
import com.telenav.cactus.maven.model.ArtifactId;
import com.telenav.cactus.maven.model.ArtifactIdentifiers;
import com.telenav.cactus.maven.model.GroupId;
import com.telenav.cactus.maven.model.MavenArtifactCoordinates;
import com.telenav.cactus.maven.model.PomVersion;
import com.telenav.cactus.maven.model.internal.PomFile;
import com.telenav.cactus.maven.model.property.PropertyResolver;
import com.telenav.cactus.maven.model.resolver.PomResolver;
import java.nio.file.Path;
import java.util.Optional;
import java.util.function.Function;
import org.w3c.dom.Node;

public class MavenCoordinates
extends ArtifactIdentifiers
implements Comparable<MavenCoordinates>,
MavenArtifactCoordinates {
    public final PomVersion version;

    public MavenCoordinates(Node groupId, Node artifactId, Node version) {
        this(GroupId.of(groupId), ArtifactId.of(artifactId), PomVersion.of(version));
    }

    public MavenCoordinates(String groupId, String artifactId, String version) {
        this(GroupId.of(groupId), ArtifactId.of(artifactId), PomVersion.of(version));
    }

    public MavenCoordinates(GroupId groupId, ArtifactId artifactId, PomVersion version) {
        super((GroupId)Checks.notNull((String)"groupId", (Object)groupId), (ArtifactId)Checks.notNull((String)"artifactId", (Object)artifactId));
        this.version = (PomVersion)Checks.notNull((String)"version", (Object)version);
    }

    public static Optional<MavenCoordinates> from(Path pomFile) {
        try {
            return Optional.of(new PomFile(pomFile).coordinates());
        }
        catch (Exception ex) {
            return Optional.empty();
        }
    }

    @Override
    public MavenCoordinates withVersion(String newVersion) {
        if (this.version.is(newVersion)) {
            return this;
        }
        return new MavenCoordinates(this.groupId, this.artifactId, PomVersion.of(newVersion));
    }

    @Override
    public PomVersion version() {
        return this.version;
    }

    public MavenCoordinates withVersion(PomVersion newVersion) {
        if (this.version.equals(newVersion)) {
            return this;
        }
        return new MavenCoordinates(this.groupId, this.artifactId, newVersion);
    }

    public MavenCoordinates withGroupId(String newGroupId) {
        if (this.groupId.is(newGroupId)) {
            return this;
        }
        return new MavenCoordinates(GroupId.of(newGroupId), this.artifactId, this.version);
    }

    public ArtifactIdentifiers toMavenId() {
        return new ArtifactIdentifiers(this.groupId(), this.artifactId());
    }

    @Override
    public GroupId groupId() {
        return this.groupId;
    }

    @Override
    public ArtifactId artifactId() {
        return this.artifactId;
    }

    public MavenCoordinates toPlainMavenCoordinates() {
        return this;
    }

    @Override
    public boolean isResolved() {
        return this.version.isResolved() && this.groupId.isResolved() && this.artifactId.isResolved();
    }

    public MavenCoordinates resolve(Function<String, String> res) {
        GroupId gid = (GroupId)this.groupId.resolve((Function)res);
        ArtifactId aid = (ArtifactId)this.artifactId.resolve((Function)res);
        PomVersion ver = (PomVersion)this.version.resolve((Function)res);
        if (gid != this.groupId || aid != this.artifactId || ver != this.version) {
            MavenCoordinates nue = new MavenCoordinates(gid, aid, ver);
            return nue;
        }
        return this;
    }

    public MavenCoordinates resolve(PropertyResolver res, PomResolver poms) {
        PomVersion ver = this.version;
        if (ver.isPlaceholder()) {
            ver = (PomVersion)poms.get(this.groupId.text(), this.artifactId.text()).map(pom -> pom.coordinates().version).orElse((Object)this.version);
        }
        MavenCoordinates nue = ver == this.version ? this : new MavenCoordinates(this.groupId, this.artifactId, ver);
        return nue.resolve(res);
    }

    @Override
    public ThrowingOptional<String> resolvedVersion() {
        return this.version.ifResolved();
    }

    @Override
    public int compareTo(MavenCoordinates o) {
        return this.groupId.compare(o.groupId, () -> this.artifactId.compare(o.artifactId, () -> this.version.compareTo(o.version)));
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != MavenCoordinates.class) {
            return false;
        }
        MavenCoordinates other = (MavenCoordinates)o;
        return this.version.equals(other.version) && this.artifactId.equals(other.artifactId) && this.groupId.equals(other.groupId);
    }

    @Override
    public int hashCode() {
        return 137 * this.artifactId.hashCode() + 3 * this.groupId.hashCode() + 11 * this.version.hashCode();
    }

    public boolean is(MavenCoordinates other) {
        return other.groupId.equals(this.groupId) && other.artifactId.equals(this.artifactId);
    }

    @Override
    public String toString() {
        return this.groupId + ":" + this.artifactId + ":" + this.version;
    }
}

