/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.maven.model;

import com.mastfrog.util.preconditions.Checks;
import org.w3c.dom.Node;

public final class Packaging
implements Comparable<Packaging> {
    private final String packaging;
    public static final Packaging JAR = new Packaging("jar");
    public static final Packaging POM = new Packaging("pom");

    private Packaging(String packaging) {
        this.packaging = ((String)Checks.notNull((String)"packaging", (Object)packaging)).trim();
    }

    public static Packaging packaging(Node node) {
        if (node == null || node.getTextContent() == null || node.getTextContent().isBlank()) {
            return JAR;
        }
        return Packaging.packaging(node.getTextContent());
    }

    public static Packaging packaging(String what) {
        if (what == null || what.isBlank()) {
            return JAR;
        }
        switch (what) {
            case "jar": {
                return JAR;
            }
            case "pom": {
                return POM;
            }
        }
        return new Packaging(what);
    }

    public boolean is(String type) {
        return this.packaging.equals(type);
    }

    public boolean isPom() {
        return POM.equals(this);
    }

    public String kind() {
        return this.packaging;
    }

    public String toString() {
        return this.kind();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != Packaging.class) {
            return false;
        }
        Packaging other = (Packaging)o;
        return other.packaging.equals(this.packaging);
    }

    public int hashCode() {
        switch (this.packaging) {
            case "jar": {
                return 1;
            }
            case "pom": {
                return 0x3FFFFFFF;
            }
            case "maven-plugin": {
                return -268435456;
            }
        }
        return 51 * this.packaging.hashCode();
    }

    @Override
    public int compareTo(Packaging o) {
        return this.packaging.compareTo(o.packaging);
    }
}

