/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.maven.model;

import com.mastfrog.function.optional.ThrowingOptional;
import com.mastfrog.function.throwing.ThrowingConsumer;
import com.mastfrog.util.preconditions.Checks;
import com.mastfrog.util.preconditions.Exceptions;
import com.telenav.cactus.maven.model.ArtifactId;
import com.telenav.cactus.maven.model.Dependency;
import com.telenav.cactus.maven.model.DiskResident;
import com.telenav.cactus.maven.model.GroupId;
import com.telenav.cactus.maven.model.MavenArtifactCoordinates;
import com.telenav.cactus.maven.model.MavenCoordinates;
import com.telenav.cactus.maven.model.MavenModule;
import com.telenav.cactus.maven.model.Packaging;
import com.telenav.cactus.maven.model.ParentMavenCoordinates;
import com.telenav.cactus.maven.model.PomVersion;
import com.telenav.cactus.maven.model.dependencies.DependencyScope;
import com.telenav.cactus.maven.model.internal.PomFile;
import com.telenav.cactus.maven.model.property.MapPropertyResolver;
import com.telenav.cactus.maven.model.property.PropertyResolver;
import com.telenav.cactus.maven.model.resolver.PomResolver;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.xml.sax.SAXException;

public class Pom
implements Comparable<Pom>,
MavenArtifactCoordinates,
DiskResident,
Iterable<MavenModule> {
    private final Set<MavenModule> modules;
    private final Packaging packaging;
    private final Path pom;
    private final MavenCoordinates coords;
    private Map<String, String> props;
    private String[] nameDescription;
    private Boolean hasExplicitVersion;

    public static ThrowingOptional<Pom> in(Path pomFileOrDir) {
        if (Files.isDirectory(pomFileOrDir, new LinkOption[0])) {
            return Pom.from(pomFileOrDir.resolve("pom.xml"));
        }
        return Pom.from(pomFileOrDir);
    }

    public static Optional<Pom> fromOpt(Path pomFile) {
        return Pom.from(pomFile).toOptional();
    }

    public static ThrowingOptional<Pom> from(Path pomFile) {
        if (!Files.exists(pomFile, new LinkOption[0]) || Files.isDirectory(pomFile, new LinkOption[0]) || !Files.isReadable(pomFile)) {
            return ThrowingOptional.empty();
        }
        PomFile pom = new PomFile(pomFile);
        try {
            MavenCoordinates coord = pom.coordinates();
            String pkg = pom.packaging();
            Set<String> modules = "pom".equals(pkg) ? pom.modules() : Collections.emptySet();
            Pom res = new Pom(pomFile, coord, pkg, modules);
            PomFile.note(res, pom);
            return ThrowingOptional.of((Object)res);
        }
        catch (IOException | ParserConfigurationException | XPathExpressionException | SAXException ex) {
            Logger.getLogger(Pom.class.getName()).log(Level.SEVERE, null, ex);
            return ThrowingOptional.empty();
        }
    }

    public Pom(Path pom, MavenCoordinates coords, String packaging, Set<String> modules) {
        this.pom = (Path)Checks.notNull((String)"pom", (Object)pom);
        this.coords = (MavenCoordinates)Checks.notNull((String)"coords", (Object)coords);
        this.packaging = Packaging.packaging(packaging);
        Set<MavenModule> mods = MavenModule.fromStrings(this, modules);
        this.modules = mods.isEmpty() ? mods : Collections.unmodifiableSet(mods);
    }

    @Override
    public Path path() {
        return this.pom;
    }

    public Set<MavenModule> modules() {
        return this.modules;
    }

    @Override
    public Iterator<MavenModule> iterator() {
        return this.modules().iterator();
    }

    PomFile toPomFile() {
        return PomFile.of(this);
    }

    public PropertyResolver localPropertyResolver() {
        return new MapPropertyResolver(this.properties());
    }

    @Override
    public PomVersion version() {
        return this.coordinates().version();
    }

    public Packaging packaging() {
        return this.packaging;
    }

    public boolean isPomProject() {
        return this.packaging().isPom();
    }

    public boolean isAggregator() {
        return this.isPomProject() && !this.modules().isEmpty();
    }

    public Map<String, String> properties() {
        if (this.props != null) {
            return this.props;
        }
        try {
            LinkedHashMap result = new LinkedHashMap();
            this.toPomFile().visitProperties((key, val) -> result.put(key, val));
            this.props = Collections.unmodifiableMap(result);
            return this.props;
        }
        catch (Error | Exception e) {
            return (Map)Exceptions.chuck((Throwable)e);
        }
    }

    public ThrowingOptional<ParentMavenCoordinates> parent() {
        try {
            return this.toPomFile().parentCoordinates();
        }
        catch (Exception ex) {
            return (ThrowingOptional)Exceptions.chuck((Throwable)ex);
        }
    }

    public ThrowingOptional<Pom> resolveParent(PomResolver resolver) {
        return this.parent().flatMapThrowing(par -> resolver.get(par.groupId(), par.artifactId(), par.version()));
    }

    public Dependency toDependency(String type, DependencyScope scope, boolean optional) {
        return new Dependency(this.coordinates(), type, scope, optional, Collections.emptySet());
    }

    public List<Pom> hierarchyDescending(PomResolver res) {
        List<Pom> result = this.parents(res);
        result.add(0, this);
        return result;
    }

    public List<Pom> parents(PomResolver res) {
        ArrayList<Pom> result = new ArrayList<Pom>();
        this.visitParents(res, (ThrowingConsumer<Pom>)((ThrowingConsumer)result::add));
        return result;
    }

    public int visitParents(PomResolver resolver, ThrowingConsumer<Pom> coords) {
        ParentMavenCoordinates pmc;
        ThrowingOptional<Pom> resolved;
        int result = 0;
        ThrowingOptional<ParentMavenCoordinates> opt = this.parent();
        while (opt.isPresent() && (resolved = resolver.get((pmc = (ParentMavenCoordinates)opt.get()).groupId(), pmc.artifactId(), pmc.version())).isPresent()) {
            try {
                coords.accept((Object)((Pom)resolved.get()));
                opt = ((Pom)resolved.get()).parent();
            }
            catch (Exception ex) {
                return (Integer)Exceptions.chuck((Throwable)ex);
            }
            ++result;
        }
        return result;
    }

    @Override
    public GroupId groupId() {
        return this.coordinates().groupId();
    }

    @Override
    public ArtifactId artifactId() {
        return this.coordinates().artifactId;
    }

    @Override
    public ThrowingOptional<String> resolvedVersion() {
        return this.coordinates().resolvedVersion();
    }

    @Override
    public int compareTo(Pom o) {
        return this.coordinates().compareTo(o.coordinates());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || Pom.class != obj.getClass()) {
            return false;
        }
        return this.pom.equals(((Pom)obj).pom);
    }

    public int hashCode() {
        int hash = 7;
        hash = 67 * hash + Objects.hashCode(this.pom);
        hash = 67 * hash + Objects.hashCode(this.coordinates());
        return hash;
    }

    public Path projectFolder() {
        return this.pom.getParent();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.coordinates());
        if (this.isPomProject() && !this.modules.isEmpty()) {
            sb.append('(');
            Iterator<MavenModule> it = this.modules.iterator();
            while (it.hasNext()) {
                sb.append(it.next());
                if (!it.hasNext()) continue;
                sb.append(',');
            }
            sb.append(')');
        }
        return sb.toString();
    }

    private String[] nameAndDescription() {
        if (this.nameDescription != null) {
            return this.nameDescription;
        }
        PomFile pf = PomFile.of(this);
        try {
            String[] result = new String[]{this.artifactId().text(), "-none-"};
            this.nameDescription = (String[])pf.inContext(doc -> {
                pf.nodeQuery("/project/name").ifPresent(nd -> {
                    String txt = nd.getTextContent();
                    if (txt != null && !txt.isBlank()) {
                        result[0] = txt.trim();
                    }
                });
                pf.nodeQuery("/project/description").ifPresent(nd -> {
                    String txt = nd.getTextContent();
                    if (txt != null && !txt.isBlank()) {
                        result[1] = txt.trim();
                    }
                });
                return result;
            });
            return this.nameDescription;
        }
        catch (Exception ex) {
            return (String[])Exceptions.chuck((Throwable)ex);
        }
    }

    public String name() {
        return this.nameAndDescription()[0] == null ? this.artifactId().text() : this.nameAndDescription()[0];
    }

    public String description() {
        return this.nameAndDescription()[1] == null ? "-none-" : this.nameAndDescription()[1];
    }

    public boolean hasExplicitVersion() {
        if (this.hasExplicitVersion != null) {
            return this.hasExplicitVersion;
        }
        try {
            this.hasExplicitVersion = this.toPomFile().nodeQuery("/project/version").isPresent();
            return this.hasExplicitVersion;
        }
        catch (IOException | ParserConfigurationException | XPathExpressionException | SAXException ex) {
            return (Boolean)Exceptions.chuck((Throwable)ex);
        }
    }

    public MavenCoordinates coordinates() {
        return this.coords;
    }
}

