/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.maven.model;

import com.mastfrog.function.optional.ThrowingOptional;
import com.mastfrog.util.preconditions.Checks;
import com.telenav.cactus.maven.model.MavenArtifactCoordinates;
import com.telenav.cactus.maven.model.MavenVersioned;
import com.telenav.cactus.maven.model.ResolvablePomElement;
import com.telenav.cactus.maven.model.VersionChange;
import com.telenav.cactus.maven.model.VersionChangeMagnitude;
import com.telenav.cactus.maven.model.VersionFlavor;
import com.telenav.cactus.maven.model.VersionFlavorChange;
import com.telenav.cactus.maven.model.resolver.versions.VersionComparator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import org.w3c.dom.Node;

public final class PomVersion
extends ResolvablePomElement<PomVersion> {
    public static final PomVersion UNKNOWN = new PomVersion("-**-");

    PomVersion(String version) {
        super(version);
    }

    PomVersion(Node node) {
        super(node);
    }

    public static PomVersion of(Node n) {
        if (n == null) {
            return UNKNOWN;
        }
        return new PomVersion(n);
    }

    public static PomVersion of(String what) {
        if ("-**-".equals(what)) {
            return UNKNOWN;
        }
        return new PomVersion(((String)Checks.notNull((String)"what", (Object)what)).trim());
    }

    public ThrowingOptional<VersionChange> to(PomVersion nue) {
        if (nue.equals(this)) {
            return ThrowingOptional.empty();
        }
        return ThrowingOptional.of((Object)new VersionChange(this, nue));
    }

    @Override
    protected PomVersion newInstance(String what) {
        return PomVersion.of(what);
    }

    @Override
    public int compareTo(PomVersion o) {
        if (o.equals(this)) {
            return 0;
        }
        return VersionComparator.INSTANCE.compare(this.text(), o.text());
    }

    public Optional<PomVersion> updatedWith(VersionChangeMagnitude magnitude, VersionFlavorChange flavorChange) {
        String newHead;
        String result;
        Optional<String> sfx = flavorChange.newSuffix(this);
        List<Long> decimals = this.decimals();
        while (magnitude.ordinal() >= decimals.size()) {
            decimals.add(0L);
        }
        if (this.flavor() == VersionFlavor.RELEASE && flavorChange == VersionFlavorChange.TO_SNAPSHOT && magnitude == VersionChangeMagnitude.NONE) {
            magnitude = VersionChangeMagnitude.DOT;
        }
        if ((result = sfx.map(arg_0 -> PomVersion.lambda$updatedWith$0(newHead = magnitude.increment(decimals), arg_0)).orElse(newHead)).equals(this.text())) {
            return Optional.empty();
        }
        return Optional.of(PomVersion.of(result));
    }

    private String decimalHead() {
        String text = this.text();
        if (text.isEmpty()) {
            return "";
        }
        return PomVersion.headTail(text, (head, tail) -> head);
    }

    public List<Long> decimals() {
        return VersionComparator.extractNumerics(this.decimalHead().split("[\\.-]+"));
    }

    public Optional<String> suffix() {
        return PomVersion.suffixOf(this.text());
    }

    public VersionFlavor flavor() {
        return this.suffix().map(sfx -> {
            switch (sfx) {
                case "-SNAPSHOT": {
                    return VersionFlavor.SNAPSHOT;
                }
            }
            return VersionFlavor.OTHER;
        }).orElse(VersionFlavor.RELEASE);
    }

    public boolean isVersionOf(MavenVersioned versioned) {
        if (versioned == null) {
            return false;
        }
        return this.equals(versioned.version());
    }

    public boolean isValidVersion() {
        boolean result;
        boolean bl = result = !this.decimals().isEmpty();
        if (result) {
            for (int i = 0; i < this.text().length(); ++i) {
                char c = this.text().charAt(i);
                if (!Character.isWhitespace(c)) continue;
                return false;
            }
        }
        return result;
    }

    static Optional<String> suffixOf(String what) {
        if (((String)Checks.notNull((String)"what", (Object)what)).isEmpty()) {
            return Optional.empty();
        }
        return Optional.ofNullable(PomVersion.headTail(what, (head, tail) -> tail.isEmpty() ? null : tail));
    }

    static String headTail(String what, BiFunction<String, String, String> func) {
        StringBuilder sb = new StringBuilder();
        boolean lastWasDot = true;
        for (int i = 0; i < what.length(); ++i) {
            char c = what.charAt(i);
            if (c >= '0' && c <= '9') {
                lastWasDot = false;
                sb.append(c);
                continue;
            }
            if (c == '.') {
                if (lastWasDot) break;
                sb.append(c);
                lastWasDot = true;
                continue;
            }
            func.apply(sb.toString(), what.substring(i, what.length()));
            break;
        }
        return func.apply(sb.toString(), what.substring(sb.length(), what.length()));
    }

    public static Optional<PomVersion> mostCommonVersion(Collection<? extends MavenArtifactCoordinates> c, Comparator<MavenArtifactCoordinates> tieBreaker) {
        if (c.isEmpty()) {
            return Optional.empty();
        }
        HashMap<PomVersion, Integer> map = new HashMap<PomVersion, Integer>();
        int max = Integer.MIN_VALUE;
        for (MavenArtifactCoordinates mavenArtifactCoordinates : c) {
            Integer count = map.compute(mavenArtifactCoordinates.version(), (k, oldCount) -> oldCount == null ? 1 : oldCount + 1);
            max = Math.max(max, count);
        }
        ArrayList entries = new ArrayList(map.entrySet());
        if (max == 1) {
            ArrayList<? extends MavenArtifactCoordinates> arrayList = new ArrayList<MavenArtifactCoordinates>(c);
            Collections.sort(arrayList, tieBreaker);
            return Optional.of(((MavenArtifactCoordinates)arrayList.get(0)).version());
        }
        Collections.sort(entries, (a, b) -> ((Integer)b.getValue()).compareTo((Integer)a.getValue()));
        return Optional.of((PomVersion)((Map.Entry)entries.get(0)).getKey());
    }

    public static Optional<PomVersion> mostCommonVersion(Collection<? extends MavenVersioned> c) {
        if (c.isEmpty()) {
            return Optional.empty();
        }
        HashMap map = new HashMap();
        c.forEach(mv -> map.compute(mv.version(), (k, oldCount) -> oldCount == null ? 1 : oldCount + 1));
        ArrayList entries = new ArrayList(map.entrySet());
        Collections.sort(entries, (a, b) -> ((Integer)b.getValue()).compareTo((Integer)a.getValue()));
        return Optional.of((PomVersion)((Map.Entry)entries.get(0)).getKey());
    }

    private static /* synthetic */ String lambda$updatedWith$0(String newHead, String suffix) {
        if (!((String)suffix).startsWith("-")) {
            suffix = "-" + (String)suffix;
        }
        return newHead + (String)suffix;
    }
}

