/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.maven.model;

import com.mastfrog.function.optional.ThrowingOptional;
import com.mastfrog.util.preconditions.Checks;
import com.telenav.cactus.maven.model.MavenVersioned;
import com.telenav.cactus.maven.model.PomVersion;
import com.telenav.cactus.maven.model.VersionChangeMagnitude;
import com.telenav.cactus.maven.model.VersionFlavorChange;

public final class VersionChange
implements MavenVersioned {
    final PomVersion oldVersion;
    final PomVersion newVersion;

    public VersionChange(PomVersion oldVersion, PomVersion newVersion) {
        this.oldVersion = (PomVersion)Checks.notNull((String)"oldVersion", (Object)oldVersion);
        this.newVersion = (PomVersion)Checks.notNull((String)"newVersion", (Object)newVersion);
    }

    public static ThrowingOptional<VersionChange> versionChange(PomVersion oldVersion, PomVersion newVersion) {
        if (((PomVersion)Checks.notNull((String)"oldVersion", (Object)oldVersion)).equals(Checks.notNull((String)"newVersion", (Object)newVersion))) {
            return ThrowingOptional.empty();
        }
        return ThrowingOptional.of((Object)new VersionChange(oldVersion, newVersion));
    }

    public VersionChangeMagnitude magnitudeChange() {
        return VersionChangeMagnitude.between(this.oldVersion, this.newVersion);
    }

    public VersionFlavorChange flavorChange() {
        return VersionFlavorChange.between(this.oldVersion.flavor(), this.newVersion.flavor());
    }

    public boolean isChange() {
        return !this.oldVersion.equals(this.newVersion);
    }

    public PomVersion oldVersion() {
        return this.oldVersion;
    }

    public PomVersion newVersion() {
        return this.newVersion;
    }

    public PomVersion version(boolean previous) {
        return previous ? this.oldVersion : this.newVersion;
    }

    public static ThrowingOptional<VersionChange> parse(String what) {
        if (what == null || what.isEmpty()) {
            return ThrowingOptional.empty();
        }
        String[] parts = what.split("->");
        if (parts.length != 2) {
            return ThrowingOptional.empty();
        }
        PomVersion from = PomVersion.of(parts[0]);
        PomVersion to = PomVersion.of(parts[1]);
        return ThrowingOptional.of((Object)new VersionChange(from, to));
    }

    public String toString() {
        return this.oldVersion + "->" + this.newVersion;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != VersionChange.class) {
            return false;
        }
        VersionChange other = (VersionChange)o;
        return other.oldVersion().equals(this.oldVersion) && other.newVersion.equals(this.newVersion);
    }

    public int hashCode() {
        return this.newVersion.hashCode() + 71 * this.oldVersion.hashCode();
    }

    @Override
    public ThrowingOptional<String> resolvedVersion() {
        return ThrowingOptional.of((Object)this.newVersion.text());
    }

    @Override
    public PomVersion version() {
        return this.newVersion;
    }
}

