/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.maven.model;

import com.telenav.cactus.maven.model.PomVersion;
import java.util.Iterator;
import java.util.List;

public enum VersionChangeMagnitude {
    MAJOR,
    MINOR,
    DOT,
    NONE;


    public String toString() {
        return this.name().replace('_', '-').toLowerCase();
    }

    public boolean isNone() {
        return this == NONE;
    }

    public VersionChangeMagnitude notNone() {
        return this == NONE ? DOT : this;
    }

    String increment(List<Long> list) {
        if (this == NONE || list.isEmpty()) {
            return VersionChangeMagnitude.toDotted(list);
        }
        this.change(1L, list);
        return VersionChangeMagnitude.toDotted(list);
    }

    String change(long by, List<Long> list) {
        int ix;
        if (this == NONE || list.isEmpty()) {
            return VersionChangeMagnitude.toDotted(list);
        }
        if (this.ordinal() > list.size()) {
            int zeros = this.ordinal() - (list.size() - 1);
            for (int i = 0; i < zeros; ++i) {
                list.add(0L);
            }
            list.add(by);
            ix = list.size() - 1;
        } else {
            ix = Integer.min(this.ordinal(), list.size() - 1);
            list.set(ix, list.get(ix) + by);
        }
        for (int i = ix + 1; i < list.size(); ++i) {
            list.set(i, 0L);
        }
        return VersionChangeMagnitude.toDotted(list);
    }

    String changeTo(long to, List<Long> list) {
        if (this == NONE || list.isEmpty()) {
            return VersionChangeMagnitude.toDotted(list);
        }
        int ix = Integer.min(this.ordinal(), list.size() - 1);
        list.set(ix, to);
        return VersionChangeMagnitude.toDotted(list);
    }

    private static <T> List<T> trim(List<T> list) {
        if (list.size() > 3) {
            return list.subList(0, 3);
        }
        return list;
    }

    public static String toDotted(List<? extends Number> l) {
        StringBuilder sb = new StringBuilder();
        Iterator<? extends Number> it = VersionChangeMagnitude.trim(l).iterator();
        while (it.hasNext()) {
            sb.append(it.next());
            if (!it.hasNext()) continue;
            sb.append('.');
        }
        return sb.toString();
    }

    public static VersionChangeMagnitude between(PomVersion old, PomVersion nue) {
        List<Long> oldDecimals = old.decimals();
        List<Long> newDecimals = nue.decimals();
        if (oldDecimals.isEmpty() || newDecimals.isEmpty()) {
            return NONE;
        }
        int firstChange = -1;
        for (int i = 0; i < Integer.min(oldDecimals.size(), newDecimals.size()); ++i) {
            if (oldDecimals.get(i).equals(newDecimals.get(i))) continue;
            firstChange = i;
            break;
        }
        if (firstChange == -1 && newDecimals.size() > oldDecimals.size()) {
            firstChange = Integer.min(DOT.ordinal(), oldDecimals.size());
        }
        if (firstChange == -1) {
            return NONE;
        }
        return VersionChangeMagnitude.values()[firstChange];
    }
}

