/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.maven.model;

import com.telenav.cactus.maven.model.PomVersion;
import com.telenav.cactus.maven.model.VersionFlavorChange;
import java.util.Optional;

public enum VersionFlavor {
    SNAPSHOT,
    RELEASE,
    OTHER;


    public String toString() {
        return this.name().replace('_', '-').toLowerCase();
    }

    public VersionFlavorChange toThis() {
        switch (this) {
            case SNAPSHOT: {
                return VersionFlavorChange.TO_SNAPSHOT;
            }
            case RELEASE: {
                return VersionFlavorChange.TO_RELEASE;
            }
        }
        return VersionFlavorChange.UNCHANGED;
    }

    public boolean isSnapshot() {
        return this == SNAPSHOT;
    }

    public boolean isRelease() {
        return this == RELEASE;
    }

    public boolean isSuffixed() {
        return this != RELEASE;
    }

    public VersionFlavor opposite() {
        switch (this) {
            case RELEASE: {
                return SNAPSHOT;
            }
            case SNAPSHOT: {
                return RELEASE;
            }
        }
        return this;
    }

    Optional<String> suffixFor(PomVersion ver) {
        switch (this) {
            case SNAPSHOT: {
                return Optional.of("-SNAPSHOT");
            }
            case RELEASE: {
                return Optional.empty();
            }
        }
        return ver.suffix();
    }

    public static VersionFlavor of(String what) {
        return PomVersion.suffixOf(what).map(sfx -> {
            switch (sfx) {
                case "-SNAPSHOT": {
                    return SNAPSHOT;
                }
            }
            return OTHER;
        }).orElse(RELEASE);
    }
}

