/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.maven.model;

import com.telenav.cactus.maven.model.PomVersion;
import com.telenav.cactus.maven.model.VersionFlavor;
import java.util.Optional;

public enum VersionFlavorChange {
    TO_OPPOSITE,
    TO_SNAPSHOT,
    TO_RELEASE,
    UNCHANGED;


    public String toString() {
        return this.name().replace('_', '-').toLowerCase();
    }

    public static VersionFlavorChange between(VersionFlavor a, VersionFlavor b) {
        if (a == b) {
            return UNCHANGED;
        }
        if (a.opposite() == b) {
            return TO_OPPOSITE;
        }
        switch (b) {
            case SNAPSHOT: {
                return TO_SNAPSHOT;
            }
            case RELEASE: {
                return TO_RELEASE;
            }
            case OTHER: {
                return UNCHANGED;
            }
        }
        throw new AssertionError((Object)b);
    }

    public boolean isNone() {
        return this == UNCHANGED;
    }

    public Optional<String> newSuffix(PomVersion version) {
        switch (this) {
            case TO_OPPOSITE: {
                return version.flavor().opposite().suffixFor(version);
            }
            case TO_RELEASE: {
                return VersionFlavor.RELEASE.suffixFor(version);
            }
            case TO_SNAPSHOT: {
                return VersionFlavor.SNAPSHOT.suffixFor(version);
            }
        }
        return version.suffix();
    }
}

