/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.maven.model.dependencies;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;

public enum DependencyScope {
    Compile,
    Test,
    Provided,
    Runtime,
    Import;

    private static Set<DependencyScope> all;
    private Set<DependencyScope> trans;
    private Set<DependencyScope> asSet;

    public String toString() {
        return this.name().toLowerCase();
    }

    public static Set<DependencyScope> transitivityOf(Collection<? extends DependencyScope> scopes) {
        if (scopes.size() == 1) {
            return scopes.iterator().next().transitivity();
        }
        EnumSet<DependencyScope> result = EnumSet.noneOf(DependencyScope.class);
        scopes.forEach(sc -> result.addAll(sc.transitivity()));
        return result;
    }

    public static Set<DependencyScope> all() {
        if (all == null) {
            all = DependencyScope.setOf(DependencyScope.values());
        }
        return Collections.unmodifiableSet(all);
    }

    public Set<DependencyScope> asSet() {
        if (this.asSet == null) {
            this.asSet = EnumSet.of(this);
        }
        return Collections.unmodifiableSet(this.asSet);
    }

    public static Set<DependencyScope> setOf(DependencyScope ... scopes) {
        EnumSet<DependencyScope> result = EnumSet.noneOf(DependencyScope.class);
        for (DependencyScope sc : scopes) {
            result.add(sc);
        }
        return result;
    }

    public Set<DependencyScope> transitivity() {
        if (this.trans != null) {
            return Collections.unmodifiableSet(this.trans);
        }
        switch (this) {
            case Compile: {
                this.trans = Collections.unmodifiableSet(DependencyScope.setOf(Compile, Runtime));
                return this.trans;
            }
            case Test: {
                this.trans = Collections.unmodifiableSet(DependencyScope.setOf(Compile, Runtime, Provided));
                return this.trans;
            }
            case Provided: {
                this.trans = Collections.unmodifiableSet(DependencyScope.setOf(Compile, Runtime, Provided));
                return this.trans;
            }
            case Import: {
                this.trans = Collections.emptySet();
                return this.trans;
            }
            case Runtime: {
                this.trans = Collections.unmodifiableSet(DependencyScope.setOf(Compile, Runtime));
                return this.trans;
            }
        }
        throw new AssertionError((Object)this);
    }

    public static DependencyScope of(String what) {
        if (what == null || what.isBlank()) {
            return Compile;
        }
        switch (what) {
            case "compile": {
                return Compile;
            }
            case "test": {
                return Test;
            }
            case "provided": {
                return Provided;
            }
            case "runtime": {
                return Runtime;
            }
            case "import": {
                return Import;
            }
        }
        return Compile;
    }
}

