/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.maven.model.dependencies;

import com.mastfrog.function.misc.QuietAutoClosable;
import com.mastfrog.function.optional.ThrowingOptional;
import com.mastfrog.function.threadlocal.ThreadLocalStack;
import com.mastfrog.function.threadlocal.ThreadLocalValue;
import com.mastfrog.function.throwing.ThrowingRunnable;
import com.mastfrog.function.throwing.ThrowingSupplier;
import com.mastfrog.util.preconditions.Exceptions;
import com.telenav.cactus.maven.model.ArtifactIdentifiers;
import com.telenav.cactus.maven.model.Dependency;
import com.telenav.cactus.maven.model.Pom;
import com.telenav.cactus.maven.model.dependencies.Dependencies;
import com.telenav.cactus.maven.model.dependencies.DependencyScope;
import com.telenav.cactus.maven.model.internal.PomFile;
import com.telenav.cactus.maven.model.property.CoordinatesPropertyResolver;
import com.telenav.cactus.maven.model.property.ParentsPropertyResolver;
import com.telenav.cactus.maven.model.property.PropertyResolver;
import com.telenav.cactus.maven.model.resolver.PomResolver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiPredicate;
import java.util.function.Supplier;

public class DependencySet
implements Dependencies {
    private static final ThreadLocalStack<Pom> INIT_PATH = ThreadLocalStack.create();
    private static final ThreadLocalValue<ResolutionListener> LISTENER = ThreadLocalValue.create(() -> new DefaultResolutionListener().nonRepeating());
    private final Set<Dependency> dependencyManagement = new HashSet<Dependency>();
    private final List<Dependency> dependencies = new ArrayList<Dependency>();
    private final Pom owner;
    private final PomResolver resolver;
    private final Map<Pom, DependencySet> resolutionContext;
    private final Pom parent;
    private final PropertyResolver localProperties;
    private final CoordinatesPropertyResolver coordinatesResolver;
    private final PropertyResolver fromParentsResolver;
    private boolean initialized;

    public DependencySet(Pom pom, PomResolver poms) throws Exception {
        this(pom, poms.or(PomResolver.local()), new ConcurrentHashMap<Pom, DependencySet>());
    }

    public DependencySet(Pom pom, PomResolver resolver, Map<Pom, DependencySet> resolutionContext) {
        this.owner = pom;
        this.resolver = resolver;
        this.resolutionContext = resolutionContext;
        this.parent = (Pom)pom.parent().flatMapThrowing(par -> resolver.get(par)).orElse(null);
        this.coordinatesResolver = new CoordinatesPropertyResolver(pom, this.parent);
        ParentsPropertyResolver _parentsResolver = new ParentsPropertyResolver(pom, resolver);
        this.fromParentsResolver = _parentsResolver.memoizing();
        this.localProperties = PropertyResolver.lazy(() -> _parentsResolver.resolverFor(pom));
    }

    @Override
    public Set<Dependency> directDependencies(Set<DependencyScope> scope) {
        return this.directDependencies(true, scope);
    }

    @Override
    public Set<Dependency> directDependencies(boolean includeOptional, Set<DependencyScope> scope) {
        if (scope.isEmpty()) {
            this.log(true, "Set of scopes passed to directDependencies() is empty for " + this.owner);
            return Collections.emptySet();
        }
        this.checkInit();
        LinkedHashSet<Dependency> result = new LinkedHashSet<Dependency>();
        for (Dependency d : this.dependencies) {
            if (!scope.contains((Object)d.scope()) || !includeOptional && d.isOptional()) continue;
            result.add(d);
        }
        return result;
    }

    @Override
    public boolean visitDependencyClosure(Set<DependencyScope> scopes, boolean includeOptional, BiPredicate<Pom, Dependency> into) {
        return this.visitDependencyClosure(scopes, includeOptional, Collections.emptySet(), Collections.newSetFromMap(new IdentityHashMap()), into);
    }

    @Override
    public Set<Dependency> dependencyClosure(boolean includeOptional, Set<DependencyScope> scopes) {
        return this.dependencyClosure(scopes, includeOptional, Collections.emptySet(), new HashSet<Object>());
    }

    @Override
    public Set<Dependency> dependencyClosure(Set<DependencyScope> scopes) {
        return this.dependencyClosure(scopes, true, Collections.emptySet(), new HashSet<Object>());
    }

    @Override
    public Set<Dependency> dependencyClosure(DependencyScope ... scope) {
        return this.dependencyClosure(true, scope);
    }

    @Override
    public Set<Dependency> dependencyClosure(boolean includeOptional, DependencyScope ... scope) {
        if (scope.length == 0) {
            scope = DependencyScope.values();
        }
        return this.dependencyClosure(DependencyScope.setOf(scope), true, Collections.emptySet(), Collections.newSetFromMap(new IdentityHashMap()));
    }

    private Set<Dependency> dependencyManagementEntries() {
        this.checkInit();
        return Collections.unmodifiableSet(this.dependencyManagement);
    }

    private PropertyResolver propertyResolver() {
        return this.localProperties;
    }

    private Dependency depManagementEntry(Dependency of) {
        this.checkInit();
        for (Dependency dep : this.dependencyManagement) {
            if (!dep.isCompletionOf(of)) continue;
            return dep;
        }
        return null;
    }

    private synchronized void checkInit() {
        if (!this.initialized) {
            this.initialized = true;
            this.resolutionContext.putIfAbsent(this.owner, this);
            this.init();
        }
    }

    private void init() {
        try {
            PomFile pf = PomFile.of(this.owner);
            pf.inContextRun(() -> this.initialize(pf));
        }
        catch (Exception ex) {
            Exceptions.chuck((Throwable)ex);
        }
    }

    private void initialize(PomFile file) {
        INIT_PATH.pushingThrowing((Object)this.owner, () -> {
            this.log(false, "init " + this.owner.coordinates());
            LinkedHashSet<Dependency> dependenciesLocal = new LinkedHashSet<Dependency>();
            PropertyResolver localResolver = this.coordinatesResolver.or(this.localProperties).memoizing();
            List<Pom> parentsList = Collections.unmodifiableList(this.owner.parents(this.resolver));
            List<Dependency> rawDependencyManagementEntries = file.dependencies(true);
            List<Dependency> rawDependencies = file.dependencies(false);
            this.resolveDependencyManagementEntries(rawDependencyManagementEntries, localResolver, parentsList);
            HashMap<ArtifactIdentifiers, Dependency> managementEntriesFromImports = new HashMap<ArtifactIdentifiers, Dependency>();
            this.collectDependencyManagementItemsFromImportScopeDependencies(rawDependencies, localResolver, parentsList, managementEntriesFromImports);
            LinkedHashMap<ArtifactIdentifiers, Dependency> inheritedById = new LinkedHashMap<ArtifactIdentifiers, Dependency>();
            this.collectDirectDependenciesDefinedInParents(parentsList, inheritedById);
            this.resolveDirectDependencies(rawDependencies, inheritedById, localResolver, parentsList, managementEntriesFromImports, dependenciesLocal);
            dependenciesLocal.addAll(inheritedById.values());
            this.dependencies.addAll(dependenciesLocal);
            this.log(false, "Completed init of " + this.owner.coordinates() + " with " + dependenciesLocal.size() + " dependencies and " + this.dependencyManagement.size() + " depManagement entries");
        });
    }

    private void resolveDirectDependencies(List<Dependency> rawDependencies, Map<ArtifactIdentifiers, Dependency> inheritedById, PropertyResolver localResolver, List<Pom> parentsList, Map<ArtifactIdentifiers, Dependency> managementEntriesFromImports, Set<Dependency> dependenciesLocal) {
        Iterator<Dependency> iterator = rawDependencies.iterator();
        while (iterator.hasNext()) {
            Dependency imported;
            Dependency managementEntry;
            Dependency dep;
            Dependency orig = dep = iterator.next();
            Dependency existing = inheritedById.remove(dep.coordinates().toMavenId());
            if (!dep.isResolved()) {
                dep = dep.resolve(localResolver);
            }
            if ((managementEntry = this.depManagementEntry(dep)) != null) {
                dep = this.applyDependencyManagementPropertiesToDependency(managementEntry, dep);
            }
            if (!dep.isResolved()) {
                dep = this.resolveViaParents(dep, localResolver, parentsList);
            }
            if (existing != null && existing.isResolved() && !dep.isResolved()) {
                dep = existing.withCombinedExclusions(dep.exclusions());
            }
            if (!dep.isResolved()) {
                dep = dep.resolve(this.fromParentsResolver, this.resolver);
            }
            if (!dep.isResolved() && (managementEntry = this.depManagementEntry(dep)) != null) {
                dep = this.applyDependencyManagementPropertiesToDependency(managementEntry, dep);
            }
            if (!dep.isResolved()) {
                this.onResolutionFailure(dep, "dependencies", orig);
            }
            if ((imported = managementEntriesFromImports.get(dep.toMavenId())) != null && !imported.exclusions().isEmpty()) {
                if (!dep.exclusions().isEmpty()) {
                    this.log(true, "Import exclusions in " + imported + " will clobber exclusions in " + dep + " for " + this.owner.coordinates());
                }
                dep = dep.withExclusions(imported.exclusions());
            }
            dependenciesLocal.add(dep);
        }
    }

    private void collectDirectDependenciesDefinedInParents(List<Pom> parentsList, Map<ArtifactIdentifiers, Dependency> inheritedById) {
        for (Pom oneParent : parentsList) {
            DependencySet parentDeps = this.dependenciesOf(oneParent);
            Set<Dependency> direct = parentDeps.directDependencies(DependencyScope.all());
            for (Dependency dep : direct) {
                ArtifactIdentifiers id = dep.coordinates().toMavenId();
                if (inheritedById.containsKey(id)) continue;
                inheritedById.put(id, dep);
            }
        }
    }

    private void collectDependencyManagementItemsFromImportScopeDependencies(List<Dependency> rawDependencies, PropertyResolver localResolver, List<Pom> parentsList, Map<ArtifactIdentifiers, Dependency> managementEntriesFromImports) {
        Iterator<Dependency> iterator = rawDependencies.iterator();
        while (iterator.hasNext()) {
            Dependency dep;
            Dependency raw = dep = iterator.next();
            if (DependencyScope.Import != dep.scope()) continue;
            if (!dep.isResolved()) {
                dep = this.resolveViaParents(dep, localResolver, parentsList);
            }
            if (!dep.isResolved()) {
                this.onResolutionFailure(dep, "importDependencies", raw);
            }
            Dependency d = dep;
            this.resolver.get(dep).ifPresentOrElse(pom -> {
                DependencySet pomSet = this.dependenciesOf((Pom)pom);
                Set<Dependency> entries = pomSet.dependencyManagementEntries();
                this.dependencyManagement.addAll(entries);
                for (Dependency importedDep : this.dependencyManagement) {
                    managementEntriesFromImports.put(importedDep.toMavenId(), importedDep);
                }
                this.dependencyManagement.addAll(pomSet.dependencyManagementEntries());
            }, () -> this.onPomLookupFailure(d, "importDependencies", raw));
        }
    }

    private void resolveDependencyManagementEntries(List<Dependency> rawDependencyManagementEntries, PropertyResolver localResolver, List<Pom> parentsList) {
        Iterator<Dependency> iterator = rawDependencyManagementEntries.iterator();
        while (iterator.hasNext()) {
            Dependency dep;
            Dependency raw = dep = iterator.next();
            if (!dep.isResolved()) {
                dep = dep.resolve(localResolver, this.resolver);
            }
            if (!dep.isResolved()) {
                dep = this.resolveViaParents(dep, localResolver, parentsList);
            }
            if (!dep.isResolved()) {
                this.onResolutionFailure(dep, "importDependencies", raw);
            }
            this.dependencyManagement.add(dep);
        }
    }

    private Dependency applyDependencyManagementPropertiesToDependency(Dependency managementEntry, Dependency dep) {
        if (!managementEntry.isPlaceholderVersion() && dep.isPlaceholderVersion()) {
            dep = dep.withVersion(managementEntry.coordinates().version);
        }
        if (dep.isImplictScope() && !managementEntry.isImplictScope()) {
            dep = dep.withScope(managementEntry.scope());
        }
        if (dep.isImplicitType() && !managementEntry.isImplicitType()) {
            dep = dep.withType(managementEntry.type());
        }
        dep = dep.withCombinedExclusions(managementEntry.exclusions());
        return dep;
    }

    private Dependency resolveViaParents(Dependency dep, PropertyResolver localResolver, List<Pom> traverse) {
        Dependency orig = dep;
        if (!dep.isResolved()) {
            if (!(dep = dep.resolve(localResolver)).isResolved()) {
                dep = this.resolveDependencyUsingParentPoms(traverse, dep);
            }
            dep = dep.withCombinedExclusions(orig.exclusions());
        }
        if (!orig.isImplicitType()) {
            dep = dep.withType(orig.type());
        }
        if (!orig.isImplictScope()) {
            dep = dep.withScope(orig.scope());
        }
        return dep;
    }

    private Dependency resolveDependencyUsingParentPoms(List<Pom> parents, Dependency dep) {
        if (dep.isResolved()) {
            return dep;
        }
        for (Pom pom : parents) {
            Dependency managementEntry;
            DependencySet set = this.dependenciesOf(pom);
            if (!dep.isResolved()) {
                dep = dep.resolve(set.propertyResolver());
            }
            if (!dep.isResolved() && (managementEntry = set.depManagementEntry(dep)) != null) {
                dep = this.applyDependencyManagementPropertiesToDependency(managementEntry, dep);
            }
            if (!dep.isResolved()) continue;
            break;
        }
        return dep;
    }

    private DependencySet dependenciesOf(Pom pom) {
        if (pom.equals(this.owner)) {
            return this;
        }
        return this.resolutionContext.computeIfAbsent(pom, p -> new DependencySet(pom, this.resolver, this.resolutionContext));
    }

    private Set<Dependency> dependencyClosure(Set<DependencyScope> scopes, boolean includeOptional, Set<ArtifactIdentifiers> exclude, Set<Object> traversed) {
        LinkedHashSet<Dependency> result = new LinkedHashSet<Dependency>(256);
        this.collectDependencyClosure(scopes, includeOptional, exclude, traversed, result);
        return result;
    }

    private void collectDependencyClosure(Set<DependencyScope> scopes, boolean includeOptional, Set<ArtifactIdentifiers> exclude, Set<Object> traversed, Set<? super Dependency> into) {
        this.visitDependencyClosure(scopes, includeOptional, exclude, traversed, (p, dep) -> {
            into.add((Dependency)dep);
            return true;
        });
    }

    private boolean visitDependencyClosure(Set<DependencyScope> scopes, boolean includeOptional, Set<ArtifactIdentifiers> exclude, Set<Object> traversed, BiPredicate<Pom, Dependency> into) {
        return (Boolean)INIT_PATH.pushing((Object)this.owner, () -> {
            this.log(false, "Collect dep closure: " + this.owner.coordinates() + " for " + scopes + (!includeOptional ? " excluding optional dependencies" : ""));
            this.checkInit();
            Set<Dependency> direct = this.directDependencies(includeOptional, scopes);
            traversed.add(this);
            Set<DependencyScope> transitiveScopes = DependencyScope.transitivityOf(scopes);
            if (transitiveScopes.isEmpty()) {
                for (Dependency dep : direct) {
                    if (into.test(this.owner, dep)) continue;
                    return false;
                }
                return true;
            }
            for (Dependency dep : direct) {
                if (dep.isOptional() && !includeOptional || !scopes.contains((Object)dep.scope())) continue;
                if (!into.test(this.owner, dep)) {
                    return false;
                }
                Set<ArtifactIdentifiers> combinedExclusions = DependencySet.combineExcludes(exclude, dep);
                ThrowingOptional<Pom> depsPom = this.resolver.get(dep);
                if (depsPom.isPresent()) {
                    Pom dp = (Pom)depsPom.get();
                    DependencySet set = this.dependenciesOf(dp);
                    QuietAutoClosable _ignored = INIT_PATH.push((Object)dp);
                    try {
                        if (set == this) {
                            this.log(true, "Encountered self-dependency analyzing " + dep + " for " + this.owner);
                            continue;
                        }
                        if (traversed.contains(set)) continue;
                        traversed.add(set);
                        boolean keepGoing = set.visitDependencyClosure(transitiveScopes, includeOptional, combinedExclusions, traversed, into);
                        if (keepGoing) continue;
                        Boolean bl = false;
                        return bl;
                    }
                    finally {
                        if (_ignored != null) {
                            _ignored.close();
                        }
                        continue;
                    }
                }
                this.onPomLookupFailure(dep, "fullDeps", dep);
            }
            return true;
        });
    }

    private static Set<ArtifactIdentifiers> combineExcludes(Set<ArtifactIdentifiers> existing, Dependency dep) {
        Set<ArtifactIdentifiers> depExcludes = dep.exclusions();
        if (depExcludes.isEmpty()) {
            return existing;
        }
        if (existing.isEmpty()) {
            return depExcludes;
        }
        HashSet<ArtifactIdentifiers> result = new HashSet<ArtifactIdentifiers>(depExcludes);
        result.addAll(existing);
        return result;
    }

    private void log(boolean important, String msg) {
        LISTENER.usingValue(lis -> lis.log(important, new ResolutionPath(), msg));
    }

    private void onResolutionFailure(Dependency of, String phase, Dependency raw) {
        LISTENER.usingValue(lis -> lis.onResolutionFailure(new ResolutionPath(), of, phase, raw));
    }

    private void onPomLookupFailure(Dependency of, String phase, Dependency raw) {
        LISTENER.usingValue(lis -> lis.onPomLookupFailure(new ResolutionPath(), of, phase, raw));
    }

    public static void withListener(ResolutionListener listener, Runnable run) {
        LISTENER.withValue((Object)listener, run);
    }

    public static void withListenerThrowing(ResolutionListener listener, ThrowingRunnable run) {
        LISTENER.withValueThrowing((Object)listener, run);
    }

    public static <T> T withListener(ResolutionListener listener, Supplier<T> supp) {
        return (T)LISTENER.withValue((Object)listener, supp);
    }

    public static <T> T withListener(ResolutionListener listener, ThrowingSupplier<T> run) {
        return (T)LISTENER.withValueThrowing((Object)listener, run);
    }

    public static final class ResolutionPath
    implements Iterable<Pom> {
        private final List<Pom> poms = Collections.unmodifiableList(INIT_PATH.copy());

        ResolutionPath() {
        }

        public String toString() {
            return this.appendInitPath(new StringBuilder()).toString();
        }

        public StringBuilder appendInitPath(StringBuilder into) {
            if (this.poms.isEmpty()) {
                into.append("-empty-");
                return into;
            }
            Iterator<Pom> it = this.poms.iterator();
            while (it.hasNext()) {
                into.append(it.next().coordinates());
                if (!it.hasNext()) continue;
                into.append("-> ");
            }
            return into;
        }

        @Override
        public Iterator<Pom> iterator() {
            return this.poms.iterator();
        }
    }

    public static interface ResolutionListener {
        public void log(boolean var1, ResolutionPath var2, String var3);

        public void onResolutionFailure(ResolutionPath var1, Dependency var2, String var3, Dependency var4);

        public void onPomLookupFailure(ResolutionPath var1, Dependency var2, String var3, Dependency var4);

        default public ResolutionListener nonRepeating() {
            return new NonRepeatingResolutionListener(this);
        }
    }

    private static final class DefaultResolutionListener
    implements ResolutionListener {
        private DefaultResolutionListener() {
        }

        @Override
        public void log(boolean important, ResolutionPath path, String what) {
            if (important) {
                System.err.println((important ? "!!" : "") + ": " + what + " @ " + path);
            }
        }

        @Override
        public void onResolutionFailure(ResolutionPath path, Dependency of, String phase, Dependency raw) {
            StringBuilder sb = new StringBuilder();
            sb.append(phase).append(": Failure resolving ").append(of).append(' ');
            if (raw != of && !raw.equals(of)) {
                sb.append(" (raw=").append(raw).append(") ");
            }
            sb.append(path);
            System.err.println(sb);
        }

        @Override
        public void onPomLookupFailure(ResolutionPath path, Dependency of, String phase, Dependency raw) {
            StringBuilder sb = new StringBuilder();
            sb.append(phase).append(": POM lookup failure ").append(of).append(' ');
            if (raw != of && !raw.equals(of)) {
                sb.append(" (raw=").append(raw).append(") ");
            }
            sb.append(path);
            System.err.println(sb);
        }
    }

    private static final class NonRepeatingResolutionListener
    implements ResolutionListener {
        private Set<Dependency> resFailures = new HashSet<Dependency>();
        private Set<Dependency> lkpFailures = new HashSet<Dependency>();
        private final Set<String> messages = new HashSet<String>();
        private final ResolutionListener delegate;

        public NonRepeatingResolutionListener(ResolutionListener delegate) {
            this.delegate = delegate;
        }

        @Override
        public void log(boolean important, ResolutionPath path, String what) {
            if (this.messages.add(what)) {
                this.delegate.log(important, path, what);
            }
        }

        @Override
        public void onResolutionFailure(ResolutionPath path, Dependency of, String phase, Dependency raw) {
            if (this.resFailures.add(of)) {
                this.delegate.onResolutionFailure(path, of, phase, raw);
            }
        }

        @Override
        public void onPomLookupFailure(ResolutionPath path, Dependency of, String phase, Dependency raw) {
            if (this.lkpFailures.add(of)) {
                this.delegate.onPomLookupFailure(path, of, phase, raw);
            }
        }

        @Override
        public ResolutionListener nonRepeating() {
            return this;
        }
    }
}

