/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.maven.model.internal;

import com.mastfrog.function.optional.ThrowingOptional;
import com.telenav.cactus.maven.model.ArtifactId;
import com.telenav.cactus.maven.model.ArtifactIdentifiers;
import com.telenav.cactus.maven.model.Dependency;
import com.telenav.cactus.maven.model.GroupId;
import com.telenav.cactus.maven.model.MavenCoordinates;
import com.telenav.cactus.maven.model.ParentMavenCoordinates;
import com.telenav.cactus.maven.model.Pom;
import com.telenav.cactus.maven.model.PomVersion;
import com.telenav.cactus.maven.xml.XMLFile;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class PomFile
extends XMLFile {
    private static final Map<Pom, PomFile> CACHE = Collections.synchronizedMap(new WeakHashMap());

    public PomFile(Path path) {
        super(path);
    }

    public String toString() {
        return this.path().toString();
    }

    public static PomFile of(Pom pom) {
        return CACHE.computeIfAbsent(pom, p -> new PomFile(p.path()));
    }

    public static void note(Pom pom, PomFile pomFile) {
        CACHE.computeIfAbsent(pom, p -> pomFile);
    }

    public boolean isPom() throws ParserConfigurationException, SAXException, IOException, XPathExpressionException {
        return "pom".equals(this.packaging());
    }

    public void visitProperties(BiConsumer<String, String> c) throws Exception {
        this.nodeQuery("/project/properties").ifPresent(nd -> {
            NodeList list = nd.getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                String name;
                Node node = list.item(i);
                if (!(node instanceof Element) || (name = node.getNodeName()) == null || node.getTextContent() == null || node.getTextContent().isBlank()) continue;
                c.accept(name, node.getTextContent().trim());
            }
        });
    }

    public List<Dependency> dependencies(boolean depManagement) throws Exception {
        ArrayList<Dependency> result = new ArrayList<Dependency>();
        this.visitDependencies(depManagement, result::add);
        return result;
    }

    public void visitDependencies(boolean depManagement, Consumer<Dependency> dc) throws Exception {
        String q = depManagement ? "/project/dependencyManagement/dependencies/dependency" : "/project/dependencies/dependency";
        this.nodesQuery(q).ifPresent(depsNodes -> {
            for (int i = 0; i < depsNodes.getLength(); ++i) {
                Map<String, Node> kids;
                Dependency dep;
                Node n = depsNodes.item(i);
                if (!(n instanceof Element) || !"dependency".equals(n.getNodeName()) || (dep = this.toDependency(kids = PomFile.extractElements(n.getChildNodes()))) == null) continue;
                dc.accept(dep);
            }
        });
    }

    private static Map<String, Node> extractElements(NodeList depsNodes) {
        HashMap<String, Node> kids = new HashMap<String, Node>(6);
        for (int i = 0; i < depsNodes.getLength(); ++i) {
            Node n = depsNodes.item(i);
            if (!(n instanceof Element)) continue;
            kids.put(n.getNodeName(), n);
        }
        return kids;
    }

    private Dependency toDependency(Map<String, Node> nodes) {
        ArtifactId aid = ArtifactId.of(nodes.get("artifactId"));
        GroupId gid = GroupId.of(nodes.get("groupId"));
        PomVersion ver = PomVersion.of(nodes.get("version"));
        if (aid == null || gid == null) {
            throw new IllegalStateException("Null aid or gid in " + PomFile.toStringMap(nodes));
        }
        MavenCoordinates coords = new MavenCoordinates(gid, aid, ver);
        boolean optional = "true".equals(PomFile.nodeText((String)"optional", nodes));
        String scope = PomFile.nodeText((String)"scope", nodes);
        String type = PomFile.nodeText((String)"type", nodes);
        Set<ArtifactIdentifiers> exclusions = PomFile.exclusionSet(nodes.get("exclusions"));
        return new Dependency(coords, type, scope, optional, exclusions);
    }

    private static Set<ArtifactIdentifiers> exclusionSet(Node nd) {
        if (nd == null) {
            return Collections.emptySet();
        }
        HashSet<ArtifactIdentifiers> ids = new HashSet<ArtifactIdentifiers>();
        NodeList kids = nd.getChildNodes();
        for (int i = 0; i < kids.getLength(); ++i) {
            Node n = kids.item(i);
            if (!(n instanceof Element) || !"exclusion".equals(n.getNodeName())) continue;
            Map<String, Node> elems = PomFile.extractElements(n.getChildNodes());
            Node aid = elems.get("artifactId");
            Node gid = elems.get("groupId");
            if (aid == null || gid == null) continue;
            ids.add(new ArtifactIdentifiers(gid, aid));
        }
        return ids;
    }

    public ThrowingOptional<ParentMavenCoordinates> parentCoordinates() throws ParserConfigurationException, SAXException, IOException, XPathExpressionException {
        return this.nodeQueryGet("/project/parent/groupId", "/project/parent/artifactId", "/project/parent/version", (gid, aid, ver) -> {
            ThrowingOptional relPath = this.nodeQuery("/project/parent/relativePath");
            return new ParentMavenCoordinates((Node)gid, (Node)aid, (Node)ver, (Node)relPath.orElse(null));
        });
    }

    public MavenCoordinates coordinates() throws ParserConfigurationException, SAXException, IOException, XPathExpressionException {
        ThrowingOptional aid = this.nodeQuery("/project/artifactId");
        ThrowingOptional gid = this.nodeQuery("/project/groupId").or(this.nodeQuery("/project/parent/groupId"));
        ThrowingOptional ver = this.nodeQuery("/project/version").or(this.nodeQuery("/project/parent/version"));
        return new MavenCoordinates((Node)gid.get(), (Node)aid.get(), (Node)ver.get());
    }

    public Set<String> modules() throws ParserConfigurationException, SAXException, IOException, XPathExpressionException {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        XPath xpath = PomFile.xpath();
        Document doc = this.document();
        XPathExpression findModules = xpath.compile("/project/modules/module");
        NodeList moduleNodes = (NodeList)findModules.evaluate(doc, XPathConstants.NODESET);
        if (moduleNodes != null && moduleNodes.getLength() > 0) {
            for (int i = 0; i < moduleNodes.getLength(); ++i) {
                Node n = moduleNodes.item(i);
                result.add(n.getTextContent());
            }
        }
        return result;
    }

    public String packaging() throws ParserConfigurationException, SAXException, IOException, XPathExpressionException {
        XPath xpath = PomFile.xpath();
        Document doc = this.document();
        XPathExpression findPackaging = xpath.compile("/project/packaging");
        Node packagingNode = (Node)findPackaging.evaluate(doc, XPathConstants.NODE);
        return packagingNode == null ? "jar" : packagingNode.getTextContent();
    }
}

