/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.maven.model.property;

import com.telenav.cactus.maven.model.Pom;
import com.telenav.cactus.maven.model.property.CoordinatesPropertyResolver;
import com.telenav.cactus.maven.model.property.ParentsPropertyResolver;
import com.telenav.cactus.maven.model.resolver.PomResolver;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Supplier;

public interface PropertyResolver
extends Iterable<String>,
Function<String, String> {
    public static PropertyResolver parents(Pom pom, PomResolver poms) {
        return new ParentsPropertyResolver(pom, poms);
    }

    public static boolean isResolved(String what) {
        if (what == null) {
            return true;
        }
        int firstPropertyReferenceOpenOffset = what.indexOf("${");
        int lastPropertyCloseOffset = firstPropertyReferenceOpenOffset < 0 ? -1 : what.lastIndexOf(125);
        return firstPropertyReferenceOpenOffset < 0 || lastPropertyCloseOffset <= firstPropertyReferenceOpenOffset;
    }

    public static PropertyResolver coords(Pom self, Pom parent) {
        return new CoordinatesPropertyResolver(self, parent);
    }

    default public PropertyResolver or(final PropertyResolver other) {
        if (other == this) {
            return this;
        }
        return new PropertyResolver(){

            @Override
            public String resolve(String what) {
                String ores;
                String result = PropertyResolver.this.resolve(what);
                if (result != null) {
                    what = result;
                }
                if (!PropertyResolver.isResolved(what) && (ores = other.resolve(what)) != null) {
                    return ores;
                }
                return result == null ? what : result;
            }

            @Override
            public Iterator<String> iterator() {
                TreeSet<String> all = new TreeSet<String>();
                for (String k : PropertyResolver.this) {
                    all.add(k);
                }
                for (String k : other) {
                    all.add(k);
                }
                return all.iterator();
            }

            public String toString() {
                return "or(" + PropertyResolver.this + ", " + other + ")";
            }
        };
    }

    public String resolve(String var1);

    @Override
    default public String apply(String toResolve) {
        return this.resolve(toResolve);
    }

    default public PropertyResolver memoizing() {
        return new PropertyResolver(){
            private final Map<String, Optional<String>> cache = new HashMap<String, Optional<String>>();

            @Override
            public String resolve(String what) {
                return this.cache.computeIfAbsent(what, w -> Optional.ofNullable(PropertyResolver.this.resolve(what))).orElse(null);
            }

            @Override
            public Iterator<String> iterator() {
                return PropertyResolver.this.iterator();
            }

            public String toString() {
                return "memo(" + PropertyResolver.this + ")";
            }

            @Override
            public PropertyResolver memoizing() {
                return this;
            }
        };
    }

    public static PropertyResolver lazy(final Supplier<PropertyResolver> supp) {
        return new PropertyResolver(){
            private PropertyResolver resolver;

            private synchronized PropertyResolver load() {
                return this.resolver == null ? (this.resolver = (PropertyResolver)supp.get()) : this.resolver;
            }

            @Override
            public String resolve(String what) {
                return this.load().resolve(what);
            }

            @Override
            public Iterator<String> iterator() {
                return this.load().iterator();
            }

            public String toString() {
                if (this.resolver == null) {
                    return "Lazy<unloaded>";
                }
                return this.resolver.toString();
            }
        };
    }
}

