/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.maven.model.resolver;

import com.mastfrog.function.optional.ThrowingOptional;
import com.mastfrog.function.throwing.ThrowingFunction;
import com.telenav.cactus.maven.model.Pom;
import com.telenav.cactus.maven.model.property.PropertyResolver;
import com.telenav.cactus.maven.model.resolver.PomResolver;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

final class MemoizingPomResolver
implements PomResolver {
    private final PomResolver delegate;
    private final Map<String, ThrowingOptional<Pom>> sansVersion = new ConcurrentHashMap<String, ThrowingOptional<Pom>>();
    private final Map<String, ThrowingOptional<Pom>> withVersion = new ConcurrentHashMap<String, ThrowingOptional<Pom>>();
    private final Map<Pom, PropertyResolver> resolvers = new ConcurrentHashMap<Pom, PropertyResolver>();

    MemoizingPomResolver(PomResolver delegate) {
        this.delegate = delegate;
    }

    @Override
    public PropertyResolver propertyResolver(Pom pom) {
        ThrowingFunction sup = x$0 -> PomResolver.super.propertyResolver((Pom)x$0);
        return this.resolvers.computeIfAbsent(pom, sup.toNonThrowing());
    }

    @Override
    public PomResolver or(PomResolver parent) {
        return this.delegate.or(parent).memoizing();
    }

    @Override
    public ThrowingOptional<Pom> get(String groupId, String artifactId) {
        String key = groupId + ":" + artifactId;
        return this.sansVersion.computeIfAbsent(key, k -> {
            ThrowingOptional<Pom> result = this.delegate.get(groupId, artifactId);
            result.ifPresent(pom -> pom.coordinates().resolvedVersion().ifPresent(ver -> {
                String vk = k + ":" + ver;
                this.withVersion.put(vk, (ThrowingOptional<Pom>)ThrowingOptional.of((Object)pom));
            }));
            return result;
        });
    }

    @Override
    public ThrowingOptional<Pom> get(String groupId, String artifactId, String version) {
        String key = groupId + ":" + artifactId + ":" + version;
        return this.withVersion.computeIfAbsent(key, k -> this.delegate.get(groupId, artifactId, version));
    }

    @Override
    public PomResolver memoizing() {
        return this;
    }

    public String toString() {
        return "memo(" + this.delegate + ")";
    }
}

