/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.maven.model.resolver.versions;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class VersionComparator
implements Comparator<String> {
    public static final VersionComparator INSTANCE = new VersionComparator();
    private static final Pattern NUMBER_PATTERN = Pattern.compile("^(\\d+)$");

    private VersionComparator() {
    }

    @Override
    public int compare(String a, String b) {
        return VersionComparator.performComparison(a, b);
    }

    private static int compare(List<Long> as, List<Long> bs) {
        for (int i = 0; i < Integer.min(as.size(), bs.size()); ++i) {
            long b;
            long a = as.get(i);
            int res = Long.compare(a, b = bs.get(i).longValue());
            if (res == 0) continue;
            return res;
        }
        return 0;
    }

    public static List<Long> extractNumerics(String[] parts) {
        ArrayList<Long> result = new ArrayList<Long>();
        for (String s : parts) {
            Matcher m = NUMBER_PATTERN.matcher(s);
            if (!m.find()) continue;
            String nums = m.group(1);
            result.add(Long.parseLong(nums));
        }
        return result;
    }

    private static int performComparison(String a, String b) {
        String[] aSplit = a.split("\\.");
        String[] bSplit = b.split("\\.");
        if (aSplit.length == 1 && bSplit.length == 1) {
            return aSplit[0].compareTo(bSplit[0]);
        }
        List<Long> aNumerics = VersionComparator.extractNumerics(aSplit);
        List<Long> bNumerics = VersionComparator.extractNumerics(bSplit);
        int result = 0;
        if (!aNumerics.isEmpty() && !bNumerics.isEmpty()) {
            result = VersionComparator.compare(aNumerics, bNumerics);
            if (result == 0) {
                result = Integer.compare(aNumerics.size(), bNumerics.size());
            }
            if (result == 0) {
                result = Integer.compare(a.length(), b.length());
            }
        }
        if (result == 0) {
            result = a.compareTo(b);
        }
        return result;
    }
}

