/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.maven.model.resolver.versions;

import com.mastfrog.function.state.Bool;
import com.mastfrog.util.preconditions.Checks;
import com.telenav.cactus.maven.model.resolver.versions.ExactMatcher;
import com.telenav.cactus.maven.model.resolver.versions.PrefixMatcher;
import com.telenav.cactus.maven.model.resolver.versions.RangeBounds;
import com.telenav.cactus.maven.model.resolver.versions.RangeBoundsSet;
import com.telenav.cactus.maven.model.resolver.versions.VersionPredicate;
import java.util.ArrayList;
import java.util.function.Consumer;

public final class VersionMatchers {
    private static int visitGroups(String spec, Bool valid, Consumer<String> groupConsumer) {
        int result = 0;
        valid.set(true);
        StringBuilder currGroup = new StringBuilder();
        boolean inGroup = false;
        int maxLength = 0;
        block5: for (int i = 0; i < spec.length(); ++i) {
            char c = spec.charAt(i);
            switch (c) {
                case '(': 
                case '[': {
                    if (inGroup) {
                        valid.set(false);
                    } else {
                        inGroup = true;
                        currGroup.setLength(0);
                    }
                    currGroup.append(c);
                    continue block5;
                }
                case ',': {
                    if (!inGroup) continue block5;
                    currGroup.append(c);
                    continue block5;
                }
                case ')': 
                case ']': {
                    if (inGroup) {
                        currGroup.append(c);
                        inGroup = false;
                        maxLength = Math.max(maxLength, currGroup.length());
                        groupConsumer.accept(currGroup.toString());
                        ++result;
                        currGroup.setLength(0);
                        continue block5;
                    }
                    valid.set(false);
                    continue block5;
                }
                default: {
                    if (!inGroup) {
                        valid.set(false);
                    }
                    currGroup.append(c);
                }
            }
        }
        if (maxLength == 0) {
            valid.set(false);
        }
        return result;
    }

    public static VersionPredicate<String> matcher(String spec) {
        ExactMatcher result = VersionMatchers.matcherInternal(spec);
        if (!result.isValid()) {
            System.err.println("Invalid range spec: '" + spec + "'");
            result = new ExactMatcher(spec);
        }
        return result;
    }

    static VersionPredicate<String> matcherInternal(String spec) {
        String stripped = VersionMatchers.stripWhitespace((String)Checks.notNull((String)"spec", (Object)spec));
        if (stripped.endsWith("-SNAPSHOT")) {
            return new ExactMatcher(stripped);
        }
        if (VersionMatchers.looksLikeRange(stripped)) {
            ArrayList<RangeBounds> terms = new ArrayList<RangeBounds>();
            Bool validInput = Bool.create();
            VersionMatchers.visitGroups(spec, validInput, bounds -> terms.add(new RangeBounds((String)bounds)));
            return new RangeBoundsSet(terms, validInput.getAsBoolean(), stripped);
        }
        if (stripped.indexOf(46) < 0) {
            return new ExactMatcher(stripped);
        }
        return new PrefixMatcher(stripped);
    }

    public static boolean looksLikeRange(String version) {
        boolean result;
        boolean bl = result = version.length() > 3;
        if (result) {
            char first = version.charAt(0);
            char last = version.charAt(version.length() - 1);
            block0 : switch (first) {
                case '(': 
                case '[': {
                    switch (last) {
                        case ')': 
                        case ']': {
                            break block0;
                        }
                    }
                    result = false;
                    break;
                }
                default: {
                    result = false;
                }
            }
        }
        return result;
    }

    static String stripWhitespace(String version) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < version.length(); ++i) {
            char c = version.charAt(i);
            if (Character.isWhitespace(c)) continue;
            result.append(c);
        }
        return result.toString();
    }

    private VersionMatchers() {
        throw new AssertionError();
    }
}

