/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.maven.model;

import com.mastfrog.util.preconditions.Checks;
import com.telenav.cactus.maven.model.ArtifactId;
import com.telenav.cactus.maven.model.GroupId;
import com.telenav.cactus.maven.model.MavenIdentified;
import org.w3c.dom.Node;

public class ArtifactIdentifiers
implements MavenIdentified {
    public final GroupId groupId;
    public final ArtifactId artifactId;

    public ArtifactIdentifiers(GroupId groupId, ArtifactId artifactId) {
        this.groupId = (GroupId)Checks.notNull((String)"groupId", (Object)groupId);
        this.artifactId = (ArtifactId)Checks.notNull((String)"artifactId", (Object)artifactId);
    }

    public ArtifactIdentifiers(Node groupId, Node artifactId) {
        this(GroupId.of(groupId), ArtifactId.of(artifactId));
    }

    public ArtifactIdentifiers(String gid, String aid) {
        this(GroupId.of(gid), ArtifactId.of(aid));
    }

    @Override
    public GroupId groupId() {
        return this.groupId;
    }

    @Override
    public ArtifactId artifactId() {
        return this.artifactId;
    }

    public String toString() {
        return this.groupId + ":" + this.artifactId;
    }

    public int hashCode() {
        return 2 + 13 * this.artifactId.hashCode() + 31 * this.groupId.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof ArtifactIdentifiers)) {
            return false;
        }
        ArtifactIdentifiers m = (ArtifactIdentifiers)o;
        return this.is(m);
    }
}

