/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.maven.model;

import com.mastfrog.function.optional.ThrowingOptional;
import com.mastfrog.util.preconditions.Checks;
import com.telenav.cactus.maven.model.ArtifactId;
import com.telenav.cactus.maven.model.ArtifactIdentifiers;
import com.telenav.cactus.maven.model.GroupId;
import com.telenav.cactus.maven.model.MavenArtifactCoordinates;
import com.telenav.cactus.maven.model.MavenCoordinates;
import com.telenav.cactus.maven.model.MavenIdentified;
import com.telenav.cactus.maven.model.Packaging;
import com.telenav.cactus.maven.model.PomVersion;
import com.telenav.cactus.maven.model.dependencies.DependencyScope;
import com.telenav.cactus.maven.model.property.PropertyResolver;
import com.telenav.cactus.maven.model.resolver.PomResolver;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class Dependency
implements MavenArtifactCoordinates {
    private final MavenCoordinates coords;
    private final Packaging type;
    private final DependencyScope scope;
    private final boolean optional;
    private final Set<ArtifactIdentifiers> exclusions;
    private final boolean implicitScope;
    private final boolean implicitType;

    public Dependency(MavenCoordinates coords, String type, String scope, boolean optional, Set<ArtifactIdentifiers> exclusions) {
        this(coords, type, DependencyScope.of(scope), optional, exclusions);
    }

    public Dependency(MavenCoordinates coords, String type, DependencyScope scope, boolean optional, Set<ArtifactIdentifiers> exclusions) {
        this.coords = (MavenCoordinates)Checks.notNull((String)"coords", (Object)coords);
        this.type = type == null ? Packaging.JAR : Packaging.packaging(type);
        this.scope = scope == null ? DependencyScope.Compile : scope;
        this.implicitScope = scope == null;
        this.implicitType = type == null;
        this.optional = optional;
        this.exclusions = exclusions == null || exclusions.isEmpty() ? Collections.emptySet() : Collections.unmodifiableSet(new HashSet<ArtifactIdentifiers>(exclusions));
    }

    private Dependency(MavenCoordinates coords, Packaging type, boolean implicitType, DependencyScope scope, boolean implicitScope, Set<ArtifactIdentifiers> exclusions, boolean optional) {
        this.coords = (MavenCoordinates)Checks.notNull((String)"coords", (Object)coords);
        this.type = (Packaging)Checks.notNull((String)"type", (Object)type);
        this.scope = (DependencyScope)((Object)Checks.notNull((String)"scope", (Object)((Object)scope)));
        this.exclusions = exclusions.isEmpty() ? exclusions : Collections.unmodifiableSet(exclusions);
        this.implicitScope = implicitScope;
        this.implicitType = implicitType;
        this.optional = optional;
    }

    public Set<ArtifactIdentifiers> exclusions() {
        return this.exclusions;
    }

    public boolean excludes(MavenIdentified artifact) {
        Checks.notNull((String)"artifact", (Object)artifact);
        for (ArtifactIdentifiers ids : this.exclusions) {
            if (!ids.is(artifact)) continue;
            return true;
        }
        return false;
    }

    public boolean isImplictScope() {
        return this.implicitScope;
    }

    public boolean isImplicitType() {
        return this.implicitType;
    }

    public boolean isPlaceholderVersion() {
        return this.coords.version.isPlaceholder();
    }

    public Dependency withVersion(PomVersion version) {
        if (this.coords.version.equals(Checks.notNull((String)"version", (Object)version))) {
            return this;
        }
        MavenCoordinates newCoords = this.coords.withVersion(version);
        return new Dependency(newCoords, this.implicitType ? null : this.type.toString(), this.implicitScope ? null : this.scope, this.optional, this.exclusions);
    }

    @Override
    public Dependency withVersion(String version) {
        if (this.coords.version.is(version)) {
            return this;
        }
        MavenCoordinates newCoords = this.coords.withVersion(version);
        return new Dependency(newCoords, this.type, this.implicitType, this.scope, this.implicitScope, this.exclusions, this.optional);
    }

    public Dependency withType(String type) {
        if (this.type.is(type)) {
            return this;
        }
        return new Dependency(this.coords, type, this.implicitScope ? null : this.scope, this.optional, this.exclusions);
    }

    public Dependency withType(Packaging type) {
        if (this.type.equals(type)) {
            return this;
        }
        return new Dependency(this.coords, type, false, this.scope, this.implicitScope, this.exclusions, this.optional);
    }

    public Dependency withScope(DependencyScope scope) {
        if (scope == this.scope) {
            return this;
        }
        return new Dependency(this.coords, this.type, this.implicitType, scope, this.implicitScope, this.exclusions, this.optional);
    }

    public Dependency withExclusions(Collection<? extends ArtifactIdentifiers> excl) {
        if (this.exclusions.equals(this.exclusions)) {
            return this;
        }
        return new Dependency(this.coords, this.type, this.implicitType, this.scope, this.implicitScope, (Set<ArtifactIdentifiers>)(this.exclusions.isEmpty() ? Collections.emptySet() : new HashSet<ArtifactIdentifiers>(this.exclusions)), this.optional);
    }

    public Dependency withCombinedExclusions(Collection<? extends ArtifactIdentifiers> exclusions) {
        if (exclusions == this.exclusions || exclusions.equals(this.exclusions) || exclusions.isEmpty()) {
            return this;
        }
        HashSet<ArtifactIdentifiers> result = new HashSet<ArtifactIdentifiers>(exclusions);
        result.addAll(this.exclusions);
        return new Dependency(this.coords, this.type, this.implicitType, this.scope, this.implicitScope, result, this.optional);
    }

    public boolean isCompletionOf(Dependency other) {
        if (!this.isResolved()) {
            return false;
        }
        return this.artifactId().equals(other.artifactId()) && this.groupId().equals(other.groupId()) && (this.type.equals(other.type) || other.implicitType);
    }

    public ArtifactIdentifiers toMavenId() {
        return this.coords.toMavenId();
    }

    @Override
    public GroupId groupId() {
        return this.coords.groupId();
    }

    @Override
    public ArtifactId artifactId() {
        return this.coords.artifactId();
    }

    @Override
    public PomVersion version() {
        return this.coords.version();
    }

    @Override
    public ThrowingOptional<String> resolvedVersion() {
        return this.coords.resolvedVersion();
    }

    @Override
    public boolean isResolved() {
        return this.coords.isResolved();
    }

    public boolean isOptional() {
        return this.optional;
    }

    public Dependency resolve(PropertyResolver res) {
        MavenCoordinates cds = this.coords.resolve(res);
        if (cds != this.coords) {
            return new Dependency(cds, this.type, this.implicitType, this.scope, this.implicitScope, this.exclusions, this.optional);
        }
        return this;
    }

    public Dependency resolve(PropertyResolver res, PomResolver poms) {
        MavenCoordinates result = this.coords.resolve(res, poms);
        if (result != this.coords) {
            return new Dependency(result, this.type, this.implicitType, this.scope, this.implicitScope, this.exclusions, this.optional);
        }
        return this;
    }

    public int hashCode() {
        int hash = 7;
        hash = 11 * hash + Objects.hashCode(this.coords);
        hash = 11 * hash + Objects.hashCode(this.type);
        hash = 11 * hash + this.scope.ordinal();
        hash = 11 * hash + (this.optional ? 1 : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != Dependency.class) {
            return false;
        }
        Dependency other = (Dependency)obj;
        if (this.optional != other.optional) {
            return false;
        }
        if (!Objects.equals(this.type, other.type)) {
            return false;
        }
        if (!Objects.equals((Object)this.scope, (Object)other.scope)) {
            return false;
        }
        return Objects.equals(this.coords, other.coords);
    }

    public String toString() {
        return this.type + "(" + this.coords + "=" + this.scope + (String)(this.exclusions.isEmpty() ? "" : " excluding=" + this.exclusions.toString() + (this.optional ? " optional" : "")) + ")";
    }

    public MavenCoordinates coordinates() {
        return this.coords;
    }

    public Packaging type() {
        return this.type;
    }

    public DependencyScope scope() {
        return this.scope;
    }

    public boolean isImplicitScope() {
        return this.implicitScope;
    }
}

