/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.maven.model;

import com.mastfrog.function.optional.ThrowingOptional;
import com.mastfrog.util.preconditions.Checks;
import com.telenav.cactus.maven.model.DiskResident;
import com.telenav.cactus.maven.model.Pom;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;

public final class MavenModule
implements DiskResident,
Comparable<MavenModule> {
    private final String name;
    private final Pom owner;

    MavenModule(String name, Pom owner) {
        this.name = (String)Checks.notNull((String)"name", (Object)name);
        this.owner = (Pom)Checks.notNull((String)"owner", (Object)owner);
    }

    public MavenModule module(String name, Pom owner) {
        return new MavenModule(name, owner);
    }

    static Set<MavenModule> fromStrings(Pom in, Collection<? extends String> strings) {
        if (strings == null || strings.isEmpty()) {
            return Collections.emptySet();
        }
        TreeSet<MavenModule> result = new TreeSet<MavenModule>();
        for (String string : strings) {
            result.add(new MavenModule(string, in));
        }
        return result;
    }

    public ThrowingOptional<Pom> toPom() {
        return Pom.from(this.pom());
    }

    public Pom owner() {
        return this.owner;
    }

    public String name() {
        return this.name;
    }

    public String toString() {
        return this.name();
    }

    @Override
    public Path path() {
        return this.owner.projectFolder().resolve(this.name);
    }

    public Path pom() {
        return this.path().resolve("pom.xml");
    }

    public boolean exists() {
        return Files.exists(this.pom(), new LinkOption[0]);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != MavenModule.class) {
            return false;
        }
        MavenModule other = (MavenModule)o;
        return this.name().equals(other.name()) && other.owner().toArtifactIdentifiers().equals(this.owner.toArtifactIdentifiers());
    }

    public int hashCode() {
        return this.name().hashCode() * 31 + 11 * this.owner.toArtifactIdentifiers().hashCode();
    }

    @Override
    public int compareTo(MavenModule o) {
        return this.name().compareTo(o.name());
    }
}

