/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.maven.model;

import com.mastfrog.function.optional.ThrowingOptional;
import com.mastfrog.util.preconditions.Checks;
import com.telenav.cactus.maven.model.Resolvable;
import com.telenav.cactus.maven.model.property.PropertyResolver;
import java.util.function.Function;
import java.util.function.IntSupplier;
import java.util.function.Predicate;
import org.w3c.dom.Node;

public abstract class ResolvablePomElement<E extends ResolvablePomElement<E>>
implements Comparable<E>,
Resolvable<E> {
    public static final String PLACEHOLDER = "-**-";
    private final String value;

    ResolvablePomElement(String value) {
        this.value = (String)Checks.notNull((String)"value", (Object)value);
    }

    ResolvablePomElement(Node node) {
        this(ResolvablePomElement.textOrPlaceholder(node));
    }

    private static String textOrPlaceholder(Node node) {
        return node == null || node.getTextContent().isBlank() ? PLACEHOLDER : node.getTextContent().trim();
    }

    protected final E cast() {
        return (E)this;
    }

    public final String text() {
        return this.value;
    }

    @Override
    public final E resolve(Function<String, String> transform) {
        String resolvedValue;
        if (!this.isResolved() && (resolvedValue = transform.apply(this.value)) != null && !resolvedValue.equals(this.value)) {
            return this.newInstance(resolvedValue);
        }
        return this.cast();
    }

    public final boolean textContains(String text) {
        return this.value.contains((CharSequence)Checks.notNull((String)"text", (Object)text));
    }

    public final boolean textStartsWith(String text) {
        return this.value.startsWith((String)Checks.notNull((String)"text", (Object)text));
    }

    public final boolean textEndsWith(String text) {
        return this.value.endsWith((String)Checks.notNull((String)"text", (Object)text));
    }

    public final boolean textMatches(Predicate<String> test) {
        return ((Predicate)Checks.notNull((String)"test", test)).test(this.value);
    }

    protected abstract E newInstance(String var1);

    @Override
    public final boolean isResolved() {
        return PropertyResolver.isResolved(this.value) && !this.isPlaceholder() && this.internalIsResolved();
    }

    public final boolean isUnresolvedProperty() {
        return !PropertyResolver.isResolved(this.text());
    }

    public final boolean isPlaceholder() {
        return PLACEHOLDER.equals(this.value);
    }

    public ThrowingOptional<String> ifResolved() {
        if (this.isResolved()) {
            return ThrowingOptional.of((Object)this.value);
        }
        return ThrowingOptional.empty();
    }

    public final boolean is(String what) {
        return this.value.equals(what);
    }

    boolean internalIsResolved() {
        return true;
    }

    public final String toString() {
        return this.value;
    }

    public final boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        ResolvablePomElement other = (ResolvablePomElement)o;
        return other.value.equals(this.value);
    }

    public final int hashCode() {
        return 129 * (this.getClass().hashCode() + 1) * this.value.hashCode();
    }

    @Override
    public int compareTo(E o) {
        return this.value.compareTo(((ResolvablePomElement)o).text());
    }

    public final int compare(E other, IntSupplier fallback) {
        int result = this.compareTo(other);
        if (result == 0) {
            result = fallback.getAsInt();
        }
        return result;
    }
}

