/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.maven.model.property;

import com.telenav.cactus.maven.model.property.PropertyResolver;
import java.util.Iterator;
import java.util.TreeSet;

abstract class AbstractPropertyResolver
implements PropertyResolver {
    AbstractPropertyResolver() {
    }

    protected abstract String valueFor(String var1);

    @Override
    public PropertyResolver or(PropertyResolver other) {
        if (other instanceof AbstractPropertyResolver) {
            return new ComboPropertyResolver(this, (AbstractPropertyResolver)other);
        }
        return PropertyResolver.super.or(other);
    }

    @Override
    public String resolve(String what) {
        String val = what;
        if (val != null && !PropertyResolver.isResolved(what)) {
            StringBuilder result = new StringBuilder();
            AbstractPropertyResolver.visitSegments(val, (part, needsResolution) -> {
                if (!needsResolution) {
                    result.append(part);
                } else {
                    String res = this.valueFor(part);
                    if (res != null) {
                        if (res.length() > 3 && res.equals(part)) {
                            throw new IllegalStateException("In " + what + " resolved '" + part + "' to itself by " + this);
                        }
                        result.append(res);
                    } else {
                        result.append("${").append(part).append("}");
                    }
                }
            });
            return result.toString();
        }
        if (what.equals(val)) {
            return null;
        }
        return val;
    }

    static void visitSegments(String what, ResolvableVisitor v) {
        StringBuilder output = new StringBuilder();
        StringBuilder curr = new StringBuilder();
        boolean inProperty = false;
        for (int i = 0; i < what.length(); ++i) {
            char c = what.charAt(i);
            if (c == '$' && i < what.length() - 1 && what.charAt(i + 1) == '{') {
                if (inProperty) {
                    v.visit("${" + curr, false);
                    curr.setLength(0);
                } else if (output.length() > 0) {
                    v.visit(output.toString(), false);
                    output.setLength(0);
                }
                ++i;
                inProperty = true;
                continue;
            }
            if (inProperty && c == '}') {
                inProperty = false;
                v.visit(curr.toString(), true);
                curr.setLength(0);
                continue;
            }
            if (inProperty) {
                curr.append(c);
                continue;
            }
            output.append(c);
        }
        if (curr.length() > 0) {
            v.visit("${" + curr, false);
        }
        if (output.length() > 0) {
            v.visit(output.toString(), false);
        }
    }

    static final class ComboPropertyResolver
    extends AbstractPropertyResolver {
        private final AbstractPropertyResolver a;
        private final AbstractPropertyResolver b;

        ComboPropertyResolver(AbstractPropertyResolver a, AbstractPropertyResolver b) {
            this.a = a;
            this.b = b;
        }

        public String toString() {
            return "or(" + this.a + ", " + this.b + ")";
        }

        @Override
        protected String valueFor(String k) {
            String result = this.a.valueFor(k);
            if (result == null) {
                result = this.b.valueFor(k);
            } else if (!PropertyResolver.isResolved(result)) {
                result = this.a.valueFor(result);
            }
            return result;
        }

        @Override
        public Iterator<String> iterator() {
            TreeSet result = new TreeSet();
            this.a.forEach(result::add);
            this.b.forEach(result::add);
            return result.iterator();
        }
    }

    static interface ResolvableVisitor {
        public void visit(String var1, boolean var2);
    }
}

