/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.maven.model.property;

import com.mastfrog.util.preconditions.Checks;
import com.telenav.cactus.maven.model.Pom;
import com.telenav.cactus.maven.model.property.AbstractPropertyResolver;
import com.telenav.cactus.maven.model.resolver.PomResolver;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public final class CoordinatesPropertyResolver
extends AbstractPropertyResolver {
    private static final String PARENT_VERSION = "parent.version";
    private static final String PROJECT_PARENT_VERSION = "project.parent.version";
    private static final String PARENT_ARTIFACT_ID = "parent.artifactId";
    private static final String PROJECT_PARENT_ARTIFACT_ID = "project.parent.artifactId";
    private static final String PARENT_GROUP_ID = "parent.groupId";
    private static final String PROJECT_PARENT_GROUP_ID = "project.parent.groupId";
    private static final String PROJECT_GROUP_ID = "project.groupId";
    private static final String PROJECT_ARTIFACT_ID = "project.artifactId";
    private static final String PROJECT_VERSION = "project.version";
    private static final String MAVEN_VERSION = "maven.version";
    private static final String JAVA_VERSION = "java.version";
    private static final String BASEDIR = "basedir";
    private static final String PROJECT_BASEDIR = "project.basedir";
    private static final String PARENT_BASEDIR = "parent.basedir";
    private static final String PROJECT_PARENT_BASEDIR = "project.parent.basedir";
    private static String FAKE_MAVEN_VERSION = "3.8.5";
    private static final List<String> NO_PARENT_KEYS = Collections.unmodifiableList(Arrays.asList("project.groupId", "project.artifactId", "project.version", "basedir", "project.basedir", "maven.version", "java.version"));
    private static final List<String> WITH_PARENT_KEYS = Collections.unmodifiableList(Arrays.asList("project.groupId", "project.artifactId", "project.version", "parent.groupId", "parent.artifactId", "parent.version", "project.parent.groupId", "project.parent.artifactId", "project.parent.version", "maven.version", "java.version", "basedir", "project.basedir", "parent.basedir", "project.parent.basedir"));
    private final Pom self;
    private final Pom parent;
    private final List<String> keys;

    public static void setMavenVersion(String mavenVersion) {
        FAKE_MAVEN_VERSION = mavenVersion;
    }

    public CoordinatesPropertyResolver(Pom self, Pom parent) {
        this.self = (Pom)Checks.notNull((String)"self", (Object)self);
        this.parent = parent;
        if (PROJECT_GROUP_ID.equals(self.groupId().text())) {
            throw new IllegalStateException("" + self);
        }
        if (parent != null && PROJECT_GROUP_ID.equals(parent.groupId().text())) {
            throw new IllegalStateException("" + parent);
        }
        this.keys = parent != null ? WITH_PARENT_KEYS : NO_PARENT_KEYS;
    }

    public CoordinatesPropertyResolver(Pom pom, PomResolver res) {
        this(pom, (Pom)pom.parent().flatMapThrowing(x -> res.get(x)).orElse(null));
    }

    public String toString() {
        return "Coordinates(" + this.self + (String)(this.parent == null ? ", " + this.parent : "") + ")";
    }

    @Override
    protected String valueFor(String k) {
        if (k.startsWith("${")) {
            // empty if block
        }
        if (this.parent != null) {
            switch (k) {
                case "project.parent.groupId": 
                case "parent.groupId": {
                    return this.parent.groupId().text();
                }
                case "project.parent.artifactId": 
                case "parent.artifactId": {
                    return this.parent.artifactId().text();
                }
                case "project.parent.version": 
                case "parent.version": {
                    if (this.parent.resolvedVersion().isPresent()) {
                        return (String)this.parent.resolvedVersion().get();
                    }
                    return null;
                }
                case "parent.basedir": {
                    return this.parent.projectFolder().toString();
                }
            }
        }
        switch (k) {
            case "maven.version": {
                return FAKE_MAVEN_VERSION;
            }
            case "java.version": {
                return System.getProperty(JAVA_VERSION);
            }
            case "project.groupId": {
                return this.self.groupId().text();
            }
            case "project.version": {
                if (!this.self.resolvedVersion().isPresent()) break;
                return (String)this.self.resolvedVersion().get();
            }
            case "project.artifactId": {
                return this.self.artifactId().text();
            }
        }
        return null;
    }

    @Override
    public Iterator<String> iterator() {
        return this.keys.iterator();
    }
}

