/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.maven.model.property;

import com.mastfrog.util.preconditions.Exceptions;
import com.telenav.cactus.maven.model.Pom;
import com.telenav.cactus.maven.model.property.AbstractPropertyResolver;
import com.telenav.cactus.maven.model.property.MapPropertyResolver;
import com.telenav.cactus.maven.model.resolver.PomResolver;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

public final class ParentsPropertyResolver
extends AbstractPropertyResolver {
    private final List<Pom> allPoms;
    private final Map<Pom, MapPropertyResolver> resolverForPom = new HashMap<Pom, MapPropertyResolver>();

    public ParentsPropertyResolver(Pom pom, PomResolver pomResolver) {
        this.allPoms = pom.hierarchyDescending(pomResolver);
    }

    @Override
    public synchronized String resolve(String what) {
        return super.resolve(what);
    }

    public String toString() {
        return "parents(" + this.allPoms + ")";
    }

    @Override
    public Iterator<String> iterator() {
        TreeSet<String> result = new TreeSet<String>();
        for (Pom p : this.allPoms) {
            result.addAll(this.resolverFor(p).keys());
        }
        return result.iterator();
    }

    @Override
    protected String valueFor(String k) {
        for (Pom pom : this.allPoms) {
            String x = this.resolverFor(pom).valueFor(k);
            if (x == null || k.equals(x)) continue;
            return x;
        }
        return null;
    }

    public MapPropertyResolver resolverFor(Pom pom) {
        return this.resolverForPom.computeIfAbsent(pom, p -> {
            try {
                return new MapPropertyResolver(p.properties());
            }
            catch (Exception ex) {
                return (MapPropertyResolver)Exceptions.chuck((Throwable)ex);
            }
        });
    }
}

