/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.maven.model.published;

import com.telenav.cactus.maven.model.DiskResident;
import com.telenav.cactus.maven.model.MavenArtifactCoordinates;
import com.telenav.cactus.maven.model.published.PublishedState;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.time.Duration;

public class PublishChecker {
    private static final String DEFAULT_REPO = "https://repo1.maven.org/maven2/";
    private static HttpClient client;
    private final String baseUrl;

    private static synchronized HttpClient client() {
        return client == null ? (client = HttpClient.newHttpClient()) : client;
    }

    public PublishChecker(String repo) {
        this.baseUrl = repo;
    }

    public PublishChecker() {
        this(DEFAULT_REPO);
    }

    public <A extends MavenArtifactCoordinates & DiskResident> PublishedState check(A project) throws IOException, InterruptedException, URISyntaxException {
        return this.check(this.baseUrl, project);
    }

    public <A extends MavenArtifactCoordinates & DiskResident> PublishedState check(String urlBase, A project) throws IOException, InterruptedException, URISyntaxException {
        HttpRequest request = HttpRequest.newBuilder(this.downloadUrl(urlBase, project).toURI()).GET().timeout(Duration.ofSeconds(60L)).build();
        HttpResponse<String> response = PublishChecker.client().send(request, HttpResponse.BodyHandlers.ofString(StandardCharsets.UTF_8));
        switch (response.statusCode()) {
            case 404: 
            case 410: 
            case 500: {
                return PublishedState.NOT_PUBLISHED;
            }
        }
        if (response.statusCode() >= 200 && response.statusCode() < 299) {
            String remoteText;
            String localText = this.pomText(project);
            if (localText.equals(remoteText = response.body().trim())) {
                return PublishedState.PUBLISHED_IDENTICAL;
            }
            return PublishedState.PUBLISHED_DIFFERENT;
        }
        return PublishedState.NOT_PUBLISHED;
    }

    private <A extends MavenArtifactCoordinates & DiskResident> URL downloadUrl(String urlBase, A project) throws MalformedURLException {
        return new URL(urlBase + project.groupId().text().replace('.', '/') + "/" + project.artifactId() + "/" + project.version() + "/" + project.artifactId() + "-" + project.version() + ".pom");
    }

    private <A extends MavenArtifactCoordinates & DiskResident> String pomText(A project) throws IOException {
        return new String(Files.readAllBytes(((DiskResident)project).path()), StandardCharsets.UTF_8).trim();
    }
}

