/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.maven.model.resolver;

import com.mastfrog.function.optional.ThrowingOptional;
import com.mastfrog.function.threadlocal.ThreadLocalValue;
import com.telenav.cactus.maven.model.Pom;
import com.telenav.cactus.maven.model.resolver.ArtifactFinder;
import com.telenav.cactus.maven.model.resolver.PomResolver;
import com.telenav.cactus.maven.model.resolver.versions.VersionComparator;
import com.telenav.cactus.maven.model.resolver.versions.VersionMatchers;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class LocalRepoResolver
implements PomResolver {
    private static Path localRepo;
    private final ThreadLocalValue<ArtifactFinder> finder = ThreadLocalValue.create();
    static LocalRepoResolver INSTANCE;

    LocalRepoResolver() {
    }

    void withArtifactFinder(ArtifactFinder finder, Runnable run) {
        this.finder.withValue((Object)finder, run);
    }

    @Override
    public ThrowingOptional<Pom> get(String groupId, String artifactId, String version) {
        ArtifactFinder af;
        Supplier<ThrowingOptional> supp = () -> LocalRepoResolver.inLocalRepository(groupId, artifactId, version);
        ThrowingOptional result = supp.get();
        Optional finderOpt = this.finder.toOptional();
        if (!result.isPresent() && finderOpt.isPresent() && (af = (ArtifactFinder)finderOpt.get()).find(groupId, artifactId, version, "jar").isPresent()) {
            result = supp.get();
        }
        return result;
    }

    @Override
    public ThrowingOptional<Pom> get(String groupId, String artifactId) {
        return LocalRepoResolver.inLocalRepository(groupId, artifactId, (String ver) -> !ver.endsWith("-SNAPSHOT")).or(LocalRepoResolver.inLocalRepository(groupId, artifactId, (String ver) -> ver.endsWith("-SNAPSHOT")));
    }

    public String toString() {
        return "Local(" + LocalRepoResolver.localRepository() + ")";
    }

    private static Path localRepository() {
        localRepo = LocalRepoResolver.firstExisting(() -> localRepo, () -> {
            String propValue = System.getProperty("maven.local.repo");
            if (propValue != null) {
                Path result = Paths.get(propValue, new String[0]);
                return result;
            }
            return null;
        }, () -> {
            Pattern p;
            Matcher m;
            String opts = System.getenv("MAVEN_OPTS");
            if (opts != null && (m = (p = Pattern.compile("^.*?-Dmaven.repo.local=(\\S+).*")).matcher(opts)).find()) {
                Path result = Paths.get(m.group(1), new String[0]);
                return result;
            }
            return null;
        }, () -> {
            String home = System.getProperty("user.home");
            if (home != null) {
                return Paths.get(home, new String[0]).resolve(".m2").resolve("repository");
            }
            return null;
        }, () -> {
            String home = System.getenv("HOME");
            if (home != null) {
                return Paths.get(home, new String[0]).resolve(".m2").resolve("repository");
            }
            return null;
        });
        return localRepo;
    }

    private static ThrowingOptional<Pom> inLocalRepository(String groupId, String artifactId, String version) {
        ThrowingOptional<Pom> result;
        if (VersionMatchers.looksLikeRange(version) && (result = LocalRepoResolver.inLocalRepository(groupId, artifactId, VersionMatchers.matcher(version))).isPresent()) {
            return result;
        }
        return LocalRepoResolver.firstExistingPom(groupId, artifactId, version);
    }

    private static ThrowingOptional<Pom> firstExistingPom(String groupId, String artifactId, String version) {
        Path result = LocalRepoResolver.firstExisting(() -> LocalRepoResolver.localRepository().resolve(LocalRepoResolver.localRepositoryFolderPath(groupId, artifactId, version).resolve(LocalRepoResolver.pomName(artifactId, version))), () -> LocalRepoResolver.localRepository().resolve(LocalRepoResolver.altLocalRepositoryFolderPath(groupId, artifactId, version).resolve(LocalRepoResolver.pomName(artifactId, version))));
        if (result == null) {
            return LocalRepoResolver.inLocalRepository(groupId, artifactId, VersionMatchers.matcher(version));
        }
        return Pom.from(result);
    }

    private static ThrowingOptional<Pom> inLocalRepository(String groupId, String artifactId, Predicate<String> versionAccepter) {
        String[] names;
        Path par = LocalRepoResolver.localRepositoryParent(groupId, artifactId);
        if (!Files.exists(par, new LinkOption[0])) {
            par = LocalRepoResolver.altLocalRepositoryParent(groupId, artifactId);
        }
        if (!Files.exists(par, new LinkOption[0])) {
            return ThrowingOptional.empty();
        }
        LinkedList<String> result = new LinkedList<String>();
        for (String n : names = par.toFile().list()) {
            Path p;
            if (!versionAccepter.test(n) || !Files.exists(p = par.resolve(n).resolve(LocalRepoResolver.pomName(artifactId, n)), new LinkOption[0])) continue;
            result.add(n);
        }
        if (result.isEmpty()) {
            return ThrowingOptional.empty();
        }
        Collections.sort(result, VersionComparator.INSTANCE);
        String ver = (String)result.getLast();
        return LocalRepoResolver.inLocalRepository(groupId, artifactId, ver);
    }

    private static Path localRepositoryParent(String groupId, String artifactId) {
        return LocalRepoResolver.localRepository().resolve(LocalRepoResolver.pathify(groupId)).resolve(LocalRepoResolver.pathify(artifactId));
    }

    private static Path altLocalRepositoryParent(String groupId, String artifactId) {
        return LocalRepoResolver.localRepository().resolve(LocalRepoResolver.pathify(groupId)).resolve(LocalRepoResolver.pathify(artifactId));
    }

    private static Path pomName(String artifactId, String version) {
        return LocalRepoResolver.artifactName(artifactId, version, "pom");
    }

    private static Path artifactName(String artifactId, String version, String type) {
        return Paths.get(artifactId + "-" + version + "." + type, new String[0]);
    }

    private static Path localRepositoryFolderPath(String groupId, String artifactId, String version) {
        return LocalRepoResolver.pathify(groupId).resolve(LocalRepoResolver.pathify(artifactId)).resolve(version);
    }

    private static Path altLocalRepositoryFolderPath(String groupId, String artifactId, String version) {
        return LocalRepoResolver.pathify(groupId).resolve(artifactId).resolve(version);
    }

    private static String reducedVersion(String version) {
        int ix = version.lastIndexOf(46);
        if (ix > 0) {
            return version.substring(0, ix);
        }
        return version;
    }

    private static Path pathify(String mavenCoordinatesPart) {
        String[] parts = mavenCoordinatesPart.split("[\\./]");
        Path result = null;
        block3: for (int i = 0; i < parts.length; ++i) {
            switch (i) {
                case 0: {
                    result = Paths.get(parts[i], new String[0]);
                    continue block3;
                }
                default: {
                    result = result != null ? result.resolve(parts[i]) : Paths.get(parts[i], new String[0]);
                }
            }
        }
        return result;
    }

    @SafeVarargs
    private static Path firstExisting(Supplier<Path> ... suppliers) {
        HashSet<Path> seen = new HashSet<Path>();
        for (Supplier<Path> s : suppliers) {
            Path result = s.get();
            if (!seen.add(result) || result == null || !Files.exists(result, new LinkOption[0])) continue;
            return result;
        }
        return null;
    }

    static {
        INSTANCE = new LocalRepoResolver();
    }
}

