/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.maven.model.resolver;

import com.mastfrog.function.optional.ThrowingOptional;
import com.mastfrog.util.preconditions.Checks;
import com.telenav.cactus.maven.model.ArtifactId;
import com.telenav.cactus.maven.model.GroupId;
import com.telenav.cactus.maven.model.MavenIdentified;
import com.telenav.cactus.maven.model.MavenVersioned;
import com.telenav.cactus.maven.model.Pom;
import com.telenav.cactus.maven.model.PomVersion;
import com.telenav.cactus.maven.model.property.ParentsPropertyResolver;
import com.telenav.cactus.maven.model.property.PropertyResolver;
import com.telenav.cactus.maven.model.resolver.LocalRepoResolver;
import com.telenav.cactus.maven.model.resolver.MemoizingPomResolver;

public interface PomResolver {
    public static PomResolver local() {
        return LocalRepoResolver.INSTANCE;
    }

    default public PomResolver withLocalRepository() {
        return this.or(PomResolver.local());
    }

    default public PropertyResolver propertyResolver(Pom pom) {
        return new ParentsPropertyResolver(pom, this);
    }

    default public PomResolver memoizing() {
        return new MemoizingPomResolver(this);
    }

    default public <T extends MavenIdentified & MavenVersioned> ThrowingOptional<Pom> get(T obj) {
        ThrowingOptional<String> ver = ((MavenVersioned)((Object)((MavenIdentified)Checks.notNull((String)"obj", obj)))).resolvedVersion();
        if (ver.isPresent()) {
            return this.get(obj.groupId(), obj.artifactId(), ((MavenVersioned)obj).version());
        }
        return this.get(obj.groupId().text(), obj.artifactId().text());
    }

    default public ThrowingOptional<Pom> get(GroupId groupId, ArtifactId artifactId) {
        return this.get(((GroupId)Checks.notNull((String)"groupId", (Object)groupId)).text(), ((ArtifactId)Checks.notNull((String)"artifactId", (Object)artifactId)).text());
    }

    default public ThrowingOptional<Pom> get(ArtifactId artifact) {
        return ThrowingOptional.empty();
    }

    default public ThrowingOptional<Pom> get(GroupId groupId, ArtifactId artifactId, PomVersion version) {
        if (version.isPlaceholder()) {
            return this.get(groupId.text(), artifactId.text());
        }
        return this.get(groupId.text(), artifactId.text(), version.text());
    }

    default public ThrowingOptional<Pom> get(String groupId, String artifactId, String version) {
        return this.get(groupId, artifactId).flatMapThrowing(pom -> version.equals(pom.coordinates().version.text()) ? ThrowingOptional.of((Object)pom) : ThrowingOptional.empty());
    }

    public ThrowingOptional<Pom> get(String var1, String var2);

    default public PomResolver or(final PomResolver parent) {
        if (parent == this) {
            return this;
        }
        return new PomResolver(){

            @Override
            public ThrowingOptional<Pom> get(String groupId, String artifactId) {
                return PomResolver.this.get(groupId, artifactId).or(parent.get(groupId, artifactId));
            }

            @Override
            public ThrowingOptional<Pom> get(String groupId, String artifactId, String version) {
                return PomResolver.this.get(groupId, artifactId, version).or(parent.get(groupId, artifactId, version));
            }

            @Override
            public ThrowingOptional<Pom> get(ArtifactId artifact) {
                return PomResolver.this.get(artifact).orThrowing(() -> parent.get(artifact));
            }

            @Override
            public PomResolver or(PomResolver with) {
                if (with == this || with == parent || with == PomResolver.this) {
                    return this;
                }
                return PomResolver.super.or(with);
            }

            public String toString() {
                return PomResolver.this.toString() + " -> " + parent;
            }
        };
    }
}

