/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.maven.model.resolver;

import com.mastfrog.function.optional.ThrowingOptional;
import com.telenav.cactus.maven.model.ArtifactId;
import com.telenav.cactus.maven.model.Pom;
import com.telenav.cactus.maven.model.dependencies.Dependencies;
import com.telenav.cactus.maven.model.dependencies.DependencySet;
import com.telenav.cactus.maven.model.property.CoordinatesPropertyResolver;
import com.telenav.cactus.maven.model.property.PropertyResolver;
import com.telenav.cactus.maven.model.resolver.PomResolver;
import com.telenav.cactus.maven.model.resolver.versions.VersionMatchers;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class Poms
implements PomResolver,
Iterable<Pom> {
    private final List<Pom> sorted;
    private final Map<String, Map<String, Pom>> poms = new HashMap<String, Map<String, Pom>>();
    private final Map<Pom, DependencySet> dependenciesContext = new ConcurrentHashMap<Pom, DependencySet>();

    public Poms(Collection<? extends Pom> all) {
        this.sorted = new ArrayList<Pom>(all);
        Collections.sort(this.sorted);
        this.initLookup();
    }

    @Override
    public Iterator<Pom> iterator() {
        return Collections.unmodifiableList(this.sorted).iterator();
    }

    private void initLookup() {
        for (Pom pom : this.sorted) {
            Map kids = this.poms.computeIfAbsent(pom.coordinates().groupId().text(), gid -> new HashMap());
            kids.put(pom.coordinates().artifactId.text(), pom);
        }
    }

    public Poms reload() throws IOException {
        ArrayList nue = new ArrayList(this.sorted.size());
        for (Pom pom : this.sorted) {
            Pom.from(pom.path()).ifPresent(newPom -> nue.add(newPom));
        }
        this.sorted.clear();
        this.sorted.addAll(nue);
        this.initLookup();
        this.dependenciesContext.clear();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.sorted.forEach(pom -> sb.append(pom.coordinates()).append(", "));
        return sb.toString();
    }

    public Dependencies dependencies(Pom pom) {
        return new DependencySet(pom, this.withLocalRepository(), this.dependenciesContext);
    }

    public List<Pom> poms() {
        return Collections.unmodifiableList(this.sorted);
    }

    public List<Pom> javaProjects() {
        ArrayList<Pom> result = new ArrayList<Pom>();
        this.sorted.stream().filter(p -> !p.isPomProject()).forEach(result::add);
        return result;
    }

    @Override
    public PropertyResolver propertyResolver(Pom pom) {
        PomResolver pomRes = this.or(PomResolver.local());
        return pomRes.propertyResolver(pom).or(new CoordinatesPropertyResolver(pom, pomRes)).memoizing();
    }

    @Override
    public ThrowingOptional<Pom> get(String groupId, String artifactId, String version) {
        if ("---".equals(version)) {
            throw new IllegalStateException("Wrong get method " + groupId + ":" + artifactId + ":" + version + " should use the two-arg overload");
        }
        return this.get(groupId, artifactId).flatMap(pom -> pom.coordinates().version.is(version) ? Optional.of(pom) : Optional.empty()).or(() -> {
            Map<String, Pom> map = this.poms.get(groupId);
            if (map == null) {
                return Optional.empty();
            }
            Pom result = map.get(artifactId);
            if (result == null || !result.resolvedVersion().isPresent()) {
                return Optional.empty();
            }
            if (VersionMatchers.matcher(version).test((String)result.resolvedVersion().get())) {
                return Optional.of(result);
            }
            return Optional.empty();
        });
    }

    @Override
    public ThrowingOptional<Pom> get(String groupId, String artifactId) {
        Map<String, Pom> map = this.poms.get(groupId);
        if (map == null) {
            return ThrowingOptional.empty();
        }
        Pom result = map.get(artifactId);
        return ThrowingOptional.ofNullable((Object)result);
    }

    @Override
    public ThrowingOptional<Pom> get(ArtifactId artifact) {
        for (Pom pom : this.poms()) {
            if (!artifact.equals(pom.artifactId())) continue;
            return ThrowingOptional.of((Object)pom);
        }
        return ThrowingOptional.empty();
    }

    public static Poms in(Collection<? extends Path> paths) throws IOException {
        ArrayList list = new ArrayList();
        HashSet<Path> seen = new HashSet<Path>();
        for (Path path : paths) {
            Stream<Path> all = Files.walk(path, new FileVisitOption[0]).filter(file -> !Files.isDirectory(file, new LinkOption[0]) && "pom.xml".equals(file.getFileName().toString()));
            try {
                for (Path p : all.collect(Collectors.toCollection(ArrayList::new))) {
                    if (!seen.add(p)) continue;
                    Pom.from(p).ifPresent(list::add);
                }
            }
            finally {
                if (all == null) continue;
                all.close();
            }
        }
        if (list.isEmpty()) {
            throw new IOException("No poms in " + paths);
        }
        return new Poms(list);
    }

    public static Poms in(Path first, Path ... more) throws IOException {
        ArrayList<Path> paths = new ArrayList<Path>();
        paths.add(first);
        paths.addAll(Arrays.asList(more));
        return Poms.in(paths);
    }
}

