/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.maven.model.resolver.versions;

import com.telenav.cactus.maven.model.resolver.versions.ComparisonRelation;
import com.telenav.cactus.maven.model.resolver.versions.Term;
import com.telenav.cactus.maven.model.resolver.versions.VersionPredicate;
import java.util.Set;

final class Bound
implements VersionPredicate<String> {
    private final Term term;
    private final boolean isLower;
    private final boolean isUpper;
    private final boolean exclusiveLower;
    private final boolean exclusiveUpper;
    private final Set<ComparisonRelation> allowedRelations;

    Bound(Term value, boolean isLower, boolean isUpper, boolean exclusiveLower, boolean exclusiveUpper, Set<ComparisonRelation> allowedRelations) {
        this.term = value;
        this.isLower = isLower;
        this.isUpper = isUpper;
        this.exclusiveLower = exclusiveLower;
        this.exclusiveUpper = exclusiveUpper;
        this.allowedRelations = allowedRelations;
    }

    @Override
    public boolean isValid() {
        return this.term.isValid() && (this.isUpper || this.isLower) && !this.allowedRelations.isEmpty();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.isLower) {
            if (this.exclusiveLower) {
                sb.append('\u2913');
            } else {
                sb.append('\u2193');
            }
        }
        if (this.isUpper) {
            if (this.exclusiveUpper) {
                sb.append('\u2912');
            } else {
                sb.append('\u2191');
            }
        }
        ComparisonRelation.writeHumanReadable(this.allowedRelations, sb);
        sb.append(' ');
        sb.append(this.term);
        return sb.toString();
    }

    @Override
    public boolean test(String t) {
        if (t.isEmpty() || t.equals(this.term.toString()) && !this.allowedRelations.contains((Object)ComparisonRelation.EQUAL)) {
            return false;
        }
        ComparisonRelation rel = this.term.apply(t);
        boolean result = this.allowedRelations.contains((Object)rel);
        if (result && rel == ComparisonRelation.EQUAL) {
            if (this.isLower && this.exclusiveLower) {
                result = false;
            } else if (this.isUpper && this.exclusiveUpper) {
                result = false;
            }
        }
        return result;
    }
}

