/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.maven.model.resolver.versions;

import java.util.Set;

enum ComparisonRelation {
    BELOW,
    EQUAL,
    ABOVE;


    static void writeHumanReadable(Set<ComparisonRelation> relations, StringBuilder into) {
        if (relations.isEmpty()) {
            into.append("?");
            return;
        }
        if (relations.contains((Object)BELOW)) {
            into.append((Object)BELOW);
        }
        if (relations.contains((Object)ABOVE)) {
            into.append((Object)ABOVE);
        }
        if (relations.contains((Object)EQUAL)) {
            into.append((Object)EQUAL);
        }
    }

    public String toString() {
        switch (this) {
            case BELOW: {
                return "<";
            }
            case ABOVE: {
                return ">";
            }
            case EQUAL: {
                return "=";
            }
        }
        throw new AssertionError((Object)this);
    }

    static ComparisonRelation of(int comparisonValue) {
        switch (comparisonValue) {
            case 0: {
                return EQUAL;
            }
        }
        if (comparisonValue > 0) {
            return ABOVE;
        }
        return BELOW;
    }
}

