/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.maven.model.resolver.versions;

import com.telenav.cactus.maven.model.resolver.versions.Bound;
import com.telenav.cactus.maven.model.resolver.versions.ComparisonRelation;
import com.telenav.cactus.maven.model.resolver.versions.Term;
import com.telenav.cactus.maven.model.resolver.versions.VersionPredicate;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;

final class RangeBounds
implements VersionPredicate<String> {
    private final List<VersionPredicate<String>> constraints = new ArrayList<VersionPredicate<String>>();
    private boolean valid = true;
    private int targetMatchCount = 1;

    RangeBounds(String spec) {
        boolean exclusiveUpper;
        EnumSet<ComparisonRelation> allowedRelationsLower = EnumSet.noneOf(ComparisonRelation.class);
        EnumSet<ComparisonRelation> allowedRelationsUpper = EnumSet.noneOf(ComparisonRelation.class);
        String subspec = spec.substring(1, spec.length() - 1);
        String[] parts = RangeBounds.commaSplitWithBlanks(subspec);
        boolean exclusiveLower = spec.charAt(0) == '(';
        boolean bl = exclusiveUpper = spec.charAt(spec.length() - 1) == ')';
        if (!exclusiveLower) {
            allowedRelationsLower.add(ComparisonRelation.EQUAL);
        }
        if (!exclusiveUpper) {
            allowedRelationsUpper.add(ComparisonRelation.EQUAL);
        }
        ArrayList<String> stringValues = new ArrayList<String>();
        if (parts.length == 1) {
            if (!parts[0].isEmpty()) {
                allowedRelationsLower.add(ComparisonRelation.EQUAL);
                allowedRelationsUpper.add(ComparisonRelation.EQUAL);
                stringValues.add(parts[0]);
            }
        } else {
            if (parts[0].isEmpty()) {
                allowedRelationsLower.add(ComparisonRelation.BELOW);
            }
            if (parts[parts.length - 1].isEmpty()) {
                allowedRelationsUpper.add(ComparisonRelation.ABOVE);
            }
            for (String part : parts) {
                if (part.isEmpty()) continue;
                stringValues.add(part);
            }
        }
        switch (stringValues.size()) {
            case 0: {
                this.valid = false;
                break;
            }
            case 1: {
                if (allowedRelationsUpper.isEmpty()) {
                    allowedRelationsUpper.add(ComparisonRelation.BELOW);
                }
                if (allowedRelationsLower.isEmpty()) {
                    allowedRelationsLower.add(ComparisonRelation.ABOVE);
                }
                this.constraints.add(new Bound(new Term((String)stringValues.get(0)), true, false, exclusiveLower, exclusiveUpper, allowedRelationsLower));
                this.constraints.add(new Bound(new Term((String)stringValues.get(0)), false, true, exclusiveLower, exclusiveUpper, allowedRelationsUpper));
                this.valid = true;
                break;
            }
            default: {
                allowedRelationsLower.add(ComparisonRelation.ABOVE);
                allowedRelationsUpper.add(ComparisonRelation.BELOW);
                if (!allowedRelationsLower.contains((Object)ComparisonRelation.BELOW)) {
                    this.targetMatchCount = 2;
                }
                if (!allowedRelationsUpper.contains((Object)ComparisonRelation.ABOVE)) {
                    this.targetMatchCount = 2;
                }
                this.constraints.add(new Bound(new Term((String)stringValues.get(0)), true, false, exclusiveLower, exclusiveUpper, allowedRelationsLower));
                this.constraints.add(new Bound(new Term((String)stringValues.get(stringValues.size() - 1)), false, true, exclusiveLower, exclusiveUpper, allowedRelationsUpper));
                this.valid &= stringValues.size() == 2;
            }
        }
        if (parts.length >= 3) {
            this.valid = false;
        }
    }

    static String[] commaSplitWithBlanks(String s) {
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder curr = new StringBuilder();
        block3: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case ',': {
                    result.add(curr.toString());
                    curr.setLength(0);
                    if (i != s.length() - 1) continue block3;
                    result.add("");
                    continue block3;
                }
                default: {
                    curr.append(c);
                    if (i != s.length() - 1) continue block3;
                    result.add(curr.toString());
                }
            }
        }
        return (String[])result.toArray(String[]::new);
    }

    @Override
    public boolean isValid() {
        boolean result = this.valid;
        if (result) {
            for (VersionPredicate<String> b : this.constraints) {
                if (b.isValid()) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!this.valid) {
            sb.append('!');
        }
        Iterator<VersionPredicate<String>> it = this.constraints.iterator();
        while (it.hasNext()) {
            sb.append(it.next());
            if (!it.hasNext()) continue;
            sb.append(" / ");
        }
        return sb.toString();
    }

    @Override
    public boolean test(String encounteredVersion) {
        int count = 0;
        for (Predicate predicate : this.constraints) {
            boolean success = predicate.test(encounteredVersion);
            if (!success) continue;
            ++count;
        }
        return count == this.targetMatchCount;
    }
}

