/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.maven.model.resolver.versions;

import com.telenav.cactus.maven.model.resolver.versions.RangeBounds;
import com.telenav.cactus.maven.model.resolver.versions.VersionPredicate;
import java.util.Iterator;
import java.util.List;

final class RangeBoundsSet
implements VersionPredicate<String> {
    private final List<RangeBounds> terms;
    private final boolean valid;
    private final String original;

    RangeBoundsSet(List<RangeBounds> terms, boolean valid, String original) {
        this.terms = terms;
        this.valid = valid;
        this.original = original;
    }

    @Override
    public boolean isValid() {
        boolean result = this.valid;
        if (result) {
            for (RangeBounds rb : this.terms) {
                if (rb.isValid()) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    @Override
    public boolean test(String encounteredVersion) {
        for (RangeBounds t : this.terms) {
            if (!t.test(encounteredVersion)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.original).append(" -> {");
        Iterator<RangeBounds> it = this.terms.iterator();
        while (it.hasNext()) {
            sb.append(it.next());
            if (!it.hasNext()) continue;
            sb.append(" / ");
        }
        return sb.append('}').toString();
    }
}

