/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.maven;

import com.mastfrog.function.throwing.io.IOSupplier;
import com.mastfrog.util.preconditions.Checks;
import com.telenav.cactus.git.Branches;
import com.telenav.cactus.git.GitCheckout;
import com.telenav.cactus.github.MinimalPRItem;
import com.telenav.cactus.maven.log.BuildLog;
import com.telenav.cactus.maven.mojobase.ScopedCheckoutsMojo;
import com.telenav.cactus.maven.tree.ProjectTree;
import com.telenav.cactus.maven.trigger.RunPolicy;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

abstract class AbstractGithubMojo
extends ScopedCheckoutsMojo
implements IOSupplier<String> {
    public static final String GITHUB_CLI_PAT_ENV_VAR = "CACTUS_GITHUB_PERSONAL_ACCESS_TOKEN";
    public static final String GITHUB_CLI_PAT_FILE_ENV_VAR = "CACTUS_GITHUB_PERSONAL_ACCESS_TOKEN_FILE";
    @Parameter(property="cactus.github-personal-access-token", required=false)
    private String authenticationToken;
    private final Map<PullRequestListCacheKey, List<MinimalPRItem>> prListCache = new ConcurrentHashMap<PullRequestListCacheKey, List<MinimalPRItem>>();

    protected AbstractGithubMojo() {
    }

    protected AbstractGithubMojo(boolean runFirst) {
        super(runFirst);
    }

    protected AbstractGithubMojo(RunPolicy policy) {
        super(policy);
    }

    @Override
    protected final void onValidateParameters(BuildLog log, MavenProject project) throws Exception {
        if (this.authenticationToken == null || this.authenticationToken.isBlank()) {
            String result = System.getenv(GITHUB_CLI_PAT_ENV_VAR);
            if (result == null) {
                result = System.getenv(GITHUB_CLI_PAT_FILE_ENV_VAR);
            }
            if (result == null) {
                log.warn("-Dcactus.github-personal-access-token not passed, and neither CACTUS_GITHUB_PERSONAL_ACCESS_TOKEN nor CACTUS_GITHUB_PERSONAL_ACCESS_TOKEN_FILE are set in the environment.  If github calls need authentication, they will fail.");
            }
        }
        this.onValidateGithubParameters(log, project);
    }

    protected void onValidateGithubParameters(BuildLog log, MavenProject project) throws Exception {
    }

    public final String get() throws IOException {
        if (this.authenticationToken == null || this.authenticationToken.isBlank()) {
            return this.getTokenFromEnvironment();
        }
        return this.authenticationToken;
    }

    private String getTokenFromEnvironment() throws IOException {
        String result = System.getenv(GITHUB_CLI_PAT_ENV_VAR);
        if (result == null) {
            String filePath = System.getenv(GITHUB_CLI_PAT_FILE_ENV_VAR);
            if (filePath != null) {
                Path file = Paths.get(filePath.trim(), new String[0]);
                if (Files.exists(file, new LinkOption[0])) {
                    return Files.readString(file, StandardCharsets.UTF_8).trim();
                }
                throw new IOException("CACTUS_GITHUB_PERSONAL_ACCESS_TOKEN_FILE is set to " + filePath + " but it does not exist.");
            }
        } else {
            result = result.trim();
        }
        return result;
    }

    protected final List<MinimalPRItem> pullRequestsForBranch(String baseBranch, String branchName, GitCheckout forCheckout) {
        PullRequestListCacheKey cacheKey = new PullRequestListCacheKey(baseBranch, forCheckout, branchName);
        ArrayList<MinimalPRItem> result = new ArrayList<MinimalPRItem>(this.prListCache.computeIfAbsent(cacheKey, k -> forCheckout.listPullRequests((IOSupplier)this, baseBranch, null)));
        Iterator it = result.iterator();
        while (it.hasNext()) {
            MinimalPRItem pr = (MinimalPRItem)it.next();
            if (pr.headRefName.equals(branchName) || pr.headRefName.contains(branchName)) continue;
            it.remove();
        }
        return result;
    }

    protected final void clearPRCache() {
        this.prListCache.clear();
    }

    protected final List<MinimalPRItem> openAndMergeablePullRequestsForBranch(String baseBranch, String branchName, GitCheckout forCheckout) {
        return this.filterNonOpenOrNotMergeable(this.log(), forCheckout, this.pullRequestsForBranch(baseBranch, branchName, forCheckout));
    }

    protected final List<MinimalPRItem> openPullRequestsForBranch(String baseBranch, String branchName, GitCheckout forCheckout) {
        return this.filterNonOpen(this.log(), forCheckout, this.pullRequestsForBranch(baseBranch, branchName, forCheckout));
    }

    protected final Optional<MinimalPRItem> leadPullRequestForBranch(String baseBranch, String branchName, GitCheckout forCheckout) {
        List<MinimalPRItem> items = this.openAndMergeablePullRequestsForBranch(baseBranch, branchName, forCheckout);
        switch (items.size()) {
            case 0: {
                return Optional.empty();
            }
            case 1: {
                return Optional.of(items.get(0));
            }
        }
        return (Optional)this.fail("Ambiguous PRs - more than one PR on " + branchName + " in " + forCheckout.loggingName() + ": " + items);
    }

    private List<MinimalPRItem> filterNonOpenOrNotMergeable(BuildLog log, GitCheckout in, List<MinimalPRItem> items) {
        Iterator<MinimalPRItem> it = items.iterator();
        while (it.hasNext()) {
            MinimalPRItem i = it.next();
            if (i.isOpen() && i.isMergeable()) continue;
            log.warn("Filter closed or not-mergeable from candidates for " + in.loggingName() + ": " + i);
            it.remove();
        }
        return items;
    }

    private List<MinimalPRItem> filterNonOpen(BuildLog log, GitCheckout in, List<MinimalPRItem> items) {
        Iterator<MinimalPRItem> it = items.iterator();
        while (it.hasNext()) {
            MinimalPRItem i = it.next();
            if (i.isOpen()) continue;
            log.warn("Filter closed or not-mergeable from candidates for " + in.loggingName() + ": " + i);
            it.remove();
        }
        return items;
    }

    protected final Map<GitCheckout, Branches.Branch> prBranchesFor(GitCheckout myCheckout, Collection<? extends GitCheckout> checkouts, ProjectTree tree, String targetBranch) {
        TreeMap<GitCheckout, Branches.Branch> result = new TreeMap<GitCheckout, Branches.Branch>();
        checkouts.forEach(checkout -> this.prBranchFor(this.log(), myCheckout, (GitCheckout)checkout, tree, targetBranch, false).ifPresent(branch -> result.put((GitCheckout)checkout, (Branches.Branch)branch)));
        return result;
    }

    protected final Optional<Branches.Branch> prBranchFor(BuildLog log, GitCheckout myCheckout, GitCheckout targetCheckout, ProjectTree tree, String targetBranch, boolean failOnDetachedHead) {
        String msg;
        Branches branches = tree.branches(targetCheckout);
        if (targetBranch != null) {
            return branches.currentBranch().flatMap(br -> {
                if (targetBranch.equals(br.name())) {
                    return Optional.of(br);
                }
                return Optional.empty();
            });
        }
        Branches targetProjectBranches = tree.branches(myCheckout);
        Optional targetProjectsBranch = targetProjectBranches.currentBranch();
        if (targetProjectsBranch.isEmpty()) {
            msg = "Target project " + this.coordinatesOf(this.project()) + " in " + this.project().getBasedir() + " is not on a branch.  It needs to be to match same-named branches in other checkouts to decide what to create the pull request from.";
            if (!failOnDetachedHead) {
                log.warn(msg);
                return Optional.empty();
            }
        } else {
            Optional current = branches.currentBranch();
            if (current.isEmpty()) {
                log.warn("Ignoring " + targetCheckout.loggingName() + " for pull request - it is not on any branch.");
                return current;
            }
            if (!((Branches.Branch)current.get()).name().equals(((Branches.Branch)targetProjectsBranch.get()).name())) {
                log.info("Ignoring matched checkout " + targetCheckout.loggingName() + " for pull request - because we are matching the branch " + ((Branches.Branch)targetProjectsBranch.get()).name() + " but it is on the branch " + ((Branches.Branch)current.get()).name());
                return Optional.empty();
            }
            log.info("Will include " + targetCheckout.loggingName() + " in the pull request set, on branch " + ((Branches.Branch)targetProjectsBranch.get()).name());
            return current;
        }
        this.fail(msg);
        return Optional.empty();
    }

    protected static Map<GitCheckout, Branches.Branch> checkoutsThatHaveBranch(GitCheckout myCheckout, String targetBranch, Collection<? extends GitCheckout> of, BuildLog log, ProjectTree tree) throws MojoFailureException {
        TreeMap<GitCheckout, Branches.Branch> result = new TreeMap<GitCheckout, Branches.Branch>();
        String branchName = targetBranch == null ? (String)myCheckout.branch().orElseThrow(() -> new MojoFailureException("No current branch for " + myCheckout.loggingName())) : targetBranch;
        of.forEach(checkout -> tree.branches((GitCheckout)checkout).find(branchName).ifPresent(branch -> result.put((GitCheckout)checkout, (Branches.Branch)branch)));
        return result;
    }

    private static final class PullRequestListCacheKey {
        private final Path checkoutPath;
        private final String baseBranch;

        private PullRequestListCacheKey(String baseBranch, GitCheckout checkout, String branchName) {
            this.checkoutPath = ((GitCheckout)Checks.notNull((String)"checkout", (Object)checkout)).checkoutRoot();
            this.baseBranch = baseBranch;
        }

        public int hashCode() {
            return this.checkoutPath.hashCode() + 263 * Objects.hashCode(this.baseBranch);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null || o.getClass() != PullRequestListCacheKey.class) {
                return false;
            }
            PullRequestListCacheKey key = (PullRequestListCacheKey)o;
            return key.checkoutPath.toAbsolutePath().equals(this.checkoutPath.toAbsolutePath()) && Objects.equals(this.baseBranch, key.baseBranch);
        }

        public String toString() {
            return this.checkoutPath.getFileName() + ":" + (this.baseBranch == null ? "<any>" : this.baseBranch);
        }
    }
}

