/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.maven;

import com.telenav.cactus.git.Branches;
import com.telenav.cactus.git.GitCheckout;
import com.telenav.cactus.maven.log.BuildLog;
import com.telenav.cactus.maven.mojobase.AutomergeTag;
import com.telenav.cactus.maven.mojobase.BaseMojoGoal;
import com.telenav.cactus.maven.mojobase.ScopedCheckoutsMojo;
import com.telenav.cactus.maven.tree.ProjectTree;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.maven.plugins.annotations.InstantiationStrategy;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@BaseMojoGoal(value="automerge-tag")
@Mojo(defaultPhase=LifecyclePhase.VALIDATE, requiresDependencyResolution=ResolutionScope.NONE, instantiationStrategy=InstantiationStrategy.SINGLETON, name="automerge-tag", threadSafe=true)
public class AutomergeTagMojo
extends ScopedCheckoutsMojo {
    @Parameter(property="cactus.stable-branch", defaultValue="stable")
    private String stableBranch;
    @Parameter(property="cactus.target-branch", required=false)
    private String targetBranch;
    @Parameter(property="cactus.push", defaultValue="true", required=false)
    private boolean push;

    @Override
    protected void execute(BuildLog log, MavenProject project, GitCheckout myCheckout, ProjectTree tree, List<GitCheckout> checkouts) throws Exception {
        String targetBranch;
        Set<GitCheckout> needingTag;
        StringBuilder notOnBranchCheckouts = new StringBuilder();
        checkouts.forEach(checkout -> {
            Branches branches = tree.branches((GitCheckout)checkout);
            if (!branches.currentBranch().isPresent()) {
                if (notOnBranchCheckouts.length() > 0) {
                    notOnBranchCheckouts.append(", ");
                }
                notOnBranchCheckouts.append(checkout.loggingName());
            }
        });
        if (notOnBranchCheckouts.length() > 0) {
            notOnBranchCheckouts.insert(0, "Some targeted checkouts are not on a branch: ");
            this.fail(notOnBranchCheckouts);
        }
        if ((needingTag = AutomergeTagMojo.filterCheckoutsWithCommitNotOnBranch(targetBranch = this.targetBranch(myCheckout, tree), this.stableBranch, tree, log, this.isPretend(), checkouts)).isEmpty()) {
            log.warn("No checkouts on the branch " + targetBranch + " have commits not already in the remote of branch " + this.stableBranch);
            return;
        }
        AutomergeTagMojo.applyAutomergeTag(this.automergeTag(), this.isPretend(), log, needingTag, this.push);
    }

    String targetBranch(GitCheckout myCheckout, ProjectTree tree) {
        if (this.targetBranch != null) {
            return this.targetBranch;
        }
        String result = ((Branches.Branch)tree.branches(myCheckout).currentBranch().get()).name();
        if ("develop".equals(result) || this.stableBranch.equals(result)) {
            this.fail("The target branch may not be the stable or develop branches");
        }
        return result;
    }

    static void applyAutomergeTag(AutomergeTag tag, boolean pretend, BuildLog log, Collection<? extends GitCheckout> checkouts, boolean push) {
        for (GitCheckout gitCheckout : checkouts) {
            log.info("Tag " + gitCheckout.loggingName() + " with " + tag);
            if (pretend) continue;
            gitCheckout.tag(tag.toString(), false);
        }
        if (push) {
            for (GitCheckout gitCheckout : checkouts) {
                boolean result;
                log.info("Push tag " + tag + " to " + gitCheckout.loggingName());
                if (pretend || (result = gitCheckout.pushTag(tag.toString()))) continue;
                log.warn("Could not push tag " + tag + " to " + gitCheckout.loggingName() + ".  Does it have a remote?");
            }
        }
    }

    static Set<GitCheckout> automergeTag(String branchNameOrNull, String stableBranch, ProjectTree tree, BuildLog log, boolean pretend, Collection<? extends GitCheckout> potentialCheckouts, boolean push, Supplier<AutomergeTag> tagSupplier) {
        Set<GitCheckout> result = AutomergeTagMojo.filterCheckoutsWithCommitNotOnBranch(branchNameOrNull, stableBranch, tree, log, pretend, potentialCheckouts);
        if (!result.isEmpty()) {
            AutomergeTag tag = tagSupplier.get();
            AutomergeTagMojo.applyAutomergeTag(tag, pretend, log, result, push);
        }
        return result;
    }

    static Set<GitCheckout> filterCheckoutsWithCommitNotOnBranch(String branchName, String stableBranch, ProjectTree tree, BuildLog log, boolean pretend, Collection<? extends GitCheckout> checkouts) {
        LinkedHashSet<GitCheckout> result = new LinkedHashSet<GitCheckout>();
        checkouts.forEach(checkout -> {
            log.info("Fetch all for " + checkout.loggingName());
            if (!pretend) {
                checkout.updateRemoteHeads();
                checkout.fetchAll();
                tree.invalidateBranches((GitCheckout)checkout);
            }
        });
        checkouts.forEach(checkout -> {
            Branches branches = tree.branches((GitCheckout)checkout);
            Optional remoteBranch = branches.find(stableBranch, false);
            if (!remoteBranch.isPresent()) {
                log.info("Checkout " + checkout.loggingName() + " does not have a branch named " + stableBranch + ". Skipping.");
                return;
            }
            Branches.Branch curr = (Branches.Branch)branches.currentBranch().get();
            String currentBranchName = curr.name();
            if (stableBranch.equals(currentBranchName)) {
                log.info(checkout.loggingName() + " is on the " + stableBranch + " branch - will not tag commits on the stable destination branch.");
                return;
            }
            String targetBranchName = branchName;
            if (targetBranchName == null) {
                targetBranchName = currentBranchName;
            }
            if (currentBranchName.equals(targetBranchName)) {
                String head = checkout.head();
                if (!pretend) {
                    checkout.updateRemoteHeads();
                    checkout.fetchAll();
                }
                String stableHead = checkout.headOf(stableBranch);
                if (remoteBranch.isPresent() && (head.equals(stableHead) || checkout.isAncestor(head, stableHead))) {
                    log.info("Skip automerge tag for branch " + targetBranchName + " of " + checkout.loggingName() + " - the remote of " + stableBranch + " already contains all of its commits.");
                    return;
                }
                result.add((GitCheckout)checkout);
            }
        });
        return result;
    }
}

