/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.maven;

import com.telenav.cactus.cli.ProcessFailedException;
import com.telenav.cactus.git.Branches;
import com.telenav.cactus.git.GitCheckout;
import com.telenav.cactus.git.GitRemotes;
import com.telenav.cactus.maven.log.BuildLog;
import com.telenav.cactus.maven.mojobase.BaseMojoGoal;
import com.telenav.cactus.maven.mojobase.ScopedCheckoutsMojo;
import com.telenav.cactus.maven.tree.ProjectTree;
import com.telenav.cactus.tasks.TaskSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.CompletionException;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.apache.maven.plugins.annotations.InstantiationStrategy;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@BaseMojoGoal(value="remote-branch-cleanup")
@Mojo(defaultPhase=LifecyclePhase.VALIDATE, requiresDependencyResolution=ResolutionScope.NONE, instantiationStrategy=InstantiationStrategy.SINGLETON, name="remote-branch-cleanup", threadSafe=true)
public class BranchCleanupMojo
extends ScopedCheckoutsMojo {
    private static final Set<String> ALWAYS_PROTECTED = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("master", "develop", "stable", "release/current", "publish")));
    @Parameter(property="cactus.protected-branches", required=false)
    private String protectedBranches;
    @Parameter(property="cactus.protected-branch-patterns", required=false)
    private List<String> protectedPatterns;
    @Parameter(property="cactus.safe-branches", defaultValue="develop,release/current,publish")
    private String safeBranches;
    @Parameter(property="cactus.safe-branch-patterns", defaultValue="develop,release/current,publish")
    private List<String> safePatterns;
    @Parameter(property="cactus.i-understand-the-risks")
    private boolean acknowledged;
    @Parameter(property="cactus.cleanup-remote", defaultValue="true")
    private boolean cleanupRemote;
    @Parameter(property="cactus.cleanup-local", defaultValue="true")
    private boolean cleanupLocal;

    @Override
    protected void onValidateParameters(BuildLog log, MavenProject project) throws Exception {
        Set<String> safe = this.safeBranches();
        if (safe.isEmpty()) {
            this.fail("Will not delete all remote branches");
        }
        safe.forEach(branch -> this.validateBranchName((String)branch, false));
        if (!this.cleanupRemote && !this.cleanupLocal) {
            log.warn("Both cactus.cleanup-remote and cactus.cleanup-local are false.  Nothing will be done.");
        }
        this.protectedPatterns();
        this.safePatterns();
    }

    @Override
    protected void execute(BuildLog log, MavenProject project, GitCheckout myCheckout, ProjectTree tree, List<GitCheckout> checkouts) throws Exception {
        if (!this.acknowledged) {
            log.warn("cactus.i-understand-the-risks not set - running in pretend-mode. No branches will actually be deleted");
        }
        TaskSet remoteTasks = TaskSet.newTaskSet((Consumer)log);
        Predicate<String> protectedBranchFilter = this.protectedBranchFilter();
        Predicate<String> safeBranchFilter = this.safeBranchFilter();
        log.debug(protectedBranchFilter::toString);
        log.debug(safeBranchFilter::toString);
        if (this.cleanupRemote) {
            this.collectRemoteBranchesForCleanup(checkouts, protectedBranchFilter, safeBranchFilter, tree, log, remoteTasks);
        }
        boolean hadTasks = !remoteTasks.isEmpty();
        remoteTasks.execute();
        if (hadTasks && this.acknowledged && !this.isPretend()) {
            for (GitCheckout checkout : checkouts) {
                log.info("Refresh remote branches after making changes for " + checkout.loggingName());
                tree.invalidateBranches(checkout);
                checkout.updateRemoteHeads();
                checkout.fetchPruningDefunctLocalRecordsOfRemoteBranches();
            }
        }
        TaskSet localTasks = TaskSet.newTaskSet((Consumer)log);
        if (this.cleanupLocal) {
            this.collectLocalBranchesForCleanup(checkouts, protectedBranchFilter, safeBranchFilter, tree, log, localTasks);
        }
        boolean bl = !localTasks.isEmpty();
        localTasks.execute();
        if (!(hadTasks |= bl)) {
            log.info("Nothing to do");
        } else {
            tree.invalidateCache();
        }
    }

    public void collectRemoteBranchesForCleanup(List<GitCheckout> checkouts, Predicate<String> protectedBranchFilter, Predicate<String> safeBranchNames, ProjectTree tree, BuildLog log1, TaskSet tasks) {
        this.collectRemoteBranches(checkouts, protectedBranchFilter, safeBranchNames, tree, candidates -> {
            if (candidates.isEmpty()) {
                log1.info("No branches needing cleanup.");
                return;
            }
            Set<CheckoutAndHead> operateOn = this.filterToBranchesAlreadyMergedToSafeBranches((Map<String, Set<CheckoutAndHead>>)candidates, safeBranchNames, tree, log1);
            if (operateOn.isEmpty()) {
                log1.info("All candidates contain commits not on a safe branch.");
                return;
            }
            ArrayList<CheckoutAndHead> sorted = new ArrayList<CheckoutAndHead>(operateOn);
            Collections.sort(sorted);
            sorted.forEach(candidate -> tasks.add("Delete " + candidate, () -> {
                if (this.acknowledged) {
                    this.ifNotPretending(() -> candidate.deleteBranch(tree, log1));
                }
            }));
        });
    }

    public void collectLocalBranchesForCleanup(List<GitCheckout> checkouts, Predicate<String> protectedBranchFilter, Predicate<String> safeBranchNames, ProjectTree tree, BuildLog log, TaskSet tasks) {
        this.collectLocalBranches(checkouts, protectedBranchFilter, safeBranchNames, tree, localBranches -> localBranches.forEach((branch, candidates) -> candidates.forEach(checkoutAndHead -> {
            boolean canDelete;
            Branches branches = tree.branches(checkoutAndHead.checkout);
            Optional opt = branches.currentBranch();
            if (!opt.isPresent()) {
                canDelete = true;
            } else {
                boolean bl = canDelete = !((Branches.Branch)opt.get()).name().equals(checkoutAndHead.branch.name());
                if (!canDelete) {
                    log.info("Will not delete local branch " + checkoutAndHead + " because it is the current branch in the working tree.");
                }
            }
            if (canDelete) {
                log.info("Will delete local branch " + checkoutAndHead.branch.name() + " in " + checkoutAndHead.checkout.loggingName());
                tasks.add("Delete local branch " + checkoutAndHead.branch.name() + " in " + checkoutAndHead.checkout.loggingName(), () -> {
                    try {
                        this.ifNotPretending(() -> checkoutAndHead.checkout.deleteBranch(checkoutAndHead.branch.name(), null, false));
                    }
                    catch (ProcessFailedException | CompletionException ex) {
                        log.error("Failed to delete " + checkoutAndHead + ": " + ex.getMessage());
                    }
                });
            }
        })));
    }

    private Set<CheckoutAndHead> filterToBranchesAlreadyMergedToSafeBranches(Map<String, Set<CheckoutAndHead>> candidates, Predicate<String> safeBranchNames, ProjectTree tree, BuildLog log) {
        HashSet<CheckoutAndHead> result = new HashSet<CheckoutAndHead>();
        HashSet unclean = new HashSet();
        candidates.forEach((branchName, targets) -> {
            if (!unclean.contains(branchName)) {
                targets.forEach(checkoutAndBranch -> {
                    Branches containingCommit = checkoutAndBranch.branchesContainingHead();
                    boolean added = false;
                    for (Branches.Branch remoteBranch : containingCommit.remoteBranches()) {
                        if (remoteBranch.isLocal() || remoteBranch.isSameName(checkoutAndBranch.branch) || !safeBranchNames.test(remoteBranch.name())) continue;
                        log.debug(() -> "Head " + checkoutAndBranch.head + " of " + checkoutAndBranch + " is included in the safe branch " + remoteBranch + " so it is safe to delete.");
                        result.add((CheckoutAndHead)checkoutAndBranch);
                        added = true;
                        break;
                    }
                    if (!added) {
                        log.info("Will not delete branch '" + checkoutAndBranch.branch.trackingName() + "' in " + checkoutAndBranch.checkout.loggingName() + " because no safe branch contains its head commit.");
                        unclean.add(branchName);
                    }
                });
            } else {
                log.info("Will not delete branch '" + branchName + "' because another checkout in the tree of a branch with the same name has unpushed commits");
            }
        });
        Iterator it = result.iterator();
        while (it.hasNext()) {
            CheckoutAndHead ch = (CheckoutAndHead)it.next();
            if (unclean.contains(ch.branch.name())) {
                log.debug(() -> "Prune " + ch + " from deletions because some checkout has unmerged chanegs on it");
                it.remove();
            }
            if (ch.isFromDefaultRemote()) continue;
            log.info("Skipping " + ch + " - it is not from the default remote");
            it.remove();
        }
        return result;
    }

    void collectRemoteBranches(Collection<? extends GitCheckout> checkouts, Predicate<String> protectedBranchFilter, Predicate<String> safeBranchNames, ProjectTree tree, Consumer<Map<String, Set<CheckoutAndHead>>> c) {
        TreeMap result = new TreeMap();
        checkouts.forEach(checkout -> this.scanForBranches((GitCheckout)checkout, result, safeBranchNames, tree, protectedBranchFilter));
        c.accept(result);
    }

    void collectLocalBranches(Collection<? extends GitCheckout> checkouts, Predicate<String> protectedBranchFilter, Predicate<String> safeBranchNames, ProjectTree tree, Consumer<Map<String, Set<CheckoutAndHead>>> c) {
        TreeMap result = new TreeMap();
        checkouts.forEach(checkout -> this.scanForLocalBranches((GitCheckout)checkout, result, safeBranchNames, tree, protectedBranchFilter));
        c.accept(result);
    }

    private void scanForLocalBranches(GitCheckout checkout, Map<String, Set<CheckoutAndHead>> candidateBranches, Predicate<String> safeBranches, ProjectTree tree, Predicate<String> protectedBranchFilter) {
        Branches branches = tree.branches(checkout);
        branches.localBranches().forEach(branch -> {
            String head;
            if (safeBranches.test(branch.name()) || protectedBranchFilter.test(branch.name())) {
                return;
            }
            if (!branches.hasRemoteForLocalOrLocalForRemote(branch) && (head = checkout.headOf(branch.name())) != null) {
                Branches containing = checkout.branchesContainingCommit(head);
                for (Branches.Branch remote : containing.remoteBranches()) {
                    if (!safeBranches.test(remote.name())) continue;
                    candidateBranches.computeIfAbsent(branch.name(), br -> new TreeSet()).add(new CheckoutAndHead(checkout, head, (Branches.Branch)branch));
                    break;
                }
            }
        });
    }

    private void scanForBranches(GitCheckout checkout, Map<String, Set<CheckoutAndHead>> candidateBranches, Predicate<String> safeBranches, ProjectTree tree, Predicate<String> protectedBranchFilter) {
        this.log.info("Scan " + checkout.loggingName());
        this.ifNotPretending(() -> {
            checkout.updateRemoteHeads();
            checkout.fetchPruningDefunctLocalRecordsOfRemoteBranches();
            tree.invalidateBranches(checkout);
        });
        Branches branches = tree.branches(checkout);
        Set remotes = branches.remoteBranches();
        for (Branches.Branch branch : remotes) {
            String head;
            if (safeBranches.test(branch.name()) || protectedBranchFilter.test(branch.name()) || (head = checkout.headOf(branch.trackingName())) == null) continue;
            candidateBranches.computeIfAbsent(branch.name(), nm -> new HashSet()).add(new CheckoutAndHead(checkout, head, branch));
        }
    }

    private Set<String> protectedBranches() {
        HashSet<String> result = new HashSet<String>(ALWAYS_PROTECTED);
        if (this.protectedBranches != null) {
            for (String s : this.protectedBranches.split(",")) {
                s = s.trim();
                result.add(s);
            }
        }
        return result;
    }

    private Predicate<String> safeBranchFilter() {
        return BranchCleanupMojo.predicate("safe", this.safeBranches(), this.safePatterns());
    }

    private Set<String> safeBranches() {
        HashSet<String> all = new HashSet<String>();
        for (String s : this.safeBranches.split(",")) {
            all.add(s.trim());
        }
        return all;
    }

    private Predicate<String> protectedBranchFilter() {
        return BranchCleanupMojo.predicate("protected", this.protectedBranches(), this.protectedPatterns());
    }

    private Set<Pattern> protectedPatterns() {
        HashSet<Pattern> result = new HashSet<Pattern>(this.patterns(this.protectedPatterns));
        result.add(Pattern.compile("^v?\\d+\\.\\d+\\[.$]?.*"));
        result.add(Pattern.compile("^release/*"));
        return result;
    }

    private Set<Pattern> safePatterns() {
        return this.patterns(this.safePatterns);
    }

    private Set<Pattern> patterns(Collection<? extends String> patterns) {
        if (patterns == null || patterns.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<Pattern> result = new HashSet<Pattern>();
        for (String pat : this.protectedPatterns) {
            if (pat.isBlank()) continue;
            try {
                result.add(Pattern.compile(pat));
            }
            catch (Exception ex) {
                this.fail("Invalid regular expression '" + pat + "'");
            }
        }
        return result;
    }

    static Predicate<String> predicate(String name, Collection<? extends String> exactMatches, Collection<? extends Pattern> patterns) {
        return new ExactAndPatternPredicate(name, exactMatches, patterns);
    }

    class CheckoutAndHead
    implements Comparable<CheckoutAndHead> {
        private final GitCheckout checkout;
        private final String head;
        private final Branches.Branch branch;

        CheckoutAndHead(GitCheckout checkout, String head, Branches.Branch branch) {
            this.checkout = checkout;
            this.head = head;
            this.branch = branch;
        }

        public void deleteBranch(ProjectTree tree, BuildLog log) {
            boolean deleted;
            boolean failed = false;
            try {
                deleted = this.checkout.deleteRemoteBranch(((GitRemotes)this.checkout.defaultRemote().get()).name(), this.branch.name());
            }
            catch (ProcessFailedException | CompletionException failure) {
                if (failure.getMessage() != null && failure.getMessage().contains("remote ref does not exist")) {
                    log.info("Remote branch " + this.branch + " was already deleted on the server.");
                    deleted = false;
                    failed = true;
                }
                throw failure;
            }
            if (!deleted) {
                if (!failed) {
                    log.info("Failed to delete " + this + ". Skipping.");
                }
                return;
            }
            log.info("Deleted " + this);
            BranchCleanupMojo.this.emitMessage("Deleted " + this);
            Branches branches = tree.branches(this.checkout);
            branches.opposite(this.branch).ifPresent(localBranch -> {
                boolean deletedLocal;
                Optional workingTreeBranch = branches.currentBranch();
                boolean canDeleteLocalBranch = workingTreeBranch.isPresent() ? !this.branch.isSameName(localBranch) : false;
                if (canDeleteLocalBranch && (deletedLocal = this.checkout.deleteBranch(localBranch.name(), ((Branches.Branch)workingTreeBranch.get()).name(), false))) {
                    log.info("Deleted local " + localBranch.name() + " in " + this.checkout.loggingName());
                    BranchCleanupMojo.this.emitMessage("Deleted local " + localBranch.name() + " in " + this.checkout.loggingName());
                }
            });
        }

        public String toString() {
            String remote = this.branch.remote().orElse("");
            return this.checkout.loggingName() + " " + remote + (remote.isEmpty() ? "" : " ") + this.branch.name();
        }

        public boolean isFromDefaultRemote() {
            return this.branch.remote().map(rem -> this.checkout.defaultRemote().map(remotes -> remotes.name().equals(rem)).orElse(false)).orElse(false);
        }

        public Branches branchesContainingHead() {
            return this.checkout.branchesContainingCommit(this.head);
        }

        @Override
        public int compareTo(CheckoutAndHead o) {
            int result = this.checkout.compareTo(o.checkout);
            if (result == 0) {
                result = this.branch.compareTo(o.branch);
            }
            if (result == 0) {
                result = this.head.compareTo(o.head);
            }
            return result;
        }

        public int hashCode() {
            int hash = 3;
            hash = 59 * hash + Objects.hashCode(this.checkout);
            hash = 59 * hash + Objects.hashCode(this.head);
            hash = 59 * hash + Objects.hashCode(this.branch);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CheckoutAndHead other = (CheckoutAndHead)obj;
            if (!Objects.equals(this.head, other.head)) {
                return false;
            }
            if (!Objects.equals(this.checkout, other.checkout)) {
                return false;
            }
            return Objects.equals(this.branch, other.branch);
        }
    }

    private static final class ExactAndPatternPredicate
    implements Predicate<String> {
        private final String name;
        private final Collection<? extends String> exactMatches;
        private final Collection<? extends Pattern> patterns;

        ExactAndPatternPredicate(String name, Collection<? extends String> exactMatches, Collection<? extends Pattern> patterns) {
            this.name = name;
            this.exactMatches = exactMatches;
            this.patterns = patterns;
        }

        @Override
        public boolean test(String branch) {
            if (this.exactMatches.contains(branch)) {
                return true;
            }
            for (Pattern pattern : this.patterns) {
                if (!pattern.matcher(branch).find()) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.name).append('(');
            int len = this.name.length() + 1;
            for (String string : this.exactMatches) {
                if (sb.length() > len) {
                    sb.append(",");
                }
                sb.append(string);
            }
            for (Pattern pattern : this.patterns) {
                if (sb.length() > len) {
                    sb.append(",");
                }
                sb.append('/').append(pattern.pattern()).append('/');
            }
            return sb.append(')').toString();
        }
    }
}

