/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.maven;

import com.mastfrog.function.throwing.ThrowingConsumer;
import com.telenav.cactus.git.Branches;
import com.telenav.cactus.git.GitCheckout;
import com.telenav.cactus.maven.log.BuildLog;
import com.telenav.cactus.maven.mojobase.BaseMojo;
import com.telenav.cactus.maven.mojobase.BaseMojoGoal;
import com.telenav.cactus.maven.tree.ProjectTree;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.maven.plugins.annotations.InstantiationStrategy;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@BaseMojoGoal(value="update-assets-checkouts")
@Mojo(defaultPhase=LifecyclePhase.VALIDATE, requiresDependencyResolution=ResolutionScope.NONE, instantiationStrategy=InstantiationStrategy.SINGLETON, name="update-assets-checkouts", threadSafe=true)
public class BringAssetsBranchesToHeadMojo
extends BaseMojo {
    @Parameter(property="cactus..assets-branch", defaultValue="publish")
    private String assetsBranch;
    @Parameter(property="cactus.assets-pull", defaultValue="false")
    private boolean pull;
    @Parameter(property="cactus.assets-commit", defaultValue="true")
    private boolean commit;

    public BringAssetsBranchesToHeadMojo() {
        super(true);
    }

    @Override
    protected void performTasks(BuildLog log, MavenProject project) throws Exception {
        this.withProjectTree((ThrowingConsumer<ProjectTree>)((ThrowingConsumer)tree -> {
            Set<GitCheckout> nonMavenCheckouts = tree.nonMavenCheckouts();
            HashMap relativePaths = new HashMap();
            LinkedHashSet toUse = new LinkedHashSet();
            for (GitCheckout checkout2 : nonMavenCheckouts) {
                Branches branches;
                if (checkout2.hasPomInRoot() || !(branches = checkout2.branches()).currentBranch().isPresent()) continue;
                Branches.Branch curr = (Branches.Branch)branches.currentBranch().get();
                if (!branches.hasRemoteForLocalOrLocalForRemote(curr)) {
                    log.info("No tracking remote branch for " + curr + " of " + checkout2.loggingName() + " - skipping.");
                    continue;
                }
                checkout2.submoduleRelativePath().ifPresent(path -> {
                    relativePaths.put(path, this.assetsBranch);
                    checkout2.setSubmoduleBranch(path.toString(), this.assetsBranch);
                    toUse.add(checkout2);
                    if (this.isVerbose()) {
                        log.info("Will pull " + checkout2.loggingName());
                    }
                });
            }
            if (toUse.isEmpty()) {
                log.warn("Nothing to update");
                return;
            }
            if (this.pull) {
                toUse.forEach(checkout -> checkout.pull());
            }
            tree.invalidateCache();
            if (!relativePaths.isEmpty() && this.commit && tree.root().hasUncommitedChanges()) {
                tree.root().add(relativePaths.keySet());
                tree.root().commit("Put assets projects on branch '" + this.assetsBranch + "'");
            }
        }));
    }
}

