/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.maven;

import com.telenav.cactus.git.GitCheckout;
import com.telenav.cactus.maven.log.BuildLog;
import com.telenav.cactus.maven.mojobase.BaseMojo;
import com.telenav.cactus.maven.mojobase.BaseMojoGoal;
import com.telenav.cactus.metadata.BuildMetadataUpdater;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Optional;
import org.apache.maven.plugins.annotations.InstantiationStrategy;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@BaseMojoGoal(value="build-metadata")
@Mojo(defaultPhase=LifecyclePhase.PROCESS_SOURCES, requiresDependencyResolution=ResolutionScope.NONE, instantiationStrategy=InstantiationStrategy.SINGLETON, name="build-metadata", threadSafe=true)
public class BuildMetadataMojo
extends BaseMojo {
    @Parameter(property="cactus.project-properties-destination", defaultValue="target/classes/project.properties")
    private String projectPropertiesDestination;
    @Parameter(property="cactus.build.metadata.skip")
    private boolean skip;

    @Override
    protected void performTasks(BuildLog log, MavenProject project) throws Exception {
        if (this.skip) {
            log.info("Build metadata is skipped");
            return;
        }
        if ("pom".equals(project.getPackaging())) {
            log.info("Not writing project metadata for a non-java project.");
            return;
        }
        Path propsFile = project.getBasedir().toPath().resolve(this.projectPropertiesDestination);
        if (!Files.exists(propsFile.getParent(), new LinkOption[0])) {
            Files.createDirectories(propsFile.getParent(), new FileAttribute[0]);
        }
        String propertiesFileContent = this.projectProperties(project);
        Files.writeString(propsFile, (CharSequence)propertiesFileContent, StandardCharsets.UTF_8, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
        ArrayList<String> args = new ArrayList<String>(8);
        args.add(propsFile.getParent().toString());
        Optional checkout = GitCheckout.checkout((File)project.getBasedir());
        if (checkout.isEmpty()) {
            log.warn("Did not find a git checkout for " + project.getBasedir());
        }
        checkout.ifPresent(repo -> {
            args.add("commit-long-hash");
            args.add(repo.head());
            args.add("no-local-modifications");
            args.add(Boolean.toString(!repo.isDirty()));
            repo.commitDate().ifPresent(when -> {
                args.add("commit-timestamp");
                args.add(when.format(DateTimeFormatter.ISO_DATE_TIME));
            });
        });
        BuildMetadataUpdater.main((String[])((String[])args.toArray(String[]::new)));
        this.ifVerbose(() -> {
            log.info("Wrote project.properties");
            log.info("------------------------");
            log.info("to " + propsFile + "\n");
            log.info(propertiesFileContent + "\n");
            Path buildProps = propsFile.getParent().resolve("build.properties");
            if (Files.exists(buildProps, new LinkOption[0])) {
                log.info("Wrote build.properties");
                log.info("----------------------");
                log.info("to " + buildProps + "\n");
                log.info(Files.readString(buildProps));
            } else {
                log.warn("No build file was generated in " + buildProps);
            }
        });
    }

    private String projectProperties(MavenProject project) {
        StringBuilder sb = new StringBuilder();
        String name = project.getName();
        if (name == null) {
            name = project.getArtifactId();
        }
        return sb.append("project-name=").append(name).append("\nproject-version=").append(project.getVersion()).append("\nproject-group-id=").append(project.getGroupId()).append("\nproject-artifact-id=").append(project.getArtifactId()).append('\n').toString();
    }
}

