/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.maven;

import com.mastfrog.function.optional.ThrowingOptional;
import com.mastfrog.function.throwing.ThrowingRunnable;
import com.telenav.cactus.git.GitCheckout;
import com.telenav.cactus.maven.ReplaceMojo;
import com.telenav.cactus.maven.commit.CommitMessage;
import com.telenav.cactus.maven.log.BuildLog;
import com.telenav.cactus.maven.model.GroupId;
import com.telenav.cactus.maven.model.MavenIdentified;
import com.telenav.cactus.maven.model.Pom;
import com.telenav.cactus.maven.model.PomVersion;
import com.telenav.cactus.maven.model.VersionChange;
import com.telenav.cactus.maven.model.VersionChangeMagnitude;
import com.telenav.cactus.maven.model.VersionFlavor;
import com.telenav.cactus.maven.model.VersionFlavorChange;
import com.telenav.cactus.maven.model.resolver.Poms;
import com.telenav.cactus.maven.mojobase.BaseMojoGoal;
import com.telenav.cactus.maven.refactoring.SuperpomBumpPolicy;
import com.telenav.cactus.maven.refactoring.VersionMismatchPolicy;
import com.telenav.cactus.maven.refactoring.VersionMismatchPolicyOutcome;
import com.telenav.cactus.maven.refactoring.VersionReplacementFinder;
import com.telenav.cactus.maven.refactoring.VersionUpdateFilter;
import com.telenav.cactus.maven.shared.SharedDataKey;
import com.telenav.cactus.maven.tree.ProjectTree;
import com.telenav.cactus.maven.trigger.RunPolicies;
import com.telenav.cactus.scope.ProjectFamily;
import com.telenav.cactus.scope.Scope;
import com.telenav.cactus.tasks.Rollback;
import com.telenav.cactus.util.EnumMatcher;
import com.telenav.cactus.util.SectionedMessage;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import org.apache.maven.plugins.annotations.InstantiationStrategy;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@BaseMojoGoal(value="bump-version")
@Mojo(defaultPhase=LifecyclePhase.VALIDATE, requiresDependencyResolution=ResolutionScope.COMPILE, instantiationStrategy=InstantiationStrategy.SINGLETON, name="bump-version", threadSafe=true)
public class BumpVersionMojo
extends ReplaceMojo {
    private static final EnumMatcher<VersionChangeMagnitude> MAGNITUDE_MATCHER = EnumMatcher.enumMatcher(VersionChangeMagnitude.class);
    private static final EnumMatcher<VersionFlavorChange> FLAVOR_MATCHER = EnumMatcher.enumMatcher(VersionFlavorChange.class);
    private static final EnumMatcher<VersionMismatchPolicyOutcome> MISMATCH_MATCHER = EnumMatcher.enumMatcher(VersionMismatchPolicyOutcome.class);
    private static final EnumMatcher<SuperpomBumpPolicy> SUPERPOM_POLICY_MATCHER = EnumMatcher.enumMatcher(SuperpomBumpPolicy.class);
    private static final SharedDataKey<Object> versionBumpKey = SharedDataKey.of("versionBump", Object.class);
    private static final String DEFAULT_RELEASE_BRANCH_PREFIX = "release/";
    @Parameter(property="cactus.version.change.magnitude", defaultValue="dot")
    String versionChangeMagnitude;
    @Parameter(property="cactus.version.flavor.change", defaultValue="unchanged")
    String versionFlavor;
    @Parameter(property="cactus.version.mismatch.policy", defaultValue="bump")
    String versionMismatchPolicy;
    @Parameter(property="cactus.version.single.family")
    boolean singleFamily;
    @Parameter(property="cactus.superpom.bump.policy", defaultValue="bump-without-changing-flavor")
    String bumpPolicy;
    @Parameter(property="cactus.explicit.version")
    String explicitVersion;
    @Parameter(property="cactus.update.docs", defaultValue="true")
    boolean updateDocs;
    @Parameter(property="cactus.commit-changes", defaultValue="false")
    boolean commit;
    @Parameter(property="cactus.create.release.branch", defaultValue="false")
    boolean createReleaseBranch;
    @Parameter(property="cactus.development.branch", defaultValue="develop")
    String developmentBranch;
    @Parameter(property="cactus.no.bump.families")
    private String noRevisionFamilies;
    @Parameter(property="cactus.dot.bump.families")
    private String dotRevisionFamilies;
    @Parameter(property="cactus.minor.bump.families")
    private String minorRevisionFamilies;
    @Parameter(property="cactus.major.bump.families")
    private String majorRevisionFamilies;
    @Parameter(property="cactus.release.branch.prefix")
    String releaseBranchPrefix;
    @Parameter(property="cactus.bump.published", defaultValue="false")
    boolean bumpPublished;

    public BumpVersionMojo() {
        super(RunPolicies.LAST_IN_SESSION_PROJECTS);
    }

    @Override
    protected void execute(BuildLog log, MavenProject project, GitCheckout myCheckout, ProjectTree tree, List<GitCheckout> checkouts) throws Exception {
        if (this.wasRun()) {
            log.info("Version bump was already run.");
        }
        this.ensureAllProjectsPreloaded();
        log.info("Checking repositories' state");
        this.checkCheckoutStates("Some git checkouts are not in a usable state for generating version changes", tree, checkouts);
        log.info("Building index of all pom.xmls");
        VersionReplacementFinder replacer = new VersionReplacementFinder(new Poms(tree.allProjects())).withVersionMismatchPolicy(this.mismatchPolicy()).withSuperpomBumpPolicy(this.superpomBumpPolicy()).withFilter(this.filter());
        if (this.bumpPublished) {
            replacer.bumpUnpublishedPoms();
        }
        log.info("Computing changes for " + this.magnitude() + " " + this.flavor() + " " + this.mismatchPolicy());
        if (this.explicitVersion != null && this.scope().canBeMultiFamily()) {
            this.fail("Cannot use an explicit version with a scope that can match more than one family, such as '" + this.scope() + "'. Only '" + Scope.FAMILY + "' or '" + Scope.FAMILY_OR_CHILD_FAMILY + "' are legal if you pass a specific version to change to.");
        }
        HashMap<ProjectFamily, PomVersion> versionForFamily = new HashMap<ProjectFamily, PomVersion>();
        if (this.isVerbose()) {
            log.info("BumpVersion " + this.scope() + " " + this.families() + " for '" + this.families + "' and '" + this.family + "'");
        }
        switch (this.scope()) {
            case JUST_THIS: {
                Pom myPom = (Pom)Pom.from((Path)project.getFile().toPath()).get();
                PomVersion myNewVersion = this.newVersion(myPom);
                replacer.withSinglePomChange((MavenIdentified)myPom, myNewVersion);
                versionForFamily.put(ProjectFamily.familyOf((MavenIdentified)myPom), myNewVersion);
                break;
            }
            case SAME_GROUP_ID: {
                tree.projectsForGroupId(project.getGroupId()).forEach(pom -> {
                    PomVersion nv = this.newVersion((Pom)pom);
                    replacer.withSinglePomChange((MavenIdentified)pom, nv);
                });
                break;
            }
            case FAMILY: {
                for (ProjectFamily fam : this.families()) {
                    this.findVersionOfFamily(tree, fam).ifPresent(v -> {
                        PomVersion nue;
                        if (this.explicitVersion != null) {
                            nue = PomVersion.of((String)this.explicitVersion);
                        } else {
                            Optional change = v.updatedWith(this.magnitude(fam), this.flavor());
                            if (!change.isPresent()) {
                                return;
                            }
                            nue = (PomVersion)change.get();
                        }
                        versionForFamily.put(fam, nue);
                        replacer.withFamilyVersionChange(fam, v, nue);
                        if (this.isVerbose()) {
                            log.info("Version for " + fam + " is " + v + " -> " + nue);
                        }
                    });
                }
                break;
            }
            case FAMILY_OR_CHILD_FAMILY: {
                this.familyWithChildFamilies(tree).forEach(family -> this.findVersionOfFamily(tree, (ProjectFamily)family).ifPresent(ffv -> {
                    Optional change = ffv.updatedWith(this.magnitude((ProjectFamily)family), this.flavor());
                    if (!change.isPresent()) {
                        return;
                    }
                    PomVersion newFamilyVersion = (PomVersion)change.get();
                    versionForFamily.put((ProjectFamily)family, (PomVersion)ffv);
                    replacer.withFamilyVersionChange(family, ffv, newFamilyVersion);
                }));
                break;
            }
            case ALL: 
            case ALL_PROJECT_FAMILIES: {
                this.allFamilies(tree).forEach(family -> this.findVersionOfFamily(tree, (ProjectFamily)family).ifPresent(ffv -> {
                    Optional change = ffv.updatedWith(this.magnitude((ProjectFamily)family), this.flavor());
                    if (!change.isPresent()) {
                        return;
                    }
                    PomVersion newFamilyVersion = (PomVersion)change.get();
                    versionForFamily.put((ProjectFamily)family, (PomVersion)ffv);
                    replacer.withFamilyVersionChange(family, ffv, newFamilyVersion);
                }));
                break;
            }
            default: {
                throw new AssertionError(this.scope());
            }
        }
        if (this.isIncludeRoot()) {
            if (tree.root().isSubmoduleRoot() && tree.root().hasPomInRoot()) {
                if (this.isVerbose()) {
                    log.info("Including root");
                }
                tree.projectOf(tree.root().checkoutRoot().resolve("pom.xml")).ifPresent(rootPom -> {
                    PomVersion newRootVersion = (PomVersion)rootPom.version().updatedWith(this.magnitude(), this.flavor()).get();
                    replacer.withSinglePomChange((MavenIdentified)rootPom, newRootVersion);
                });
            } else if (this.isVerbose()) {
                log.info("NOT including root");
            }
        }
        replacer.pretend(this.isPretend());
        log.info("Applying changes");
        log.info(replacer.toString());
        Set rewritten = replacer.go(arg_0 -> ((BuildLog)log).info(arg_0));
        Rollback rollback = new Rollback();
        this.addFileModifications(rollback, rewritten, log);
        rollback.executeWithRollback(ThrowingRunnable.composable((boolean)false).andAlways(() -> {
            boolean addOwners;
            Set owners = GitCheckout.ownersOf((Collection)rewritten);
            if (this.isVerbose()) {
                log.info("Owners:");
                owners.forEach(o -> log.info("  * " + o.loggingName()));
            }
            HashMap<GitCheckout, String> releaseBranchNames = new HashMap<GitCheckout, String>();
            boolean bl = addOwners = !owners.contains(tree.root()) && tree.root().isSubmoduleRoot();
            if (this.updateDocs) {
                this.computeReleaseBranchNames(owners, tree, versionForFamily, releaseBranchNames, log);
                this.runSubstitutions(log, project, myCheckout, tree, new ArrayList<GitCheckout>(owners), releaseBranchNames, rewritten::add);
            }
            if (this.commit) {
                log.info("Commit is true.");
                if (this.createReleaseBranch) {
                    owners.add(tree.root());
                    log.info("Create release branch in " + owners.size() + " repositories");
                    if (releaseBranchNames.isEmpty()) {
                        this.computeReleaseBranchNames(owners, tree, versionForFamily, releaseBranchNames, log);
                    }
                    if (addOwners && !releaseBranchNames.isEmpty()) {
                        releaseBranchNames.put(tree.root(), BumpVersionMojo.longest(releaseBranchNames));
                    }
                }
                this.generateCommit(owners, replacer, releaseBranchNames, rollback, tree);
            }
        }).andAlwaysRun(tree::invalidateCache));
    }

    private void addFileModifications(Rollback rollback, Collection<? extends Path> files, BuildLog log) {
        files.forEach(file -> this.addRollbackTask(rollback, (Path)file, log));
    }

    private void addRollbackTask(Rollback rollback, Path path, BuildLog log) {
        rollback.addRollbackTask(() -> ThrowingOptional.from((Optional)GitCheckout.checkout((Path)path)).ifPresent(repo -> {
            log.error("Roll back changes in " + path);
            repo.checkoutOneFile(path);
        }));
    }

    private void ensureAllProjectsPreloaded() {
        this.session().getAllProjects().forEach(prj -> prj.getVersion());
    }

    @Override
    protected void onValidateParameters(BuildLog log, MavenProject project) throws Exception {
        PomVersion updatedVersion;
        super.onValidateParameters(log, project);
        if (this.createReleaseBranch) {
            this.commit = true;
        }
        switch (this.scope()) {
            case FAMILY: {
                break;
            }
            case JUST_THIS: {
                if (this.createReleaseBranch) {
                    this.fail("Cannot use createReleaseBranch when bumping a single project.");
                }
            }
            case SAME_GROUP_ID: 
            case FAMILY_OR_CHILD_FAMILY: 
            case ALL: 
            case ALL_PROJECT_FAMILIES: {
                break;
            }
            default: {
                throw new AssertionError(this.scope());
            }
        }
        VersionChangeMagnitude mag = this.magnitude();
        VersionFlavorChange flavor = this.flavor();
        if (mag.isNone() && flavor.isNone() && !this.bumpPublished && this.explicitVersion == null) {
            this.fail("Nothing to do for " + mag + " " + flavor + " and cactus.bump-published is not set.");
        }
        PomVersion oldVersion = PomVersion.of((String)project.getVersion());
        if (this.explicitVersion != null) {
            updatedVersion = PomVersion.of((String)this.explicitVersion);
            if (!updatedVersion.isValidVersion()) {
                this.fail("'" + this.explicitVersion + "' is not a valid maven version");
            }
            if (this.families().size() > 1) {
                this.fail("Cannot use an explicit version when updating more than one family.");
            }
        } else {
            updatedVersion = oldVersion.updatedWith(mag, flavor).orElse(null);
            if (updatedVersion == null && !this.bumpPublished) {
                this.fail("Applying " + mag + " + " + flavor + " to version " + oldVersion + " does not change anything");
            } else if (updatedVersion == null) {
                updatedVersion = oldVersion;
            }
        }
        VersionChange vc = new VersionChange(oldVersion, updatedVersion);
        this.session().getAllProjects().forEach(prj -> project.getProperties().put("cactus.version.change.description", ProjectFamily.fromGroupId((String)project.getGroupId()) + " " + vc));
        log.info("Bump version of " + project.getGroupId() + ":" + project.getArtifactId() + " from " + oldVersion + " to " + updatedVersion);
        this.newVersion = updatedVersion.text();
        if (this.newBranchName == null && updatedVersion.flavor() == VersionFlavor.RELEASE) {
            this.newBranchName = this.releaseBranchPrefix() + updatedVersion;
        }
        this.checkFamilyParameters();
    }

    private static String longest(Map<GitCheckout, String> m) {
        assert (!m.isEmpty());
        ArrayList<String> l = new ArrayList<String>(m.values());
        l.sort((a, b) -> Integer.compare(b.length(), a.length()));
        return (String)l.get(0);
    }

    VersionFlavorChange flavor() {
        return (VersionFlavorChange)FLAVOR_MATCHER.matchOrThrow(this.versionFlavor);
    }

    VersionChangeMagnitude magnitude() {
        Optional mag = MAGNITUDE_MATCHER.match(this.versionChangeMagnitude);
        if (mag.isEmpty()) {
            throw new IllegalArgumentException("Unrecognized magnitude change flavor '" + this.versionChangeMagnitude + "'");
        }
        return (VersionChangeMagnitude)mag.get();
    }

    private Set<ProjectFamily> projectFamiliesFrom(String familySet) {
        if (familySet == null || familySet.isBlank()) {
            return Collections.emptySet();
        }
        familySet = familySet.replaceAll("\"", "").replaceAll("'", "");
        HashSet<ProjectFamily> result = new HashSet<ProjectFamily>(5);
        for (String s : familySet.split("[, ]")) {
            if ((s = s.trim()).isEmpty()) continue;
            result.add(ProjectFamily.named((String)s));
        }
        return result;
    }

    private Set<ProjectFamily> noRevisionFamilies() {
        return this.projectFamiliesFrom(this.noRevisionFamilies);
    }

    private Set<ProjectFamily> dotRevisionFamilies() {
        return this.projectFamiliesFrom(this.dotRevisionFamilies);
    }

    private Set<ProjectFamily> minorRevisionFamilies() {
        return this.projectFamiliesFrom(this.minorRevisionFamilies);
    }

    private Set<ProjectFamily> majorRevisionFamilies() {
        return this.projectFamiliesFrom(this.majorRevisionFamilies);
    }

    private static Set<?> combine(Set<?> ... all) {
        HashSet result = new HashSet();
        for (Set<?> s : all) {
            result.addAll(s);
        }
        return result;
    }

    private void checkFamilyParameters() {
        Set<ProjectFamily> expectedFamilies;
        Set<ProjectFamily> dot = this.dotRevisionFamilies();
        Set<ProjectFamily> minor = this.minorRevisionFamilies();
        Set<ProjectFamily> major = this.majorRevisionFamilies();
        Set<ProjectFamily> none = this.noRevisionFamilies();
        Set<ProjectFamily> all = BumpVersionMojo.combine(dot, minor, major, none);
        if (all.isEmpty()) {
            return;
        }
        if (all.size() != dot.size() + minor.size() + major.size() + none.size()) {
            this.fail("Contradictory revision changes specified - at least one family is in more than one category.\n\tDot: " + dot + "\nMinor: " + minor + "\nMajor: " + major + "\nNone: " + none);
        }
        if (!(expectedFamilies = this.families()).containsAll(all)) {
            all.removeAll(this.families());
            StringBuilder msg = new StringBuilder("Some families are slated for a none, dot, minor or major version bump, but are not actually in the set of cactus.families:");
            for (Object obj : all) {
                msg.append("\n  * ").append(obj);
            }
            msg.append("\nFamilies specified:");
            for (ProjectFamily projectFamily : expectedFamilies) {
                msg.append("\n  * ").append(projectFamily);
            }
            this.fail(msg.toString());
        }
    }

    VersionChangeMagnitude magnitude(ProjectFamily family) {
        if (this.noRevisionFamilies().contains(family)) {
            return VersionChangeMagnitude.NONE;
        }
        if (this.dotRevisionFamilies().contains(family)) {
            return VersionChangeMagnitude.DOT;
        }
        if (this.minorRevisionFamilies().contains(family)) {
            return VersionChangeMagnitude.MINOR;
        }
        if (this.majorRevisionFamilies().contains(family)) {
            return VersionChangeMagnitude.MAJOR;
        }
        return this.magnitude();
    }

    VersionMismatchPolicy mismatchPolicy() {
        return (VersionMismatchPolicy)MISMATCH_MATCHER.matchOrThrow(this.versionMismatchPolicy);
    }

    SuperpomBumpPolicy superpomBumpPolicy() {
        return (SuperpomBumpPolicy)SUPERPOM_POLICY_MATCHER.matchOrThrow(this.bumpPolicy);
    }

    private Set<ProjectFamily> allFamilies(ProjectTree tree) {
        HashSet<ProjectFamily> allFamilies = new HashSet<ProjectFamily>();
        tree.allProjects().forEach(pom -> allFamilies.add(ProjectFamily.familyOf((GroupId)pom.groupId())));
        return allFamilies;
    }

    private void checkCheckoutStates(String messageHead, ProjectTree tree, List<GitCheckout> checkouts) {
        StringBuilder failMessage = new StringBuilder();
        for (GitCheckout co : checkouts) {
            if (co.isSubmoduleRoot()) continue;
            String nm = co.name();
            if (tree.isDetachedHead(co)) {
                failMessage.append('\n');
                failMessage.append(nm).append(" is in detached head state");
                continue;
            }
            if (tree.isDirty(co)) {
                if (!this.commit) continue;
                failMessage.append('\n');
                failMessage.append(nm).append(" has local modifications, and a commit has been requested");
                continue;
            }
            Optional br = tree.branches(co).currentBranch();
            if (!br.isEmpty()) continue;
            failMessage.append('\n').append(nm).append("Is not on the development branch '").append(this.developmentBranch).append("' but on '").append(br.get());
        }
        if (failMessage.length() > 0) {
            failMessage.insert(0, messageHead);
            this.fail(failMessage.toString());
        }
    }

    private void computeReleaseBranchName(GitCheckout co, ProjectTree tree, Map<ProjectFamily, PomVersion> familyVersion, Map<GitCheckout, String> releaseBranchNames, BuildLog log1) {
        TreeSet<ProjectFamily> familiesHere = new TreeSet<ProjectFamily>();
        boolean isTreeRoot = co.equals((Object)tree.root());
        if (isTreeRoot) {
            familiesHere.addAll(familyVersion.keySet());
        } else {
            tree.projectsWithin(co).forEach(prj -> familiesHere.add(ProjectFamily.familyOf((MavenIdentified)prj)));
        }
        familiesHere.retainAll(familyVersion.keySet());
        if (!familiesHere.isEmpty()) {
            String prefix = this.releaseBranchPrefix();
            StringBuilder sb = new StringBuilder(prefix);
            if (familiesHere.size() == 1) {
                sb.append(familyVersion.get(familiesHere.iterator().next()));
            } else {
                for (ProjectFamily pf : familiesHere) {
                    if (sb.length() > prefix.length()) {
                        sb.append('_');
                    }
                    PomVersion ver = familyVersion.get(pf);
                    sb.append(pf).append('-').append(ver);
                }
            }
            releaseBranchNames.put(co, sb.toString());
            String logName = co.name().isEmpty() ? "(root)" : co.name();
            log1.info("Release branch for " + logName + " is " + sb);
        }
    }

    private void computeReleaseBranchNames(Set<GitCheckout> owners, ProjectTree tree, Map<ProjectFamily, PomVersion> familyVersion, Map<GitCheckout, String> releaseBranchNames, BuildLog log1) {
        for (GitCheckout co : owners) {
            this.computeReleaseBranchName(co, tree, familyVersion, releaseBranchNames, log1);
        }
        if (this.isVerbose()) {
            this.log.info("Have " + releaseBranchNames.size() + " release branches:");
            releaseBranchNames.forEach((k, v) -> this.log.info("  * " + k.loggingName() + " -> " + v));
        }
    }

    private Set<ProjectFamily> familyWithChildFamilies(ProjectTree tree) {
        Set<ProjectFamily> fams = this.families();
        HashSet<ProjectFamily> relatives = new HashSet<ProjectFamily>();
        for (ProjectFamily fam : fams) {
            tree.allProjects().forEach(pom -> fam.ifParentFamilyOf(pom.groupId(), () -> relatives.add(ProjectFamily.familyOf((GroupId)pom.groupId()))));
            relatives.add(fam);
        }
        return relatives;
    }

    private VersionUpdateFilter filter() {
        if (this.singleFamily) {
            Set<ProjectFamily> all = this.families();
            if (all.isEmpty()) {
                all = Collections.singleton(ProjectFamily.familyOf((GroupId)GroupId.of((String)this.project().getGroupId())));
            }
            return VersionUpdateFilter.withinFamilyOrParentFamily((ProjectFamily)all.iterator().next());
        }
        return VersionUpdateFilter.DEFAULT;
    }

    private Optional<PomVersion> findVersionOfFamily(ProjectTree tree, ProjectFamily family) {
        return family.probableFamilyVersion(tree.allProjects());
    }

    private void generateCommit(Set<GitCheckout> ownerSet, VersionReplacementFinder replacer, Map<GitCheckout, String> branchNameForCheckout, Rollback rollback, ProjectTree tree) throws Exception {
        if (ownerSet.isEmpty()) {
            return;
        }
        List owners = GitCheckout.depthFirstSort(ownerSet);
        BuildLog lg = this.log().child("commit");
        lg.warn("Begin commit of " + owners.size() + " repositories");
        CommitMessage msg = new CommitMessage(BumpVersionMojo.class, "Updated versions in " + replacer.changeCount() + " projects");
        replacer.collectChanges((SectionedMessage)msg);
        this.populateCommitMessage(msg, owners, branchNameForCheckout);
        HashSet<GitCheckout> committed = new HashSet<GitCheckout>();
        for (GitCheckout checkout : owners) {
            if (this.createReleaseBranch) {
                String branchName = branchNameForCheckout.get(checkout);
                if (branchName != null) {
                    this.branchOneCheckout(branchName, checkout, rollback);
                } else {
                    this.log.info("No branch name was computed for " + checkout.checkoutRoot());
                }
            }
            if (!this.isPretend()) {
                checkout.addAll();
                checkout.commit(msg.toString());
            }
            committed.add(checkout);
            lg.info("Commited " + checkout.name());
        }
        if (!owners.isEmpty() && this.createReleaseBranch && this.isIncludeRoot() && !committed.contains(tree.root()) && tree.root().isSubmoduleRoot()) {
            this.createRootCheckout(branchNameForCheckout, tree, msg, rollback);
        }
    }

    private void branchOneCheckout(String branchName, GitCheckout checkout, Rollback rollback) throws Exception {
        this.log().info("Create and switch to " + branchName + " in  based on " + this.developmentBranch + " in " + checkout);
        this.ifNotPretending(() -> {
            checkout.createAndSwitchToBranch(branchName, Optional.empty());
            rollback.addRollbackTask(() -> {
                this.log().info("Rollback branch creation for " + branchName + " in " + checkout);
                checkout.deleteBranch(branchName, this.developmentBranch, true);
            });
        });
    }

    private void createRootCheckout(Map<GitCheckout, String> branchNameForCheckout, ProjectTree tree, CommitMessage msg, Rollback rollback) {
        String bestBranch = branchNameForCheckout.getOrDefault(tree.root(), BumpVersionMojo.longest(branchNameForCheckout));
        this.log.info("Create root checkout commit in " + tree.root().checkoutRoot());
        if (!this.isPretend()) {
            tree.root().createAndSwitchToBranch(bestBranch, Optional.empty());
            tree.root().addAll();
            tree.root().commit(msg.toString());
            rollback.addRollbackTask(() -> tree.root().deleteBranch(bestBranch, this.developmentBranch, true));
        }
    }

    private void populateCommitMessage(CommitMessage msg, List<GitCheckout> owners, Map<GitCheckout, String> branchNameForCheckout) {
        ArrayList<GitCheckout> sortedByName = new ArrayList<GitCheckout>(owners);
        Collections.sort(sortedByName, (a, b) -> a.loggingName().compareTo(b.loggingName()));
        try (SectionedMessage.MessageSection branchesSection = msg.section("Branches");){
            for (GitCheckout checkout : sortedByName) {
                String branchName;
                if (!this.createReleaseBranch || (branchName = branchNameForCheckout.get(checkout)) == null) continue;
                branchesSection.bulletPoint("`" + checkout.loggingName() + "` - " + branchName);
            }
        }
    }

    private PomVersion newVersion(Pom pom) {
        if (this.explicitVersion != null && this.families().iterator().next().equals((Object)ProjectFamily.familyOf((MavenIdentified)pom))) {
            return PomVersion.of((String)this.explicitVersion);
        }
        if (this.explicitVersion != null) {
            throw new IllegalStateException("Explicit version can only be used when altering a  SINGLE project family, but have family " + this.families() + " plus " + ProjectFamily.familyOf((MavenIdentified)pom) + " from " + pom);
        }
        VersionChangeMagnitude mag = this.magnitude(ProjectFamily.familyOf((MavenIdentified)pom));
        VersionFlavorChange flavor = this.flavor();
        PomVersion oldVersion = pom.version();
        return (PomVersion)oldVersion.updatedWith(mag, flavor).orElseThrow(() -> new IllegalStateException("Applying " + mag + " + " + flavor + " to version " + oldVersion + " does not change anything"));
    }

    private String releaseBranchPrefix() {
        if (this.releaseBranchPrefix != null && !this.releaseBranchPrefix.isBlank()) {
            Object result = this.releaseBranchPrefix.trim();
            if (((String)result).charAt(((String)result).length() - 1) != '/') {
                result = (String)result + "/";
            }
            return result;
        }
        String prop = System.getProperty("releaseBranchPrefix");
        if (prop != null && !prop.isBlank()) {
            Object result = prop.trim();
            if (((String)result).charAt(((String)result).length() - 1) != '/') {
                result = (String)result + "/";
            }
            return result;
        }
        return DEFAULT_RELEASE_BRANCH_PREFIX;
    }

    private void runSubstitutions(BuildLog log, MavenProject project, GitCheckout myCheckout, ProjectTree tree, List<GitCheckout> checkouts, Map<GitCheckout, String> releaseBranchNames, Consumer<Path> collector) throws Exception {
        super.executeCollectingChangedFiles(log, project, myCheckout, tree, checkouts, releaseBranchNames, collector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean wasRun() {
        Class<BumpVersionMojo> clazz = BumpVersionMojo.class;
        synchronized (BumpVersionMojo.class) {
            Optional<Object> opt = this.sharedData().get(versionBumpKey);
            if (opt.isEmpty()) {
                this.sharedData().put(versionBumpKey, new Object());
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return false;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return true;
        }
    }
}

