/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.maven;

import com.telenav.cactus.maven.MavenArtifactCoordinatesWrapper;
import com.telenav.cactus.maven.log.BuildLog;
import com.telenav.cactus.maven.model.MavenArtifactCoordinates;
import com.telenav.cactus.maven.model.published.PublishChecker;
import com.telenav.cactus.maven.model.published.PublishedState;
import com.telenav.cactus.maven.mojobase.BaseMojo;
import com.telenav.cactus.maven.mojobase.BaseMojoGoal;
import com.telenav.cactus.maven.shared.SharedDataKey;
import java.net.http.HttpClient;
import javax.inject.Inject;
import org.apache.maven.plugins.annotations.InstantiationStrategy;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@BaseMojoGoal(value="check-published")
@Mojo(defaultPhase=LifecyclePhase.VALIDATE, requiresDependencyResolution=ResolutionScope.NONE, instantiationStrategy=InstantiationStrategy.KEEP_ALIVE, name="check-published", threadSafe=true)
public class CheckAlreadyPublishedMojo
extends BaseMojo {
    private static final SharedDataKey<HttpClient> HTTP_CLIENT_KEY = SharedDataKey.of(HttpClient.class);
    @Parameter(property="cactus.url.base", defaultValue="https://repo1.maven.org/maven2/")
    private final String urlBase = "https://repo1.maven.org/maven2/";
    @Parameter(property="cactus.published.warn", defaultValue="false")
    private boolean warnOnAlreadyPublished;
    @Parameter(property="cactus.publish.check.skip")
    private boolean skip;
    @Parameter(property="cactus.identical-ok", defaultValue="true")
    private boolean identicalOk;
    @Inject
    private PublishChecker checker;

    @Override
    protected void performTasks(BuildLog log, MavenProject project) throws Exception {
        if (this.skip) {
            log.info("Artifact publication check is skipped");
            return;
        }
        log.info("Check if " + project.getArtifactId() + " is already published");
        PublishedState state = this.checker.check((MavenArtifactCoordinates)MavenArtifactCoordinatesWrapper.wrap(project));
        switch (state) {
            case NOT_PUBLISHED: {
                log.info("Not already published: " + project.getArtifactId());
                break;
            }
            case PUBLISHED_IDENTICAL: {
                if (this.identicalOk) break;
                this.warnOrFail(log, project);
                break;
            }
            case PUBLISHED_DIFFERENT: {
                this.warnOrFail(log, project);
            }
        }
    }

    private void warnOrFail(BuildLog log, MavenProject project) {
        String msg = "POM for " + project.getGroupId() + ":" + project.getArtifactId() + ":" + project.getVersion() + " was already published, and the contents differs from the local copy.  Its version needs to be bumped.";
        if (this.warnOnAlreadyPublished) {
            log.warn(msg);
        } else {
            this.fail(msg);
        }
    }
}

