/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.maven;

import com.telenav.cactus.maven.log.BuildLog;
import com.telenav.cactus.maven.mojobase.BaseMojoGoal;
import com.telenav.cactus.maven.mojobase.SharedProjectTreeMojo;
import com.telenav.cactus.maven.tree.ConsistencyChecker;
import com.telenav.cactus.maven.tree.ParentRelativePathChecker;
import com.telenav.cactus.maven.tree.Problem;
import com.telenav.cactus.maven.tree.ProjectTree;
import java.util.LinkedHashSet;
import org.apache.maven.plugins.annotations.InstantiationStrategy;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@BaseMojoGoal(value="check-consistency")
@Mojo(defaultPhase=LifecyclePhase.VALIDATE, requiresDependencyResolution=ResolutionScope.NONE, instantiationStrategy=InstantiationStrategy.SINGLETON, name="check-consistency", threadSafe=true)
public class CheckConsistencyMojo
extends SharedProjectTreeMojo {
    @Parameter(property="cactus.ignore-in-branch-consistency-check", defaultValue="-assets")
    private String ignoreInBranchConsistencyCheck = "";
    @Parameter(property="cactus.ignore-in-version-consistency-check")
    private String ignoreInVersionConsistencyCheck = "";
    @Parameter(property="cactus.all-group-ids", defaultValue="false")
    private boolean allGroupIds = false;

    public CheckConsistencyMojo() {
        super(true);
    }

    @Override
    protected void performTasks(BuildLog log, MavenProject project) throws Exception {
        ConsistencyChecker checker = new ConsistencyChecker(this.ignoreInBranchConsistencyCheck, this.ignoreInVersionConsistencyCheck, this.allGroupIds ? null : project.getGroupId(), true);
        LinkedHashSet inconsistencies = new LinkedHashSet(checker.checkConsistency(project, log, this.projectTree()));
        log.info("Check parent relative paths");
        this.projectTree().ifPresent(tree -> inconsistencies.addAll(new ParentRelativePathChecker().checkTree((ProjectTree)tree)));
        if (!inconsistencies.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (Problem problem : inconsistencies) {
                if (sb.length() > 0) {
                    sb.append('\n');
                }
                sb.append(problem);
            }
            log.error(sb.toString());
            this.fail(sb.toString());
        }
    }
}

