/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.maven;

import com.mastfrog.function.optional.ThrowingOptional;
import com.mastfrog.function.throwing.ThrowingConsumer;
import com.telenav.cactus.maven.log.BuildLog;
import com.telenav.cactus.maven.model.VersionFlavor;
import com.telenav.cactus.maven.mojobase.BaseMojoGoal;
import com.telenav.cactus.maven.mojobase.FamilyAwareMojo;
import com.telenav.cactus.maven.tree.ConsistencyChecker2;
import com.telenav.cactus.maven.tree.Problems;
import com.telenav.cactus.maven.tree.ProjectTree;
import com.telenav.cactus.maven.trigger.RunPolicies;
import com.telenav.cactus.scope.ProjectFamily;
import com.telenav.cactus.util.EnumMatcher;
import org.apache.maven.plugins.annotations.InstantiationStrategy;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@BaseMojoGoal(value="check")
@Mojo(defaultPhase=LifecyclePhase.VALIDATE, requiresDependencyResolution=ResolutionScope.NONE, instantiationStrategy=InstantiationStrategy.SINGLETON, name="check", threadSafe=true)
public class CheckMojo
extends FamilyAwareMojo {
    private static final EnumMatcher<VersionFlavor> FLAVOR_MATCHER = EnumMatcher.enumMatcher(VersionFlavor.class);
    @Parameter(property="cactus.check.remote", defaultValue="true")
    private boolean checkRemoteModifications = true;
    @Parameter(property="cactus.check.families", defaultValue="true")
    private boolean checkFamilies = true;
    @Parameter(property="cactus.check.roles", defaultValue="true")
    private boolean checkRoles = true;
    @Parameter(property="cactus.check.versions", defaultValue="true")
    private boolean checkVersions = true;
    @Parameter(property="cactus.check.detached", defaultValue="true")
    private boolean checkDetached = true;
    @Parameter(property="cactus.check.branches", defaultValue="true")
    private boolean checkBranches = true;
    @Parameter(property="cactus.check.paths", defaultValue="true")
    private boolean checkRelativePaths = true;
    @Parameter(property="cactus.check.dirty", defaultValue="true")
    private boolean checkDirty = true;
    @Parameter(property="cactus.expected.branch")
    private String expectedBranch;
    @Parameter(property="cactus.tolerate.version.inconsistencies.families")
    private String tolerateVersionInconsistenciesIn;
    @Parameter(property="cactus.check.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="cactus.version.flavor")
    private String versionFlavor;

    public CheckMojo() {
        super(RunPolicies.FIRST);
    }

    @Override
    protected void performTasks(BuildLog log, MavenProject project) throws Exception {
        if (this.skip) {
            return;
        }
        ConsistencyChecker2 c = new ConsistencyChecker2().activityLogger(arg_0 -> ((BuildLog)log).info(arg_0)).withTargetBranch(this.expectedBranch);
        if (this.checkRelativePaths) {
            c.checkRelativePaths();
        }
        if (this.checkFamilies) {
            c.checkFamilies();
        }
        if (this.checkRemoteModifications) {
            c.checkRemoteModifications();
        }
        if (this.checkRoles) {
            c.checkRoles();
        }
        if (this.checkVersions) {
            c.checkVersions();
        }
        if (this.checkDetached) {
            c.checkDetached();
        }
        if (this.checkBranches) {
            c.checkBranches();
        }
        if (this.checkDirty) {
            c.checkLocalModifications();
        }
        this.flavor().ifPresent(c::enforceVersionFlavor);
        if (this.tolerateVersionInconsistenciesIn != null) {
            c.tolerateVersionInconsistenciesIn(ProjectFamily.fromCommaDelimited((String)this.tolerateVersionInconsistenciesIn, () -> null));
        }
        if (this.hasExplicitFamilies()) {
            c.checkFamilies(this.families());
        }
        this.withProjectTree((ThrowingConsumer<ProjectTree>)((ThrowingConsumer)tree -> {
            Problems probs = c.check((ProjectTree)tree);
            if (probs.hasFatal()) {
                String s = probs.toString();
                log.error(s);
                this.fail(s);
            }
        }));
    }

    ThrowingOptional<VersionFlavor> flavor() {
        if (this.versionFlavor != null && !this.versionFlavor.isBlank()) {
            return ThrowingOptional.of((Object)((VersionFlavor)FLAVOR_MATCHER.matchOrThrow(this.versionFlavor)));
        }
        return ThrowingOptional.empty();
    }
}

