/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.maven;

import com.mastfrog.function.throwing.ThrowingConsumer;
import com.mastfrog.util.strings.Strings;
import com.telenav.cactus.git.Branches;
import com.telenav.cactus.git.GitCheckout;
import com.telenav.cactus.maven.commit.CommitMessage;
import com.telenav.cactus.maven.log.BuildLog;
import com.telenav.cactus.maven.mojobase.BaseMojoGoal;
import com.telenav.cactus.maven.mojobase.ScopedCheckoutsMojo;
import com.telenav.cactus.maven.tree.ProjectTree;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.InstantiationStrategy;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@BaseMojoGoal(value="checkout")
@Mojo(defaultPhase=LifecyclePhase.VALIDATE, requiresDependencyResolution=ResolutionScope.NONE, instantiationStrategy=InstantiationStrategy.SINGLETON, name="checkout", threadSafe=true)
public class CheckoutMojo
extends ScopedCheckoutsMojo {
    @Parameter(property="cactus.fetch-first", defaultValue="true")
    private boolean fetchFirst;
    @Parameter(property="cactus.create-branches", defaultValue="false")
    boolean createBranchesIfNeeded;
    @Parameter(property="cactus.create-local-branches", defaultValue="false")
    boolean createLocalBranchesIfNeeded;
    @Parameter(property="cactus.push", defaultValue="false")
    boolean push;
    @Parameter(property="cactus.target-branch")
    String targetBranch;
    @Parameter(property="cactus.base-branch", defaultValue="develop", required=true)
    String baseBranch = "develop";
    @Parameter(property="cactus.override-branch-in")
    String overrideBranchSubmodule;
    @Parameter(property="cactus.override-branch-with")
    String overrideBranchWith;
    @Parameter(property="cactus.permit-local-changes", defaultValue="false")
    boolean permitLocalChanges = false;

    @Override
    protected void execute(BuildLog log, MavenProject project, GitCheckout myCheckout, ProjectTree tree, List<GitCheckout> checkouts) throws Exception {
        GitCheckout root;
        checkouts.removeAll(tree.nonMavenCheckouts());
        this.includeOrRemoveRoot(checkouts, tree);
        if (this.fetchFirst) {
            this.fetchAll(checkouts);
            checkouts.forEach(tree::invalidateBranches);
        }
        if (checkouts.contains(root = tree.root()) && tree.isSubmoduleRoot(root)) {
            checkouts.remove(root);
            checkouts.add(0, root);
        }
        ArrayList<BranchingBehavior> changers = new ArrayList<BranchingBehavior>();
        int nonNoOpCount = 0;
        for (GitCheckout co : checkouts) {
            BranchingBehavior behavior = this.branchChangerFor(tree, co, log);
            changers.add(behavior);
            if (behavior.isNoOp()) continue;
            ++nonNoOpCount;
        }
        if (nonNoOpCount == 0) {
            log.info("All checkouts already on branch " + (this.targetBranch == null ? this.baseBranch : this.targetBranch) + " or no such branch exists for them and we were not told to create one.");
            return;
        }
        Collections.sort(changers);
        this.validateBehaviorsCanRun(changers);
        for (BranchingBehavior beh : changers) {
            beh.run();
        }
        Collections.reverse(changers);
        for (BranchingBehavior beh : changers) {
            beh.postRun();
        }
        if ((this.createBranchesIfNeeded || this.createLocalBranchesIfNeeded) && this.isIncludeRoot() && tree.isSubmoduleRoot(root) && tree.isDirty(root)) {
            CommitMessage msg = new CommitMessage(this.getClass(), ".gitmodules update for " + this.targetBranch);
            msg.section("Branched", sec -> changers.forEach(ch -> sec.bulletPoint(ch.checkout.loggingName() + ": " + ch)));
            if (!this.isPretend()) {
                root.addAll();
                root.commit(msg.toString());
            }
        }
        if (this.push && this.isIncludeRoot()) {
            switch (root.needsPush()) {
                case YES: {
                    log.info("Push submodule root");
                    if (this.isPretend()) break;
                    tree.root().push();
                    break;
                }
                case REMOTE_BRANCH_DOES_NOT_EXIST: {
                    log.info("Push submodule root creating new branch " + tree.root().branch());
                    if (this.isPretend()) break;
                    tree.root().pushCreatingBranch();
                }
            }
        }
    }

    @Override
    protected void onValidateParameters(BuildLog log, MavenProject project) throws Exception {
        this.validateBranchName(this.targetBranch, true);
        this.validateBranchName(this.baseBranch, false);
        this.validateBranchName(this.overrideBranchWith, true);
        if (this.overrideBranchWith == null != (this.overrideBranchSubmodule == null)) {
            this.fail("Either override-branch-in and override-branch-with must BOTH be set, or neither, but have overrideBranchSubmodule=" + this.overrideBranchSubmodule + " and overrideBranchWith=" + this.overrideBranchWith);
        }
    }

    private BranchingBehavior branchChangerFor(ProjectTree tree, GitCheckout checkout, BuildLog log) {
        if (this.isOverrideCheckout(checkout, tree)) {
            log.info("Have override ref for '" + checkout.name() + "' - bypassing checks and will attempt to blindly check out '" + this.overrideBranchWith + " (presumably a PR).  This may fail.");
            return new SwitchToExistingLocalBranch(tree, checkout, log, this.overrideBranchWith, this.isPretend(), this.permitLocalChanges, this.isIncludeRoot());
        }
        Branches br = tree.branches(checkout);
        Optional<Branches.Branch> baseOpt = this.baseBranchFor(checkout, tree, this.baseBranch, log);
        if (baseOpt.isEmpty()) {
            return new FailureBranching(tree, checkout, log, this.baseBranch, this.isPretend(), "No branch named '" + this.baseBranch + "' in " + checkout.name() + ": " + br);
        }
        Branches.Branch base = baseOpt.get();
        Optional current = br.currentBranch();
        log.info(checkout.name() + ": Base branch " + base.trackingName() + " current " + current + " create? " + this.createBranchesIfNeeded + " base " + this.baseBranch + " target " + this.targetBranch);
        if (this.targetBranch == null) {
            if (base.isRemote()) {
                if (!this.createBranchesIfNeeded && !this.createLocalBranchesIfNeeded) {
                    return new FailureBranching(tree, checkout, log, this.baseBranch, this.isPretend(), "No local branch '" + this.baseBranch + "' and createBranchesIfNeeded is false - will not create it.");
                }
                return new CreateAndSwitchToBranch(tree, checkout, log, this.baseBranch, this.isPretend(), base.trackingName(), this.permitLocalChanges, this.isIncludeRoot(), this.push);
            }
            if (current.isPresent()) {
                if (((Branches.Branch)current.get()).equals((Object)base)) {
                    if (checkout.needsPull()) {
                        return new PullOnly(tree, checkout, log, this.baseBranch);
                    }
                    log.info("Use do nothing for " + checkout.loggingName());
                    return new DoNothing(tree, checkout, log, this.baseBranch);
                }
                return new SwitchToExistingLocalBranch(tree, checkout, log, base.name(), this.isPretend(), this.permitLocalChanges, this.isIncludeRoot());
            }
            return new SwitchToExistingLocalBranch(tree, checkout, log, base.name(), this.isPretend(), this.permitLocalChanges, this.isIncludeRoot());
        }
        String realTargetBranch = this.targetBranchFor(checkout, tree);
        if (current.isPresent() && ((Branches.Branch)current.get()).name().equals(realTargetBranch)) {
            if (checkout.needsPull()) {
                return new PullOnly(tree, checkout, log, this.baseBranch);
            }
            log.info("Use do nothing 2 for " + checkout.loggingName() + " target " + realTargetBranch);
            return new DoNothing(tree, checkout, log, this.targetBranch);
        }
        Optional target = br.localOrRemoteBranch(realTargetBranch);
        if (target.isPresent()) {
            Branches.Branch existingTargetBranch = (Branches.Branch)target.get();
            if (existingTargetBranch.isLocal()) {
                return new SwitchToExistingLocalBranch(tree, checkout, log, realTargetBranch, this.isPretend(), this.permitLocalChanges, this.isIncludeRoot());
            }
            if (this.createBranchesIfNeeded) {
                return new CreateAndSwitchToBranch(tree, checkout, log, realTargetBranch, this.isPretend(), existingTargetBranch.trackingName(), this.permitLocalChanges, this.isIncludeRoot(), this.push);
            }
            if (current.isPresent() && ((Branches.Branch)current.get()).name().equals(this.baseBranch)) {
                if (checkout.needsPull()) {
                    return new PullOnly(tree, checkout, log, this.baseBranch);
                }
                log.info("Use do nothing 3 for " + checkout.loggingName() + " current " + current.get());
                return new DoNothing(tree, checkout, log, this.baseBranch);
            }
            return new SwitchToExistingLocalBranch(tree, checkout, log, this.baseBranch, this.isPretend(), this.permitLocalChanges, this.isIncludeRoot());
        }
        if (this.createBranchesIfNeeded) {
            boolean isRoot = tree.isSubmoduleRoot(checkout);
            boolean localChangesOk = this.permitLocalChanges || isRoot;
            String theBase = base.trackingName();
            if (current.isPresent() && ((Branches.Branch)current.get()).name().equals(base.name())) {
                log.info("Current branch for " + checkout.loggingName() + " is same as  " + base + " will branch off of the local branch, not the remote head.");
                theBase = null;
                localChangesOk = true;
            }
            if (theBase != null && isRoot && tree.isDirty(checkout) && current.isPresent()) {
                theBase = null;
                localChangesOk = true;
            }
            return new CreateAndSwitchToBranch(tree, checkout, log, realTargetBranch, this.isPretend(), theBase, localChangesOk, this.isIncludeRoot(), this.push);
        }
        if (current.isPresent() && ((Branches.Branch)current.get()).name().equals(this.baseBranch)) {
            return new DoNothing(tree, checkout, log, this.baseBranch);
        }
        return new FailureBranching(tree, checkout, log, this.targetBranch, this.isPretend(), "Branch '" + this.targetBranch + "' does not exist locally or remotely for " + checkout.loggingName() + ", and createBranchesIfNeeded is false, so we will not create it.");
    }

    private Optional<Branches.Branch> baseBranchFor(GitCheckout checkout, ProjectTree tree, String realTargetBranch, BuildLog log) {
        Branches br = tree.branches(checkout);
        Optional currOpt = br.currentBranch();
        if (!currOpt.isPresent()) {
            log.info(checkout.loggingName() + " is not on any branch - will prefer the remote head of " + this.baseBranch + " to branch from.");
            return br.find(realTargetBranch, false).or(() -> br.find(realTargetBranch, true));
        }
        Branches.Branch curr = (Branches.Branch)currOpt.get();
        if (curr.name().equals(this.baseBranch)) {
            log.info(checkout.loggingName() + " already on the base branch " + this.baseBranch + ".  Will create branch from the local, not remote head of it.");
            return br.find(realTargetBranch, true).or(() -> br.find(realTargetBranch, false));
        }
        log.info(checkout.loggingName() + " is not on the base branch " + this.baseBranch + ".  Will create branch from the remote, not local head of it, in case there are changes locally that should not be incorporated into that branch.");
        return br.find(realTargetBranch, false).or(() -> br.find(realTargetBranch, true));
    }

    private void fetchAll(List<GitCheckout> checkouts) {
        for (GitCheckout co : checkouts) {
            this.log().info("Fetch all in " + co.loggingName());
            co.fetchAll();
        }
    }

    private void includeOrRemoveRoot(List<GitCheckout> checkouts, ProjectTree tree) {
        if (this.isIncludeRoot()) {
            if (!checkouts.contains(tree.root())) {
                checkouts.add(0, tree.root());
            }
        } else {
            checkouts.remove(tree.root());
        }
    }

    private boolean isOverrideCheckout(GitCheckout checkout, ProjectTree tree) {
        if (this.overrideBranchSubmodule != null && (Objects.equals(this.targetBranch, this.overrideBranchWith) || this.targetBranch == null && this.baseBranch.equals(this.overrideBranchWith))) {
            return false;
        }
        if (this.overrideBranchSubmodule != null && !tree.isSubmoduleRoot(checkout)) {
            String relPath = (String)checkout.submoduleRelativePath().map(Path::toString).orElse((Object)"---");
            return this.overrideBranchSubmodule.equals(checkout.name()) || relPath.equals(this.overrideBranchSubmodule);
        }
        return false;
    }

    private String targetBranch(GitCheckout checkout, ProjectTree tree) {
        if (this.overrideBranchSubmodule != null && !tree.isSubmoduleRoot(checkout)) {
            String relPath = (String)checkout.submoduleRelativePath().map(Path::toString).orElse((Object)"---");
            if (this.overrideBranchSubmodule.equals(checkout.name()) || relPath.equals(this.overrideBranchSubmodule)) {
                return this.overrideBranchWith;
            }
        }
        return this.targetBranch;
    }

    private String targetBranchFor(GitCheckout checkout, ProjectTree tree) {
        String tb = this.targetBranch(checkout, tree);
        return tb == null ? this.baseBranch : tb;
    }

    private void validateBehaviorsCanRun(List<BranchingBehavior> changers) throws Exception {
        ArrayList problems = new ArrayList();
        for (BranchingBehavior beh : changers) {
            beh.validate(problems);
        }
        if (!problems.isEmpty()) {
            this.fail("Cannot change all branches to '" + (this.targetBranch == null ? this.baseBranch : this.targetBranch) + ":\n" + Strings.join((String)"\n", problems));
        }
    }

    private static abstract class BranchingBehavior
    implements Comparable<BranchingBehavior> {
        protected final ProjectTree tree;
        protected final GitCheckout checkout;
        protected final BuildLog log;
        protected final String targetBranch;
        protected final boolean pretend;
        private boolean succeeded;
        private final boolean allowLocalChangesIfPossible;
        private final boolean isRoot;
        private final boolean updateRoot;
        Boolean isSubroot;

        protected BranchingBehavior(ProjectTree tree, GitCheckout checkout, BuildLog log, String targetBranch, boolean pretend, boolean allowLocalChangesIfPossible, boolean updateRoot) {
            this.tree = tree;
            this.checkout = checkout;
            this.targetBranch = targetBranch;
            this.pretend = pretend;
            this.updateRoot = updateRoot;
            this.allowLocalChangesIfPossible = allowLocalChangesIfPossible;
            this.isRoot = checkout.equals((Object)tree.root());
            this.log = log.child(this.getClass().getSimpleName()).child(checkout.loggingName());
        }

        @Override
        public int compareTo(BranchingBehavior o) {
            if (this.isRoot != o.isRoot) {
                if (this.isRoot) {
                    return -1;
                }
                return 1;
            }
            return -GitCheckout.depthFirstCompare((GitCheckout)this.checkout, (GitCheckout)o.checkout());
        }

        public boolean isNoOp() {
            return false;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "(" + this.checkout.name() + " -> " + this.targetBranch + ")";
        }

        protected void onPostRun() throws Exception {
        }

        protected abstract boolean performBranchChange() throws Exception;

        protected void updateRootCheckout() throws Exception {
            if (this.succeeded() && !this.isSubmoduleRoot()) {
                this.withSubmoduleRoot((ThrowingConsumer<GitCheckout>)((ThrowingConsumer)subroot -> {
                    if (!GitCheckout.isGitCommitId((String)this.targetBranch)) {
                        this.log.info("Update .gitmodules for " + this.checkout.name() + " -> " + this.targetBranch);
                        this.checkout.submoduleRelativePath().ifPresent(path -> subroot.setSubmoduleBranch(path.toString(), this.targetBranch));
                    }
                }));
            } else if (this.isSubmoduleRoot() && this.checkout.isDirtyIgnoringModifiedSubmodules()) {
                this.log.info("Generated local modifications in submodule root - creating a commit");
                this.checkout.addAll();
                this.checkout.commit("cactus-maven: Create or move branch " + this.targetBranch + " to new heads in " + this.checkout.loggingName());
            }
        }

        protected final void withSubmoduleRoot(ThrowingConsumer<GitCheckout> c) throws Exception {
            if (this.tree.root().isSubmoduleRoot()) {
                c.accept((Object)this.tree.root());
            }
        }

        boolean canTolerateLocalChanges() {
            return false;
        }

        GitCheckout checkout() {
            return this.checkout;
        }

        boolean isRoot() {
            return this.isRoot;
        }

        boolean isSubmoduleRoot() {
            return this.isSubroot == null ? (this.isSubroot = Boolean.valueOf(this.isRoot && this.checkout.isSubmoduleRoot())) : this.isSubroot;
        }

        boolean isUpdateRoot() {
            return this.updateRoot;
        }

        final void postRun() throws Exception {
            if (this.succeeded() && !this.pretend) {
                this.onPostRun();
            }
        }

        final void run() throws Exception {
            this.log.info(Strings.camelCaseToDelimited((CharSequence)this.getClass().getSimpleName(), (char)' ') + " " + this.checkout.name() + " -> " + this.targetBranch);
            if (!this.pretend) {
                this.succeeded = this.performBranchChange();
                if (this.succeeded) {
                    this.tree.invalidateBranches(this.checkout);
                }
            }
        }

        boolean succeeded() {
            return this.succeeded;
        }

        String targetBranch() {
            return this.targetBranch;
        }

        void validate(Collection<? super String> problems) throws Exception {
            if (!(this.allowLocalChangesIfPossible && this.canTolerateLocalChanges() || !this.tree.isDirty(this.checkout))) {
                if (this.isSubmoduleRoot()) {
                    return;
                }
                if (!this.tree.isDirtyIgnoringSubmoduleCommits(this.checkout)) {
                    problems.add("Have local changes in " + this.checkout.loggingName() + " - cannot proceed to change to branch " + this.targetBranch);
                }
            }
        }
    }

    private static final class SwitchToExistingLocalBranch
    extends BranchingBehavior {
        SwitchToExistingLocalBranch(ProjectTree tree, GitCheckout checkout, BuildLog log, String targetBranch, boolean pretend, boolean allowLocalChangesIfPossible, boolean updateRoot) {
            super(tree, checkout, log, targetBranch, pretend, allowLocalChangesIfPossible, updateRoot);
        }

        @Override
        protected void onPostRun() throws Exception {
            if (this.checkout.needsPull()) {
                this.checkout.pull();
            }
            if (!this.isUpdateRoot()) {
                return;
            }
            this.updateRootCheckout();
        }

        @Override
        protected boolean performBranchChange() {
            try {
                boolean result = this.checkout.switchToBranch(this.targetBranch);
                boolean bl = true;
                return bl;
            }
            finally {
                this.tree.invalidateBranches(this.checkout);
            }
        }

        @Override
        boolean canTolerateLocalChanges() {
            return true;
        }
    }

    private static final class FailureBranching
    extends BranchingBehavior {
        private final String failure;

        FailureBranching(ProjectTree tree, GitCheckout checkout, BuildLog log, String targetBranch, boolean pretend, String failure) {
            super(tree, checkout, log, targetBranch, pretend, false, false);
            this.failure = failure;
        }

        @Override
        protected void onPostRun() throws Exception {
            throw new MojoFailureException("Should not be called for " + this);
        }

        @Override
        protected boolean performBranchChange() throws Exception {
            throw new MojoFailureException("Should not be called for " + this);
        }

        @Override
        void validate(Collection<? super String> problems) {
            problems.add(this.failure);
        }
    }

    private static final class CreateAndSwitchToBranch
    extends BranchingBehavior {
        private final String baseBranch;
        private final boolean push;

        CreateAndSwitchToBranch(ProjectTree tree, GitCheckout checkout, BuildLog log, String targetBranch, boolean pretend, String baseBranch, boolean allowLocalChangesIfPossible, boolean updateRoot, boolean push) {
            super(tree, checkout, log, targetBranch, pretend, allowLocalChangesIfPossible, updateRoot);
            this.baseBranch = baseBranch;
            this.push = push;
        }

        @Override
        public String toString() {
            return "Create and switch to branch " + this.targetBranch + " based on " + (this.baseBranch == null ? " the current branch " : this.baseBranch) + " in " + this.checkout.loggingName() + " push? " + this.push + " is-root? " + this.isSubmoduleRoot();
        }

        @Override
        protected void onPostRun() throws Exception {
            if (this.push) {
                this.checkout.pushCreatingBranch();
            }
            if (this.isUpdateRoot() && !this.checkout.isSubmoduleRoot() && this.checkout.isSubmodule()) {
                this.updateRootCheckout();
            }
        }

        @Override
        protected boolean performBranchChange() {
            try {
                this.checkout.createAndSwitchToBranch(this.targetBranch, Optional.ofNullable(this.baseBranch));
                boolean bl = true;
                return bl;
            }
            finally {
                this.tree.invalidateBranches(this.checkout);
            }
        }
    }

    private static final class PullOnly
    extends BranchingBehavior {
        PullOnly(ProjectTree tree, GitCheckout checkout, BuildLog log, String targetBranch) {
            super(tree, checkout, log, targetBranch, true, false, false);
        }

        @Override
        public boolean isNoOp() {
            return true;
        }

        @Override
        protected boolean performBranchChange() {
            if (this.checkout.needsPull()) {
                try {
                    boolean root = this.tree.isSubmoduleRoot(this.checkout);
                    if (root) {
                        this.log.info("Pull submodule root " + this.checkout.loggingName() + " on " + this.targetBranch + " with --rebase");
                        this.checkout.pullWithRebase();
                    } else {
                        this.log.info("Pull " + this.checkout.loggingName() + " on " + this.targetBranch);
                        this.checkout.pull();
                    }
                }
                finally {
                    this.tree.invalidateBranches(this.checkout);
                }
            }
            return true;
        }

        @Override
        void validate(Collection<? super String> problems) {
        }
    }

    private static final class DoNothing
    extends BranchingBehavior {
        DoNothing(ProjectTree tree, GitCheckout checkout, BuildLog log, String targetBranch) {
            super(tree, checkout, log, targetBranch, true, false, false);
        }

        @Override
        public boolean isNoOp() {
            return true;
        }

        @Override
        boolean canTolerateLocalChanges() {
            return true;
        }

        @Override
        protected boolean performBranchChange() {
            this.log.info("No change needed for " + this.checkout.name() + " -> " + this.targetBranch);
            return true;
        }

        @Override
        void validate(Collection<? super String> problems) {
        }
    }
}

