/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.maven;

import com.telenav.cactus.maven.log.BuildLog;
import com.telenav.cactus.maven.mojobase.BaseMojo;
import com.telenav.cactus.maven.mojobase.BaseMojoGoal;
import com.telenav.cactus.scope.ProjectFamily;
import com.telenav.cactus.util.PathUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.InstantiationStrategy;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@BaseMojoGoal(value="clean-caches")
@Mojo(defaultPhase=LifecyclePhase.CLEAN, requiresDependencyResolution=ResolutionScope.NONE, instantiationStrategy=InstantiationStrategy.SINGLETON, name="clean-caches", threadSafe=true)
public class CleanCachesMojo
extends BaseMojo {
    private static final Set<Path> seen = ConcurrentHashMap.newKeySet();
    @Parameter(property="cactus.cache-finding-strategy", defaultValue="byGroupIdVersion")
    private String cacheFindingStrategy;

    @Override
    protected void performTasks(BuildLog log, MavenProject project) throws Exception {
        CacheFindingStrategy strategy = CacheFindingStrategy.find(this.cacheFindingStrategy);
        strategy.deleteCache(project, log, seen);
    }

    public static enum CacheFindingStrategy {
        temporary,
        byFamily,
        byFamilyAndVersion,
        byFamiilyArtifactIdVersion;


        public static CacheFindingStrategy find(String injected) throws MojoExecutionException {
            if (injected == null) {
                return byFamilyAndVersion;
            }
            for (CacheFindingStrategy strategy : CacheFindingStrategy.values()) {
                if (!strategy.name().equalsIgnoreCase(injected)) continue;
                return strategy;
            }
            String msg = "Requested strategy '" + injected + " is not one of " + Arrays.toString((Object[])CacheFindingStrategy.values());
            throw new MojoExecutionException(CacheFindingStrategy.class, msg, msg);
        }

        public Path cacheDir(MavenProject project) {
            switch (this) {
                case temporary: {
                    return PathUtils.temp().resolve(ProjectFamily.fromGroupId((String)project.getGroupId()).name()).resolve(project.getVersion());
                }
                case byFamilyAndVersion: {
                    return PathUtils.userCacheRoot().resolve(ProjectFamily.fromGroupId((String)project.getGroupId()).name()).resolve(project.getVersion());
                }
                case byFamiilyArtifactIdVersion: {
                    return PathUtils.userCacheRoot().resolve(ProjectFamily.fromGroupId((String)project.getGroupId()).name()).resolve(project.getArtifactId()).resolve(project.getVersion());
                }
                case byFamily: {
                    return PathUtils.userCacheRoot().resolve(project.getGroupId());
                }
            }
            throw new AssertionError((Object)this);
        }

        public void deleteCache(MavenProject project, BuildLog log, Set<Path> seen) throws IOException {
            Path dir = this.cacheDir(project);
            if (seen.contains(dir)) {
                return;
            }
            log = log.child("deleteCacheWithSubtree").child(this.name());
            if (!Files.exists(dir, new LinkOption[0])) {
                log.info("Cache dir does not exist:" + dir).info("Doing nothing.");
            } else {
                log.info("Delete cache dir " + dir);
                PathUtils.deleteWithSubtree((Path)dir);
            }
        }
    }
}

